/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin;

import com.bbn.openmap.io.CSVFile;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMScalingRaster;
import com.bbn.openmap.plugin.OMGraphicHandlerPlugIn;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileCacheImageInputStream;

public class CSVTiledImagePlugIn
extends OMGraphicHandlerPlugIn {
    protected HashSet tiles = new HashSet();
    protected boolean DEBUG = false;
    public static final String CSVFileNameProperty = "tileFile";
    public static final String FileHasHeaderProperty = "fileHasHeader";
    protected String tileFileName = null;
    protected boolean fileHasHeader = true;
    protected CSVFile tilefile = null;
    public int ullatIndex = 0;
    public int ullonIndex = 1;
    public int lrlatIndex = 2;
    public int lrlonIndex = 3;
    public int urlIndex = 4;

    public CSVTiledImagePlugIn() {
        this.DEBUG = Debug.debugging("tiledimage");
    }

    public CSVTiledImagePlugIn(Component comp) {
        super(comp);
    }

    public OMGraphicList getRectangle(Projection p) {
        OMGraphicList list = this.getList();
        list.clear();
        if (this.DEBUG) {
            Debug.output("CSVTIPI: getRectangle");
        }
        if (this.tilefile == null) {
            this.loadTiles(this.tileFileName);
        }
        for (OMScalingRaster tile : this.tiles) {
            if (tile.isOnMap(p)) {
                if (this.DEBUG) {
                    Debug.output("CSVTIPI: image on map");
                }
                tile.generate(p);
                list.add(tile);
                continue;
            }
            if (!this.DEBUG) continue;
            Debug.output("CSVTIPI: image not on map, skipping");
        }
        this.repaint();
        return list;
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.tileFileName = props.getProperty(realPrefix + CSVFileNameProperty);
        if (this.DEBUG) {
            Debug.output("CSVTIPI: file: " + this.tileFileName);
        }
        this.fileHasHeader = PropUtils.booleanFromProperties(props, realPrefix + FileHasHeaderProperty, this.fileHasHeader);
        if (this.DEBUG) {
            Debug.output("CSVTIPI: file has header: " + this.fileHasHeader);
        }
    }

    protected void loadTiles(String csvFileName) {
        int imageCount = 0;
        if (csvFileName != null) {
            try {
                this.tilefile = new CSVFile(csvFileName);
                this.tilefile.setHeadersExist(this.fileHasHeader);
                this.tilefile.loadData(false);
                for (Vector<Object> record : this.tilefile) {
                    if (this.DEBUG) {
                        Debug.output("CSVTIPI: record: " + record);
                    }
                    String imageURLString = null;
                    try {
                        float ullat = ((Double)record.get(this.ullatIndex)).floatValue();
                        float ullon = ((Double)record.get(this.ullonIndex)).floatValue();
                        float lrlat = ((Double)record.get(this.lrlatIndex)).floatValue();
                        float lrlon = ((Double)record.get(this.lrlonIndex)).floatValue();
                        imageURLString = (String)record.get(this.urlIndex);
                        URL imageURL = PropUtils.getResourceOrFileOrURL(imageURLString);
                        FileCacheImageInputStream fciis = new FileCacheImageInputStream(imageURL.openStream(), null);
                        BufferedImage fileImage = ImageIO.read(fciis);
                        OMScalingRaster omsr = new OMScalingRaster((double)ullat, (double)ullon, (double)lrlat, (double)lrlon, (Image)fileImage);
                        this.tiles.add(omsr);
                        ++imageCount;
                    }
                    catch (MalformedURLException innerMurle) {
                        Debug.error("CSVTiledImagePlugIn: image tile path not valid: " + imageURLString + ", skipping...");
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        Debug.error("CSVTiledImagePlugIn: having trouble reading line (" + imageCount + "), skipping...\n" + aioobe.getMessage());
                    }
                    catch (IOException ioe) {
                        Debug.error("CSVTiledImagePlugIn: having trouble reading line (" + imageCount + "), skipping...\n" + ioe.getMessage());
                    }
                }
            }
            catch (MalformedURLException murle) {
                Debug.error("CSVTiledImagePlugIn: CSV tile file not valid: " + csvFileName);
            }
        }
    }

    public Properties getProperties(Properties getList) {
        if (getList == null) {
            getList = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        getList.put(prefix + CSVFileNameProperty, PropUtils.unnull(this.tileFileName));
        getList.put(prefix + FileHasHeaderProperty, new Boolean(this.fileHasHeader).toString());
        return getList;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        list.put(CSVFileNameProperty, "URL to CSV data file");
        list.put(FileHasHeaderProperty, "Flag to note if CSV file has descriptive header line");
        list.put("fileHasHeader.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        return list;
    }

    public boolean isFileHasHeader() {
        return this.fileHasHeader;
    }

    public void setFileHasHeader(boolean fileHasHeader) {
        this.fileHasHeader = fileHasHeader;
    }

    public int getLrlatIndex() {
        return this.lrlatIndex;
    }

    public void setLrlatIndex(int lrlatIndex) {
        this.lrlatIndex = lrlatIndex;
    }

    public int getLrlonIndex() {
        return this.lrlonIndex;
    }

    public void setLrlonIndex(int lrlonIndex) {
        this.lrlonIndex = lrlonIndex;
    }

    public CSVFile getTilefile() {
        return this.tilefile;
    }

    public void setTilefile(CSVFile tilefile) {
        this.tilefile = tilefile;
    }

    public String getTileFileName() {
        return this.tileFileName;
    }

    public void setTileFileName(String tileFileName) {
        this.tileFileName = tileFileName;
    }

    public HashSet getTiles() {
        return this.tiles;
    }

    public void setTiles(HashSet tiles) {
        this.tiles = tiles;
    }

    public int getUllatIndex() {
        return this.ullatIndex;
    }

    public void setUllatIndex(int ullatIndex) {
        this.ullatIndex = ullatIndex;
    }

    public int getUllonIndex() {
        return this.ullonIndex;
    }

    public void setUllonIndex(int ullonIndex) {
        this.ullonIndex = ullonIndex;
    }

    public int getUrlIndex() {
        return this.urlIndex;
    }

    public void setUrlIndex(int urlIndex) {
        this.urlIndex = urlIndex;
    }
}

