/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.time;

import com.bbn.openmap.omGraphics.OMScalingIcon;
import com.bbn.openmap.omGraphics.time.TemporalOMGraphic;
import com.bbn.openmap.omGraphics.time.TemporalPoint;
import com.bbn.openmap.omGraphics.time.TemporalPointSupport;
import com.bbn.openmap.omGraphics.time.TemporalRecord;
import com.bbn.openmap.proj.Projection;
import java.awt.Color;
import java.awt.Image;
import java.awt.geom.Point2D;
import javax.swing.ImageIcon;

public class TemporalOMScalingIcon
extends OMScalingIcon
implements TemporalOMGraphic {
    protected Object id;
    protected TemporalPointSupport timeStamps;
    protected boolean interpolate = false;

    public TemporalOMScalingIcon(Object id, int renderType, boolean interpolate) {
        this.id = id;
        this.interpolate = interpolate;
        this.setRenderType(renderType);
        this.timeStamps = new TemporalPointSupport(renderType);
    }

    public TemporalOMScalingIcon(Object id, int renderType, boolean interpolate, int w, int h, int[] pix, float baseScale) {
        this(id, renderType, interpolate);
        this.setColorModel(0);
        this.setWidth(w);
        this.setHeight(h);
        this.setPixels(pix);
        this.baseScale = baseScale;
    }

    public TemporalOMScalingIcon(Object id, int renderType, boolean interpolate, ImageIcon ii, float baseScale) {
        this(id, renderType, interpolate);
        this.setWidth(ii.getIconWidth());
        this.setHeight(ii.getIconHeight());
        this.setColorModel(2);
        this.setImage(ii.getImage());
        this.setBaseScale(baseScale);
    }

    public TemporalOMScalingIcon(Object id, int renderType, boolean interpolate, ImageIcon ii) {
        this(id, renderType, interpolate, ii.getImage(), 4000000.0f);
        this.setMaxScale(4000000.0f);
        this.setMinScale(4000000.0f);
    }

    public TemporalOMScalingIcon(Object id, int renderType, boolean interpolate, Image ii, float baseScale) {
        this(id, renderType, interpolate);
        this.setColorModel(2);
        this.setImage(ii);
        this.setBaseScale(baseScale);
    }

    public TemporalOMScalingIcon(Object id, int renderType, boolean interpolate, Image image) {
        this(id, renderType, interpolate);
        this.setColorModel(2);
        this.setImage(image);
        this.setBaseScale(4.0E7f);
        this.setMaxScale(4000000.0f);
        this.setMinScale(4000000.0f);
    }

    public TemporalOMScalingIcon(Object id, int renderType, boolean interpolate, int w, int h, byte[] bytes, Color[] colorTable, int trans, float baseScale) {
        this(id, renderType, interpolate);
        this.setColorModel(1);
        this.setBaseScale(baseScale);
        this.setWidth(w);
        this.setHeight(h);
        this.setBits(bytes);
        this.setColors(colorTable);
        this.setTransparent(trans);
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public boolean isInterpolate() {
        return this.interpolate;
    }

    public void setInterpolate(boolean interpolate) {
        this.interpolate = interpolate;
    }

    public boolean thisIsYou(Object n) {
        return this.id.equals(n);
    }

    public void addTimeStamp(TemporalRecord timeStamp) {
        this.timeStamps.add(timeStamp);
        this.setNeedToRegenerate(true);
    }

    public boolean removeTimeStamp(TemporalRecord timeStamp) {
        return this.timeStamps.remove(timeStamp);
    }

    public void clearTimeStamps() {
        this.timeStamps.clear();
    }

    public TemporalPoint setPosition(long time) {
        return (TemporalPoint)this.timeStamps.getPosition(time, this.interpolate);
    }

    public void generate(Projection p, long time) {
        TemporalPoint tp = this.setPosition(time);
        if (tp == null) {
            return;
        }
        Point2D pt = tp.getLocation();
        switch (this.renderType) {
            case 2: {
                this.setX((int)pt.getX());
                this.setY((int)pt.getY());
                break;
            }
            default: {
                this.setLat(pt.getY());
                this.setLon(pt.getX());
            }
        }
        super.generate(p);
    }
}

