/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.editable;

import com.bbn.openmap.layer.util.stateMachine.State;
import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.EditableOMPoly;
import com.bbn.openmap.omGraphics.GrabPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.editable.EOMGCursors;
import com.bbn.openmap.util.Debug;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class PolyAddNodeState
extends State {
    protected EditableOMGraphic graphic;

    public PolyAddNodeState(EditableOMPoly eomg) {
        this.graphic = eomg;
    }

    public boolean mouseReleased(MouseEvent e) {
        Debug.message("eomg", "GraphicStateMachine|add node state|mouseReleased");
        GrabPoint mp = this.graphic.getMovingPoint(e);
        if (mp == null && this.graphic.isMouseEventTouching(e)) {
            int index;
            OMPoly poly = (OMPoly)this.graphic.getGraphic();
            double x = e.getX();
            double y = e.getY();
            if (poly.getRenderType() == 1) {
                Object llp = this.graphic.getProjection().inverse(x, y);
                x = ((Point2D)llp).getX();
                y = ((Point2D)llp).getY();
            }
            if ((index = poly.getIndexOfFirstNodeOfSegIntersect(x, y, 2.0)) != -1) {
                ((EditableOMPoly)this.graphic).addPoint(e.getX(), e.getY(), index + 1);
                this.graphic.fireEvent(2);
            }
            this.graphic.fireEvent(EOMGCursors.DEFAULT, "", e, 6);
        }
        this.graphic.getStateMachine().setSelected();
        this.graphic.redraw(e, true);
        return false;
    }

    public boolean mouseMoved(MouseEvent e) {
        Debug.message("eomgdetail", "PolyStateMachine|add node state|mouseMoved");
        if (this.graphic.isMouseEventTouching(e)) {
            this.graphic.fireEvent(EOMGCursors.EDIT, this.i18n.get(PolyAddNodeState.class, "Click_between_nodes_to_add_another_node.", "Click between nodes to add another node."), e, -1);
        } else {
            this.graphic.fireEvent(EOMGCursors.DEFAULT, this.i18n.get(PolyAddNodeState.class, "Click_between_nodes_to_add_another_node.", "Click between nodes to add another node."), e, -1);
        }
        return false;
    }

    public boolean mouseDragged(MouseEvent e) {
        Debug.message("eomgdetail", "PolyStateMachine|add node state|mouseDragged");
        if (this.graphic.getGraphic().distance(e.getX(), e.getY()) < 2.0f) {
            this.graphic.fireEvent(EOMGCursors.EDIT, this.i18n.get(PolyAddNodeState.class, "Release_between_nodes_to_add_a_node.", "Release between nodes to add a node."), e, -1);
        } else {
            this.graphic.fireEvent(EOMGCursors.DEFAULT, this.i18n.get(PolyAddNodeState.class, "Release_between_nodes_to_add_a_node.", "Release between nodes to add a node."), e, -1);
        }
        return false;
    }
}

