/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicAdapter;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class OMRect
extends OMGraphicAdapter
implements OMGraphic {
    protected int x1 = 0;
    protected int y1 = 0;
    protected double lat1 = 0.0;
    protected double lon1 = 0.0;
    protected int x2 = 0;
    protected int y2 = 0;
    protected double lat2 = 0.0;
    protected double lon2 = 0.0;
    protected int nsegs = -1;

    public OMRect() {
        super(0, 0, 0);
    }

    public OMRect(double lt1, double ln1, double lt2, double ln2, int lType) {
        this(lt1, ln1, lt2, ln2, lType, -1);
    }

    public OMRect(double lt1, double ln1, double lt2, double ln2, int lType, int nsegs) {
        super(1, lType, 0);
        this.lat1 = lt1;
        this.lon1 = ln1;
        this.lat2 = lt2;
        this.lon2 = ln2;
        this.nsegs = nsegs;
    }

    public OMRect(int px1, int py1, int px2, int py2) {
        super(2, 0, 0);
        this.x1 = px1;
        this.y1 = py1;
        this.x2 = px2;
        this.y2 = py2;
    }

    public OMRect(double lt1, double ln1, int px1, int py1, int px2, int py2) {
        super(3, 0, 0);
        this.lat1 = lt1;
        this.lon1 = ln1;
        this.x1 = px1;
        this.y1 = py1;
        this.x2 = px2;
        this.y2 = py2;
    }

    public void setLocation(double lt1, double ln1, double lt2, double ln2, int lType) {
        this.setRenderType(1);
        this.setLineType(lType);
        this.lat1 = lt1;
        this.lon1 = ln1;
        this.lat2 = lt2;
        this.lon2 = ln2;
        this.setNeedToRegenerate(true);
    }

    public void setLocation(int px1, int py1, int px2, int py2) {
        this.setRenderType(2);
        this.setLineType(0);
        this.x1 = Math.min(px1, px2);
        this.y1 = Math.min(py1, py2);
        this.x2 = Math.max(px1, px2);
        this.y2 = Math.max(py1, py2);
        this.setNeedToRegenerate(true);
    }

    public void setLocation(double lt1, double ln1, int px1, int py1, int px2, int py2) {
        this.setRenderType(3);
        this.setLineType(0);
        this.lat1 = lt1;
        this.lon1 = ln1;
        this.x1 = px1;
        this.y1 = py1;
        this.x2 = px2;
        this.y2 = py2;
        this.setNeedToRegenerate(true);
    }

    public double getNorthLat() {
        return this.lat1;
    }

    public double getWestLon() {
        return this.lon1;
    }

    public double getSouthLat() {
        return this.lat2;
    }

    public double getEastLon() {
        return this.lon2;
    }

    public int getTop() {
        return this.y1;
    }

    public int getLeft() {
        return this.x1;
    }

    public int getBottom() {
        return this.y2;
    }

    public int getRight() {
        return this.x2;
    }

    public void setNumSegs(int nsegs) {
        this.nsegs = nsegs;
    }

    public int getNumSegs() {
        return this.nsegs;
    }

    public boolean generate(Projection proj) {
        this.setShape(null);
        if (proj == null) {
            Debug.message("omgraphic", "OMRect: null projection in generate!");
            return false;
        }
        switch (this.renderType) {
            case 2: {
                this.setShape(OMRect.createBoxShape(Math.min(this.x2, this.x1), Math.min(this.y2, this.y1), Math.abs(this.x2 - this.x1), Math.abs(this.y2 - this.y1)));
                break;
            }
            case 3: {
                if (!proj.isPlotable(this.lat1, this.lon1)) {
                    this.setNeedToRegenerate(true);
                    return false;
                }
                Point p1 = (Point)proj.forward(this.lat1, this.lon1, (Point2D)new Point());
                this.setShape(OMRect.createBoxShape(Math.min(p1.x + this.x1, p1.x + this.x2), Math.min(p1.y + this.y1, p1.y + this.y2), Math.abs(this.x2 - this.x1), Math.abs(this.y2 - this.y1)));
                break;
            }
            case 1: {
                ArrayList<float[]> rects = proj instanceof GeoProj ? ((GeoProj)proj).forwardRect(new LatLonPoint.Double(this.lat1, this.lon1), new LatLonPoint.Double(this.lat2, this.lon2), this.lineType, this.nsegs, !this.isClear(this.fillPaint)) : proj.forwardRect(new Point2D.Double(this.lon1, this.lat1), new Point2D.Double(this.lon2, this.lat2));
                int size = rects.size();
                for (int i = 0; i < size; i += 2) {
                    GeneralPath gp = OMRect.createShape(rects.get(i), rects.get(i + 1), true);
                    if (this.shape == null) {
                        this.setShape(gp);
                        continue;
                    }
                    this.shape.append(gp, false);
                }
                break;
            }
            case 0: {
                System.err.println("OMRect.generate(): invalid RenderType");
                return false;
            }
        }
        this.setNeedToRegenerate(false);
        return true;
    }

    public void restore(OMGeometry source) {
        super.restore(source);
        if (source instanceof OMRect) {
            OMRect rect = (OMRect)source;
            this.x1 = rect.x1;
            this.y1 = rect.y1;
            this.lat1 = rect.lat1;
            this.lon1 = rect.lon1;
            this.x2 = rect.x2;
            this.y2 = rect.y2;
            this.lat2 = rect.lat2;
            this.lon2 = rect.lon2;
            this.nsegs = rect.nsegs;
        }
    }
}

