/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.DeepCopyUtil;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Paint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;

public class OMDistance
extends OMPoly {
    protected OMGraphicList labels = new OMGraphicList();
    protected OMGraphicList points = new OMGraphicList();
    protected Length distUnits = Length.NM;
    public DecimalFormat df = new DecimalFormat("0.#");
    protected Paint labelPaint;
    protected Font labelFont;
    protected boolean paintOnlyPoly = false;

    public OMDistance() {
        this.setRenderType(1);
    }

    public OMDistance(double[] llPoints, int units, int lType, Length distanceUnits) {
        this(llPoints, units, lType, -1, distanceUnits);
    }

    public OMDistance(double[] llPoints, int units, int lType, int nsegs, Length distanceUnits) {
        super(llPoints, units, lType, nsegs);
        this.setDistUnits(distanceUnits);
    }

    public void setDistUnits(Length distanceUnits) {
        this.distUnits = distanceUnits;
    }

    public Length getDistUnits() {
        return this.distUnits;
    }

    public void setLocation(double[] llPoints, int units) {
        this.units = 1;
        if (units == 0) {
            ProjMath.arrayDegToRad(llPoints);
        }
        this.rawllpts = llPoints;
        this.setNeedToRegenerate(true);
        this.setRenderType(1);
    }

    public void createLabels() {
        this.labels.clear();
        this.points.clear();
        if (this.rawllpts == null) {
            return;
        }
        if (this.rawllpts.length < 4) {
            return;
        }
        Geo lastGeo = new Geo(this.rawllpts[0], this.rawllpts[1], this.units == 0);
        double latpnt = this.rawllpts[0];
        double lonpnt = this.rawllpts[1];
        if (this.units == 1) {
            latpnt = ProjMath.radToDeg(latpnt);
            lonpnt = ProjMath.radToDeg(lonpnt);
        }
        this.points.add(new OMPoint(latpnt, lonpnt, 1));
        Geo curGeo = null;
        float cumulativeDist = 0.0f;
        for (int p = 2; p < this.rawllpts.length; p += 2) {
            if (curGeo == null) {
                curGeo = new Geo(this.rawllpts[p], this.rawllpts[p + 1], this.units == 0);
            } else if (this.units == 0) {
                curGeo.initialize(this.rawllpts[p], this.rawllpts[p + 1]);
            } else {
                curGeo.initializeRadians(this.rawllpts[p], this.rawllpts[p + 1]);
            }
            float dist = this.getDist(lastGeo, curGeo);
            this.labels.add(this.createLabel(lastGeo, curGeo, dist, cumulativeDist += dist, this.distUnits));
            latpnt = this.rawllpts[p];
            lonpnt = this.rawllpts[p + 1];
            if (this.units == 1) {
                latpnt = ProjMath.radToDeg(latpnt);
                lonpnt = ProjMath.radToDeg(lonpnt);
            }
            this.points.add(new OMPoint(latpnt, lonpnt, 1));
            lastGeo.initialize(curGeo);
        }
    }

    public OMText createLabel(Geo g1, Geo g2, float dist, float cumulativeDist, Length distanceUnits) {
        Geo mid;
        switch (this.getLineType()) {
            case 1: {
                float lat = (float)(g1.getLatitude() + g2.getLatitude()) / 2.0f;
                float lon = (float)(g1.getLongitude() + g2.getLongitude()) / 2.0f;
                mid = new Geo(lat, lon);
                break;
            }
            case 2: {
                System.err.println("Rhumb distance calculation not implemented.");
            }
            default: {
                mid = g1.midPoint(g2);
            }
        }
        String text = this.df.format(distanceUnits.fromRadians(dist)) + " (" + this.df.format(distanceUnits.fromRadians(cumulativeDist)) + ") " + distanceUnits.getAbbr();
        OMText omtext = new OMText((float)mid.getLatitude(), (float)mid.getLongitude(), text, 0);
        return omtext;
    }

    public float getDist(Geo g1, Geo g2) {
        switch (this.getLineType()) {
            case 1: {
                float lonDist = ProjMath.lonDistance((float)g2.getLongitude(), (float)g1.getLongitude());
                float latDist = (float)g2.getLatitude() - (float)g1.getLatitude();
                return (float)Math.sqrt(lonDist * lonDist + latDist * latDist);
            }
            case 2: {
                Debug.error("Rhumb distance calculation not implemented.");
            }
        }
        return (float)g1.distance(g2);
    }

    public boolean generate(Projection proj) {
        boolean ret = super.generate(proj);
        this.createLabels();
        this.labels.generate(proj);
        this.points.generate(proj);
        return ret;
    }

    public void render(Graphics g) {
        super.render(g);
        if (!this.paintOnlyPoly) {
            this.renderPoints(g);
            this.renderLabels(g);
        }
    }

    protected void renderPoints(Graphics g) {
        Paint pointPaint = this.getLabelPaint();
        for (OMPoint point : this.points) {
            point.setLinePaint(pointPaint);
            point.setFillPaint(pointPaint);
            point.render(g);
        }
    }

    protected void renderLabels(Graphics g) {
        Font f = this.getFont();
        Paint labelPaint = this.getLabelPaint();
        Paint mattingPaint = this.getMattingPaint();
        boolean isMatted = this.isMatted();
        for (OMText text : this.labels) {
            text.setFont(f);
            text.setLinePaint(labelPaint);
            if (isMatted) {
                text.setFillPaint(mattingPaint);
            }
            text.render(g);
        }
    }

    public void setLabelPaint(Paint lPaint) {
        this.labelPaint = lPaint;
    }

    public Paint getLabelPaint() {
        if (this.labelPaint == null) {
            return this.getLinePaint();
        }
        return this.labelPaint;
    }

    public void setFont(Font font) {
        this.labelFont = font == null ? OMText.DEFAULT_FONT : font;
    }

    public Font getFont() {
        if (this.labelFont == null) {
            this.labelFont = OMText.DEFAULT_FONT;
        }
        return this.labelFont;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.distUnits.getAbbr());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.distUnits = Length.get((String)stream.readObject());
    }

    public void restore(OMGeometry source) {
        super.restore(source);
        if (source instanceof OMDistance) {
            OMDistance dist = (OMDistance)source;
            this.labels = DeepCopyUtil.deepCopy(dist.labels);
            this.points = DeepCopyUtil.deepCopy(dist.points);
            this.distUnits = dist.distUnits;
            this.df = new DecimalFormat(dist.df.toLocalizedPattern());
            this.labelPaint = dist.labelPaint;
            if (dist.labelFont != null) {
                this.labelFont = dist.labelFont.deriveFont(0);
            }
        }
    }
}

