/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicHandler;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.util.Debug;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.io.Serializable;

public class FilterSupport
implements OMGraphicHandler,
Serializable {
    protected OMGraphicList list = null;
    protected boolean precise = true;
    protected boolean DEBUG = Debug.debugging("list");

    public FilterSupport() {
    }

    public FilterSupport(OMGraphicList omgl) {
        this.setList(omgl);
    }

    public OMGraphicList filter(Shape withinThisShape) {
        return this.filter(withinThisShape, true);
    }

    public OMGraphicList filter(Shape shapeBoundary, boolean getInsideBoundary) {
        Area area = null;
        if (shapeBoundary != null) {
            area = new Area(shapeBoundary);
        }
        if (Debug.debugging("filtersupportdetail")) {
            Debug.output(this.getList().getDescription());
        }
        return this.filterList(this.getList(), area, getInsideBoundary);
    }

    protected OMGraphicList filterList(OMGraphicList omgl, Area area, boolean getInsideArea) {
        boolean DEBUG;
        OMGraphicList ret = new OMGraphicList();
        boolean DEBUG_DETAIL = Debug.debugging("filtersupportdetail");
        boolean bl = DEBUG = Debug.debugging("filtersupport") || DEBUG_DETAIL;
        if (DEBUG) {
            Debug.output("FilterSupport.filterList");
        }
        int count = 0;
        if (area != null && omgl != null) {
            for (OMGraphic omg : omgl) {
                if (DEBUG) {
                    Debug.output("FilterSupport.filterList evaluating " + count++ + " OMGraphic, " + omg);
                }
                boolean outsideFilter = true;
                if (!omg.isVisible()) {
                    if (!DEBUG) continue;
                    Debug.output("   OMGraphic not visible, ignoring");
                    continue;
                }
                if (omg instanceof OMGraphicList) {
                    OMGraphicList subList;
                    if (omg == omgl) {
                        Debug.output("   OMGraphic is parent list (points to itself), ignoring...");
                        continue;
                    }
                    if (DEBUG) {
                        Debug.output("  (filterList recursiving handing OMGraphicList)");
                    }
                    if (!(subList = this.filterList((OMGraphicList)omg, area, getInsideArea)).isEmpty()) {
                        if (DEBUG) {
                            Debug.output("  +++ OMGraphicList's contents (" + subList.size() + ") pass filter, adding...");
                        }
                        if (((OMGraphicList)omg).isVague()) {
                            this.passedFilter(omg);
                            omg.setVisible(true);
                            ret.add(omg);
                            continue;
                        }
                        this.passedFilter(subList);
                        ret.add(subList);
                        continue;
                    }
                    if (DEBUG) {
                        Debug.output("  --- OMGraphicList's contents fail filter, ignoring...");
                    }
                    this.failedFilter(omg);
                    continue;
                }
                GeneralPath omgShape = omg.getShape();
                if (omgShape != null) {
                    if (omgShape.getBounds2D().getWidth() == 0.0 && omgShape.getBounds2D().getHeight() == 0.0) {
                        if (area.contains(omgShape.getBounds2D().getX(), omgShape.getBounds2D().getY())) {
                            if (DEBUG_DETAIL) {
                                Debug.output("   +++ omg contains position");
                            }
                            outsideFilter = false;
                        }
                    } else if (area.intersects(omgShape.getBounds2D())) {
                        if (DEBUG_DETAIL) {
                            Debug.output("   +++ omg intersects bounds");
                        }
                        if (this.precise) {
                            Area omgArea = new Area(omgShape);
                            if (!omgArea.isSingular()) {
                                Area clone = (Area)area.clone();
                                clone.intersect(omgArea);
                                if (!clone.isEmpty()) {
                                    outsideFilter = false;
                                }
                            } else {
                                outsideFilter = false;
                            }
                        } else {
                            outsideFilter = false;
                        }
                    }
                }
                if (outsideFilter && !getInsideArea || !outsideFilter && getInsideArea) {
                    if (DEBUG) {
                        Debug.output("   +++ OMGraphic passes filter, adding...");
                    }
                    this.passedFilter(omg);
                    ret.add(omg);
                    continue;
                }
                if (DEBUG) {
                    Debug.output("   --- OMGraphic fails filter, hiding...");
                }
                this.failedFilter(omg);
            }
        }
        return ret;
    }

    public boolean supportsSQL() {
        return false;
    }

    public OMGraphicList filter(String SQLQuery) {
        return new OMGraphicList();
    }

    public boolean doAction(OMGraphic graphic, OMAction action) {
        OMGraphicList list = this.getList();
        if (list != null) {
            list.doAction(graphic, action);
        }
        return true;
    }

    public synchronized OMGraphicList getList() {
        if (this.DEBUG) {
            Debug.output("FilterSupport.getList() with " + (this.list != null ? this.list.size() + " graphics." : "null list."));
        }
        return this.list;
    }

    public boolean canSetList() {
        return true;
    }

    public synchronized void setList(OMGraphicList omgl) {
        if (this.DEBUG) {
            Debug.output("FilterSupport.setList() with " + (omgl != null ? omgl.size() + " graphics." : "null list."));
        }
        this.list = omgl;
    }

    public void resetFiltering() {
        OMGraphicList list = this.getList();
        if (list != null) {
            list.setVisible(true);
        }
    }

    protected void failedFilter(OMGraphic omg) {
        omg.setVisible(false);
    }

    protected void passedFilter(OMGraphic omg) {
    }
}

