/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.MapMouseAdapter;
import com.bbn.openmap.event.MapMouseEvent;
import com.bbn.openmap.event.UndoEvent;
import com.bbn.openmap.event.UndoStack;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.GrabPoint;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OffsetGrabPoint;
import com.bbn.openmap.omGraphics.editable.EOMGStateMachine;
import com.bbn.openmap.omGraphics.event.EOMGEvent;
import com.bbn.openmap.omGraphics.event.EOMGListener;
import com.bbn.openmap.omGraphics.event.EOMGListenerSupport;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.MissingResourceException;

public abstract class EditableOMGraphic
extends MapMouseAdapter {
    public static final String GRAB_POINT_DRAWING_ATTRIBUTES_ATTRIBUTE = "gpdaa";
    public static final String SELECTED_GRAB_POINT_DRAWING_ATTRIBUTES_ATTRIBUTE = "sgpdaa";
    protected EOMGStateMachine stateMachine;
    protected String[] mouseModeServiceList;
    protected GrabPoint[] gPoints;
    protected Projection projection;
    protected GrabPoint movingPoint = null;
    protected EOMGListenerSupport listeners = null;
    protected boolean showGUI = true;
    protected boolean canGrabGraphic = true;
    protected UndoStack undoStack;
    protected I18n i18n = Environment.getI18n();
    protected boolean popupIsUp = false;
    protected int actionMask = 0;
    protected boolean DEBUG = false;
    protected boolean DEBUG_DETAIL = false;
    protected boolean xorRendering = true;
    protected DrawingAttributes holder = new DrawingAttributes();
    protected MouseEvent lastMouseEvent;
    boolean mouseOnMap = true;

    protected EditableOMGraphic() {
        this.DEBUG = Debug.debugging("eomg");
        this.DEBUG_DETAIL = Debug.debugging("eomgdetail");
    }

    public void setStateMachine(EOMGStateMachine sm) {
        this.stateMachine = sm;
    }

    public EOMGStateMachine getStateMachine() {
        return this.stateMachine;
    }

    public void setMouseModeServiceList(String[] list) {
        this.mouseModeServiceList = list;
    }

    public String[] getMouseModeServiceList() {
        return this.mouseModeServiceList;
    }

    public void setShowGUI(boolean set) {
        this.showGUI = set;
        OMGraphic graphic = this.getGraphic();
        if (graphic != null) {
            graphic.setShowEditablePalette(set);
        }
    }

    public boolean getShowGUI() {
        if (this.getGraphic() != null) {
            return this.getGraphic().getShowEditablePalette();
        }
        return this.showGUI;
    }

    public void setCanGrabGraphic(boolean set) {
        this.canGrabGraphic = set;
    }

    public boolean getCanGrabGraphic() {
        return this.canGrabGraphic;
    }

    public abstract void setGraphic(OMGraphic var1);

    public abstract void createGraphic(GraphicAttributes var1);

    public abstract OMGraphic getGraphic();

    public void reset() {
        Debug.output("EditableOMGraphic.reset(): not yet supported");
    }

    public boolean setGrabPoints(GrabPoint[] points) {
        if (points == null || this.gPoints == null) {
            return false;
        }
        System.arraycopy(points, 0, this.gPoints, 0, Math.min(points.length, this.gPoints.length));
        return points.length == this.gPoints.length;
    }

    public void setActionMask(int mask) {
        this.actionMask = mask;
    }

    public int getActionMask() {
        return this.actionMask;
    }

    public abstract void setGrabPoints();

    public GrabPoint[] getGrabPoints() {
        return this.gPoints;
    }

    public boolean setGrabPoint(GrabPoint gb, int index) {
        if (this.gPoints != null && gb != null && index >= 0 && index < this.gPoints.length) {
            this.gPoints[index] = gb;
            return true;
        }
        return false;
    }

    public GrabPoint getGrabPoint(int index) {
        if (this.gPoints != null && index >= 0 && index < this.gPoints.length) {
            return this.gPoints[index];
        }
        return null;
    }

    public void attachToMovingGrabPoint(OffsetGrabPoint gp) {
    }

    public void detachFromMovingGrabPoint(OffsetGrabPoint gp) {
    }

    public void setMovingPoint(GrabPoint gp) {
        this.movingPoint = gp;
    }

    public GrabPoint getMovingPoint() {
        return this.movingPoint;
    }

    public void handleInitialMouseEvent(MouseEvent e) {
        this.getStateMachine().setEdit();
        if (e != null) {
            GrabPoint gp = this.getMovingPoint(e);
            if (gp == null) {
                this.move(e);
            } else {
                this.getStateMachine().setSelected();
            }
        } else {
            this.getStateMachine().setSelected();
        }
    }

    public GrabPoint getMovingPoint(MouseEvent e) {
        return this._getMovingPoint(e);
    }

    public GrabPoint _getMovingPoint(MouseEvent e) {
        this.movingPoint = null;
        GrabPoint[] gb = this.getGrabPoints();
        Point2D pnt = this.getProjectionPoint(e);
        double x = pnt.getX();
        double y = pnt.getY();
        for (int i = gb.length - 1; i >= 0; --i) {
            if (gb[i] == null || gb[i].distance(x, y) != 0.0f) continue;
            this.setMovingPoint(gb[i]);
            return gb[i];
        }
        this.setMovingPoint(null);
        return null;
    }

    public abstract void move(MouseEvent var1);

    public void cleanMap(MouseEvent e) {
        Object obj = e.getSource();
        if (!(obj instanceof MapBean)) {
            return;
        }
        MapBean map = (MapBean)obj;
        map.setBufferDirty(true);
        map.paintChildren(map.getGraphics(true));
    }

    public void redraw(MouseEvent e) {
        this.redraw(e, false);
    }

    public void redraw(MouseEvent e, boolean firmPaint) {
        this.redraw(e, firmPaint, true);
    }

    public void redraw(MouseEvent e, boolean firmPaint, boolean drawXOR) {
        Object obj;
        if (this.DEBUG) {
            Debug.output("EditableOMGraphic.redraw(" + (firmPaint ? "firmPaint)" : ")"));
        }
        boolean bl = drawXOR = drawXOR && this.isXorRendering();
        if (e == null) {
            if (this.lastMouseEvent == null) {
                return;
            }
            e = this.lastMouseEvent;
        }
        if (!((obj = e.getSource()) instanceof MapBean)) {
            return;
        }
        MapBean map = (MapBean)obj;
        Graphics g = map.getGraphics(true);
        OMGraphic graphic = this.getGraphic();
        if (!this.isXorRendering()) {
            map.repaint();
        }
        if (firmPaint) {
            map.setBufferDirty(true);
            graphic.generate(this.getProjection());
            map.repaint();
        } else {
            GrabPoint gp;
            this.holder.setFrom(graphic);
            DrawingAttributes.DEFAULT.setTo(graphic);
            this.modifyOMGraphicForEditRender();
            graphic.regenerate(this.getProjection());
            if (drawXOR) {
                g.setXORMode(Color.lightGray);
                g.setColor((Color)graphic.getDisplayPaint());
                this.render(g);
            }
            if ((gp = this.getMovingPoint()) != null) {
                Point2D pnt = this.getProjectionPoint(e);
                double x = pnt.getX();
                double y = pnt.getY();
                gp.set((int)x, (int)y);
                if (gp instanceof OffsetGrabPoint) {
                    ((OffsetGrabPoint)gp).moveOffsets();
                }
                this.setGrabPoints();
            }
        }
        if (!firmPaint) {
            this.generate(this.getProjection());
            this.render(g);
            this.holder.setTo(graphic);
        }
        this.resetOMGraphicAfterEditRender();
        g.dispose();
        this.lastMouseEvent = e;
    }

    protected void modifyOMGraphicForEditRender() {
    }

    protected void resetOMGraphicAfterEditRender() {
    }

    public void repaint() {
        if (this.lastMouseEvent != null) {
            this.redraw(this.lastMouseEvent, true);
        }
    }

    protected void finalize() {
        if (this.getGraphic() != null) {
            this.getGraphic().setVisible(true);
        }
        if (Debug.debugging("gc")) {
            Debug.output("EditableOMGraphic gone.");
        }
    }

    public abstract boolean generate(Projection var1);

    public abstract void regenerate(Projection var1);

    public void repaintRender(Graphics g) {
        this.render(g);
    }

    public abstract void render(Graphics var1);

    public boolean isXorRendering() {
        return this.xorRendering;
    }

    public void setXorRendering(boolean xorRendering) {
        this.xorRendering = xorRendering;
    }

    public void setProjection(Projection proj) {
        this.projection = proj;
        this.regenerate(proj);
    }

    public Projection getProjection() {
        return this.projection;
    }

    public boolean mousePressed(MouseEvent e) {
        if (this.DEBUG_DETAIL) {
            Debug.output(this.getClass().getName() + ".mousePressed()");
        }
        if (!this.mouseOnMap) {
            return false;
        }
        return this.stateMachine.getState().mousePressed(e);
    }

    public boolean mouseReleased(MouseEvent e) {
        if (this.DEBUG_DETAIL) {
            Debug.output(this.getClass().getName() + ".mouseReleased()");
        }
        if (!this.mouseOnMap) {
            return false;
        }
        return this.stateMachine.getState().mouseReleased(e);
    }

    public boolean mouseClicked(MouseEvent e) {
        if (this.DEBUG_DETAIL) {
            Debug.output(this.getClass().getName() + ".mouseClicked()");
        }
        if (!this.mouseOnMap) {
            return false;
        }
        return this.stateMachine.getState().mouseClicked(e);
    }

    public void mouseEntered(MouseEvent e) {
        if (this.DEBUG_DETAIL) {
            Debug.output(this.getClass().getName() + ".mouseEntered()");
        }
        this.mouseOnMap = true;
        this.stateMachine.getState().mouseEntered(e);
    }

    public void mouseExited(MouseEvent e) {
        if (this.DEBUG_DETAIL) {
            Debug.output(this.getClass().getName() + ".mouseExited()");
        }
        this.mouseOnMap = false;
        this.stateMachine.getState().mouseExited(e);
    }

    public boolean mouseDragged(MouseEvent e) {
        if (this.DEBUG_DETAIL) {
            Debug.output(this.getClass().getName() + ".mouseDragged()");
        }
        if (!this.mouseOnMap) {
            return false;
        }
        return this.stateMachine.getState().mouseDragged(e);
    }

    public boolean mouseMoved(MouseEvent e) {
        if (this.DEBUG_DETAIL) {
            Debug.output(this.getClass().getName() + ".mouseMoved()");
        }
        if (!this.mouseOnMap) {
            return false;
        }
        return this.stateMachine.getState().mouseMoved(e);
    }

    public void mouseMoved() {
        if (this.DEBUG_DETAIL) {
            Debug.output(this.getClass().getName() + ".mouseMoved()");
        }
        if (!this.mouseOnMap) {
            return;
        }
        this.stateMachine.getState().mouseMoved();
    }

    public synchronized void addEOMGListener(EOMGListener l) {
        if (this.listeners == null) {
            this.listeners = new EOMGListenerSupport(this);
        }
        this.listeners.add(l);
    }

    public synchronized void removeEOMGListener(EOMGListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    public void fireEvent(EOMGEvent event) {
        if (this.listeners != null) {
            this.listeners.fireEvent(event);
        }
        if (event.getStatus() == 6) {
            this.updateCurrentState(null);
        }
    }

    public void fireEvent(Cursor cursor, String message, int status) {
        this.fireEvent(cursor, message, null, status);
    }

    public void fireEvent(Cursor cursor, String message, MouseEvent mouseEvent, int status) {
        if (this.listeners != null) {
            EditableOMGraphic theSource = this.listeners.getEOMG();
            EOMGEvent event = new EOMGEvent(theSource, cursor, message, mouseEvent, status);
            this.fireEvent(event);
        }
    }

    public void fireEvent(int status) {
        this.fireEvent(null, null, null, status);
    }

    public Component getGUI() {
        return this.getGUI(null);
    }

    public Component getGUI(GraphicAttributes graphicAttributes) {
        if (graphicAttributes != null) {
            graphicAttributes.setLineMenuAdditions(null);
            return graphicAttributes.getGUI();
        }
        return null;
    }

    public Point2D getProjectionPoint(MouseEvent e) {
        Point2D pnt = null;
        if (e instanceof MapMouseEvent && ((MapMouseEvent)e).mapIsRotated()) {
            MapMouseEvent mme = (MapMouseEvent)e;
            pnt = mme.getProjectedLocation();
        }
        if (pnt == null) {
            pnt = new Point2D.Double(e.getX(), e.getY());
        }
        return pnt;
    }

    public boolean isMouseEventTouching(MouseEvent e) {
        Point2D pnt = this.getProjectionPoint(e);
        return this.getGraphic().distance(pnt.getX(), pnt.getY()) <= 2.0f;
    }

    public boolean isMouseEventTouchingTheEdge(MouseEvent e) {
        Point2D pnt = this.getProjectionPoint(e);
        return this.getGraphic().distanceToEdge(pnt.getX(), pnt.getY()) <= 2.0f;
    }

    protected UndoEvent createUndoEventForCurrentState(String whatHappened) {
        if (whatHappened == null) {
            whatHappened = this.i18n.get(this.getClass(), "omgraphicUndoString", "Edit");
        }
        try {
            return new OMGraphicUndoEvent(this, whatHappened);
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    public void updateCurrentState(String whatHappened) {
        UndoEvent undoEvent = this.createUndoEventForCurrentState(whatHappened);
        if (undoEvent != null && this.undoStack != null) {
            this.undoStack.setTheWayThingsAre(undoEvent);
        }
    }

    public UndoStack getUndoStack() {
        return this.undoStack;
    }

    public void setUndoStack(UndoStack undoStack) {
        this.undoStack = undoStack;
    }

    public void setPopupIsUp(boolean popupIsUp) {
        this.popupIsUp = popupIsUp;
    }

    public boolean isPopupIsUp() {
        return this.popupIsUp;
    }

    public static class OMGraphicUndoEvent
    implements UndoEvent {
        protected EditableOMGraphic eomg;
        protected OMGraphic stateHolder;
        protected String description;

        public OMGraphicUndoEvent(EditableOMGraphic eomg, String description) throws MissingResourceException {
            this.eomg = eomg;
            this.description = description;
            OMGraphic omg = eomg.getGraphic();
            this.stateHolder = (OMGraphic)ComponentFactory.create(omg.getClass().getName());
            if (this.stateHolder == null) {
                throw new MissingResourceException(eomg.getClass().getName() + " can't provide UndoEvents", eomg.getClass().getName(), "");
            }
            this.stateHolder.restore(eomg.getGraphic());
        }

        public String getDescription() {
            return this.description;
        }

        public void setState() {
            this.eomg.getGraphic().restore(this.stateHolder);
            this.setSubclassState();
            this.eomg.regenerate(this.eomg.getProjection());
            this.eomg.repaint();
        }

        protected void setSubclassState() {
        }

        public OMGraphic getStateHolder() {
            return this.stateHolder;
        }

        public void setStateHolder(OMGraphic stateHolder) {
            this.stateHolder = stateHolder;
        }

        public EditableOMGraphic getEomg() {
            return this.eomg;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

