/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.layer.vpf.FeatureCacheGraphicList;
import com.bbn.openmap.layer.vpf.PrimitiveTable;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.layer.vpf.VPFUtil;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.util.cacheHandler.CacheHandler;
import com.bbn.openmap.util.cacheHandler.CacheObject;
import java.util.logging.Level;

public class VPFFeatureCache
extends CacheHandler {
    public VPFFeatureCache() {
    }

    public VPFFeatureCache(int maxSize) {
        super(maxSize);
    }

    protected synchronized void addToCachedList(String libraryName, OMGraphic omg, String featureType, PrimitiveTable pt, String type) {
        String key = VPFFeatureCache.createTableCacheKey(libraryName, featureType, pt.getTileDirectory().getPath());
        FeatureCacheGraphicList omgl = (FeatureCacheGraphicList)this.get(key);
        omgl.add(omg);
    }

    public static String createTableCacheKey(String libraryName, String featureType, String tilePath) {
        return libraryName + "-" + featureType + "-" + tilePath;
    }

    public synchronized FeatureCacheGraphicList loadCachedGraphicList(String libraryName, String featureType, String tilePath, OMGraphicList requestor) {
        String key = VPFFeatureCache.createTableCacheKey(libraryName, featureType, tilePath);
        boolean exists = this.searchCache(key) != null;
        FeatureCacheGraphicList fcgl = (FeatureCacheGraphicList)this.get(key, VPFUtil.getTypeForFeatureCode(featureType));
        if (fcgl.getFeatureName() == null) {
            fcgl.setFeatureName(featureType);
        }
        requestor.add(fcgl);
        FeatureCacheGraphicList ret = null;
        if (!exists) {
            logger.fine("tile list didn't exist in cache, returning it to be loaded.");
            ret = fcgl;
        }
        return ret;
    }

    public synchronized FeatureCacheGraphicList needToFetchTileContents(String libraryName, String currentFeature, TileDirectory currentTile, OMGraphicList requestor) {
        FeatureCacheGraphicList listThatNeedsToBeLoaded = this.loadCachedGraphicList(libraryName, currentFeature, currentTile.getPath(), requestor);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loaded Cached List: " + VPFFeatureCache.createTableCacheKey(libraryName, currentFeature, currentTile.getPath()) + (listThatNeedsToBeLoaded == null ? ", cached" : ", not cached"));
        }
        return listThatNeedsToBeLoaded;
    }

    public Object get(String key, String featureType) {
        CacheObject ret = this.searchCache(key);
        if (ret != null) {
            return ret.obj;
        }
        ret = this.load(key, featureType);
        if (ret == null) {
            return null;
        }
        this.replaceLeastUsed(ret);
        return ret.obj;
    }

    public CacheObject load(Object key) {
        return this.load(key.toString(), null);
    }

    public CacheObject load(String key, String featureType) {
        if (key != null && featureType != null) {
            return new VPFListCacheObject(key, FeatureCacheGraphicList.createForType(featureType));
        }
        return null;
    }

    public static class VPFListCacheObject
    extends CacheObject {
        public VPFListCacheObject(String id, OMGraphicList obj) {
            super(id, obj);
        }

        protected void finalize() {
            ((OMGraphicList)this.obj).clear();
        }
    }
}

