/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.CoverageAttributeTable;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.FeatureClassInfo;
import com.bbn.openmap.layer.vpf.FeatureDrawingAttributes;
import com.bbn.openmap.layer.vpf.LayerGraphicWarehouseSupport;
import com.bbn.openmap.layer.vpf.LibraryBean;
import com.bbn.openmap.layer.vpf.LibrarySelectionTable;
import com.bbn.openmap.layer.vpf.VPFFeatureGraphicWarehouse;
import com.bbn.openmap.layer.vpf.VPFLayer;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPFConfig
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private boolean playWithLineStyle = false;
    private String lineStyle = "Angled";
    protected boolean showAll = false;
    protected boolean standAlone = false;
    public static final String AddFeatureCmd = "AddFeatureCommand";
    public static final String ClearFeaturesCmd = "ClearFeaturesCommand";
    public static final String CreateLayerCmd = "CreateLayerCommand";
    public static final String EMPTY_FEATURE_LIST = null;
    DefaultMutableTreeNode currentFeature = null;
    protected DrawingAttributes drawingAttributes = new DrawingAttributes();
    protected boolean searchByFeature = true;
    protected String paths = "";
    protected HashSet<String> layerCoverageTypes = new HashSet();
    protected HashSet<String> layerFeatureTypes = new HashSet();
    public static final String AREA = "area";
    public static final String TEXT = "text";
    public static final String EDGE = "edge";
    public static final String POINT = "point";
    public static final String CPOINT = "cpoint";
    public static final String EPOINT = "epoint";
    public static final String COMPLEX = "complex";
    public static final String UNKNOWN = "unknown";
    protected Hashtable<String, HashSet<String>> layerFeatures;
    protected Properties layerProperties;
    protected LayerHandler layerHandler;
    protected LibraryBean libraryBean;
    protected String layerName;
    protected VPFLayer layer;
    JButton addFeatureButton;
    JButton clearFeaturesButton;
    JButton createLayerButton;
    JTextArea currentFeatureList;
    JTextField nameField;
    LinkedList<DefaultMutableTreeNode> featureList = new LinkedList();

    public VPFConfig(String[] dataPaths, String layerName) {
        this(dataPaths, null, layerName);
    }

    public VPFConfig(String[] dataPaths, LayerHandler layerHandler, String layerName) {
        this(dataPaths, layerHandler, layerName, false);
    }

    protected VPFConfig(String[] dataPaths, LayerHandler layerHandler, String layerName, boolean standAlone) {
        this.layerHandler = layerHandler;
        this.standAlone = standAlone;
        this.layerName = layerName;
        this.paths = this.formatPaths(dataPaths);
        if (this.paths != null && this.paths.length() > 0) {
            DefaultMutableTreeNode top;
            block3: {
                top = new DefaultMutableTreeNode("VPF Data Libraries");
                try {
                    this.createNodes(top, dataPaths);
                }
                catch (FormatException fe) {
                    Debug.output("Caught FormatException reading data: " + fe.getMessage());
                    if (!standAlone) break block3;
                    System.exit(0);
                }
            }
            this.init(top);
        }
    }

    public VPFConfig(LibraryBean lb, LayerHandler layerHandler, String layerName) {
        this.layerHandler = layerHandler;
        this.layerName = layerName;
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("VPF Data Libraries");
        try {
            this.createNodes(top, lb.getLibrarySelectionTable());
        }
        catch (FormatException fe) {
            Debug.output("Caught FormatException reading data: " + fe.getMessage());
        }
        this.init(top);
    }

    public VPFConfig(VPFLayer layer) {
        if (layer != null && layer.lst != null) {
            this.layer = layer;
            this.layerName = layer.getName();
            DefaultMutableTreeNode top = new DefaultMutableTreeNode("VPF Data Libraries");
            try {
                this.createNodes(top, layer.lst);
            }
            catch (FormatException fe) {
                Debug.output("Caught FormatException reading data: " + fe.getMessage());
            }
            this.init(top);
        }
    }

    public String formatPaths(String[] dataPaths) {
        if (dataPaths != null && dataPaths.length > 0) {
            dataPaths[0] = dataPaths[0].replace('\\', '/');
            StringBuffer buf = new StringBuffer(dataPaths[0]);
            for (int i = 1; i < dataPaths.length; ++i) {
                buf.append(";");
                dataPaths[i] = dataPaths[i].replace('\\', '/');
                buf.append(dataPaths[i]);
            }
            return buf.toString();
        }
        return null;
    }

    public void init(DefaultMutableTreeNode top) {
        this.layerFeatures = new Hashtable();
        final JTree tree = new JTree(top);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setVisibleRowCount(10);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                Object nodeInfo = node.getUserObject();
                if (node.isLeaf() && nodeInfo instanceof FeatureInfo) {
                    VPFConfig.this.currentFeature = node;
                    VPFConfig.this.addFeatureButton.setEnabled(true);
                } else {
                    VPFConfig.this.addFeatureButton.setEnabled(false);
                }
            }
        });
        if (this.playWithLineStyle) {
            tree.putClientProperty("JTree.lineStyle", this.lineStyle);
        }
        GridBagLayout outergridbag = new GridBagLayout();
        GridBagConstraints outerc = new GridBagConstraints();
        JScrollPane treeView = new JScrollPane(tree);
        this.setLayout(outergridbag);
        outerc.fill = 1;
        outerc.anchor = 17;
        outerc.insets = new Insets(10, 10, 10, 10);
        outerc.gridx = 0;
        outerc.weighty = 0.75;
        outerc.weightx = 1.0;
        outergridbag.setConstraints(treeView, outerc);
        this.add(treeView);
        JPanel configPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        configPanel.setLayout(gridbag);
        c.gridheight = 0;
        Component da = this.drawingAttributes.getGUI();
        gridbag.setConstraints(da, c);
        configPanel.add(da);
        c.gridx = 1;
        c.gridheight = 1;
        c.gridy = 0;
        c.fill = 2;
        c.insets = new Insets(0, 5, 0, 5);
        this.addFeatureButton = new JButton("Add Feature");
        this.addFeatureButton.addActionListener(this);
        this.addFeatureButton.setActionCommand(AddFeatureCmd);
        gridbag.setConstraints(this.addFeatureButton, c);
        configPanel.add(this.addFeatureButton);
        this.addFeatureButton.setEnabled(false);
        this.clearFeaturesButton = new JButton("Clear Features");
        this.clearFeaturesButton.addActionListener(this);
        this.clearFeaturesButton.setActionCommand(ClearFeaturesCmd);
        c.gridy = -1;
        gridbag.setConstraints(this.clearFeaturesButton, c);
        configPanel.add(this.clearFeaturesButton);
        this.clearFeaturesButton.setEnabled(false);
        this.createLayerButton = this.layer != null ? new JButton("Set Features on Layer") : (this.layerHandler != null ? new JButton("Create Layer") : new JButton("Print Properties"));
        this.createLayerButton.addActionListener(this);
        this.createLayerButton.setActionCommand(CreateLayerCmd);
        gridbag.setConstraints(this.createLayerButton, c);
        configPanel.add(this.createLayerButton);
        this.createLayerButton.setEnabled(false);
        JPanel currentFeatureListPanel = PaletteHelper.createVerticalPanel(" Current Features: ");
        this.currentFeatureList = new JTextArea(EMPTY_FEATURE_LIST);
        this.currentFeatureList.setEditable(false);
        JScrollPane featureListScrollPane = new JScrollPane(this.currentFeatureList);
        featureListScrollPane.setPreferredSize(new Dimension(150, 10));
        currentFeatureListPanel.add(featureListScrollPane);
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 18;
        c.gridheight = 0;
        c.fill = 1;
        gridbag.setConstraints(currentFeatureListPanel, c);
        configPanel.add(currentFeatureListPanel);
        GridBagLayout gridbag2 = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        JPanel namePanel = new JPanel();
        namePanel.setLayout(gridbag2);
        c2.weightx = 0.0;
        c2.weighty = 0.0;
        c2.anchor = 17;
        JLabel nameLabel = new JLabel("Layer Name: ");
        gridbag2.setConstraints(nameLabel, c2);
        namePanel.add(nameLabel);
        c2.fill = 2;
        c2.weightx = 1.0;
        c2.weighty = 1.0;
        this.nameField = new JTextField(this.layerName);
        gridbag2.setConstraints(this.nameField, c2);
        namePanel.add(this.nameField);
        outerc.anchor = 17;
        outerc.weighty = 0.0;
        outergridbag.setConstraints(namePanel, outerc);
        this.add(namePanel);
        outerc.fill = 2;
        outerc.weighty = 0.25;
        outerc.anchor = 10;
        outergridbag.setConstraints(configPanel, outerc);
        this.add(configPanel);
        DrawingAttributes oldDrawingAttributes = (DrawingAttributes)this.drawingAttributes.clone();
        if (this.layer != null) {
            LayerGraphicWarehouseSupport warehouse = this.layer.getWarehouse();
            List<String> initialFeatureList = warehouse.getFeatures();
            for (String initialFeature : initialFeatureList) {
                this.loadCurrentFeatures(top, initialFeature, warehouse);
            }
        }
        oldDrawingAttributes.setTo(this.drawingAttributes);
    }

    protected void loadCurrentFeatures(DefaultMutableTreeNode top, String featureName, LayerGraphicWarehouseSupport warehouse) {
        Enumeration<TreeNode> treeEnum = top.children();
        while (treeEnum.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeEnum.nextElement();
            Object obj = node.getUserObject();
            if (obj instanceof FeatureInfo) {
                FeatureDrawingAttributes fda;
                FeatureInfo fi = (FeatureInfo)obj;
                if (!fi.featureName.equals(featureName)) continue;
                this.currentFeature = node;
                if (warehouse instanceof VPFFeatureGraphicWarehouse && (fda = ((VPFFeatureGraphicWarehouse)warehouse).getAttributesForFeature(featureName)) != null) {
                    fda.setTo(this.drawingAttributes);
                }
                this.actionPerformed(new ActionEvent(this, 0, AddFeatureCmd));
                continue;
            }
            this.loadCurrentFeatures(node, featureName, warehouse);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command == AddFeatureCmd) {
            if (this.currentFeature != null) {
                FeatureInfo feature = (FeatureInfo)this.currentFeature.getUserObject();
                feature.drawingAttributes = (DrawingAttributes)this.drawingAttributes.clone();
                this.featureList.add(this.currentFeature);
                String cfl = this.currentFeatureList.getText();
                cfl = this.featureList.size() == 1 ? feature.toString() : cfl + "\n" + feature.toString();
                this.currentFeatureList.setText(cfl);
                this.currentFeature = null;
                this.createLayerButton.setEnabled(true);
                this.addFeatureButton.setEnabled(false);
                this.clearFeaturesButton.setEnabled(true);
            } else {
                Debug.error("No feature selected");
            }
        } else if (command == ClearFeaturesCmd) {
            this.featureList.clear();
            this.layerFeatures.clear();
            this.createLayerButton.setEnabled(false);
            this.addFeatureButton.setEnabled(false);
            this.clearFeaturesButton.setEnabled(false);
            this.currentFeatureList.setText(EMPTY_FEATURE_LIST);
        } else if (command == CreateLayerCmd) {
            if (this.featureList.isEmpty()) {
                Debug.error("No features selected for new VPFLayer");
                this.createLayerButton.setEnabled(false);
                this.clearFeaturesButton.setEnabled(false);
                return;
            }
            String name = this.nameField.getText();
            if (name == null) {
                name = "VPFLayer";
            }
            String propertyPrefix = this.layer != null ? PropUtils.getScopedPropertyPrefix(this.layer) : PropUtils.getScopedPropertyPrefix(name.replace(' ', '_').toLowerCase());
            this.layerProperties = this.layer != null ? this.layer.getProperties(null) : new Properties();
            this.layerCoverageTypes.clear();
            this.layerFeatureTypes.clear();
            this.layerFeatures.clear();
            if (this.standAlone) {
                this.layerProperties.put(propertyPrefix + "class", "com.bbn.openmap.layer.vpf.VPFLayer");
            }
            this.layerProperties.put(propertyPrefix + "prettyName", name);
            this.layerProperties.put(propertyPrefix + "vpfPath", this.paths);
            this.layerProperties.put(propertyPrefix + "searchByFeature", new Boolean(this.searchByFeature).toString());
            for (DefaultMutableTreeNode node : this.featureList) {
                this.addPropertiesForFeature(node, propertyPrefix, this.layerProperties);
            }
            this.layerProperties.put(propertyPrefix + "coverageType", this.stringTogether(this.layerCoverageTypes.iterator()));
            this.layerProperties.put(propertyPrefix + "featureTypes", this.stringTogether(this.layerFeatureTypes.iterator()));
            for (String key : this.layerFeatures.keySet()) {
                HashSet<String> featureSet = this.layerFeatures.get(key);
                this.layerProperties.put(propertyPrefix + key, this.stringTogether(featureSet.iterator()));
            }
            if (this.layer != null) {
                this.layer.setConfigSettings(this.layer.getPropertyPrefix(), this.layerProperties);
            } else if (this.layerHandler != null) {
                VPFLayer layer = new VPFLayer();
                layer.setProperties(propertyPrefix, this.layerProperties);
                this.layerHandler.addLayer(layer);
            } else {
                this.printProperties(this.layerProperties);
            }
        }
    }

    private void addPropertiesForFeature(DefaultMutableTreeNode featureNode, String propertyPrefix, Properties layerProperties) {
        FeatureInfo feature = (FeatureInfo)featureNode.getUserObject();
        CoverageInfo coverage = (CoverageInfo)((DefaultMutableTreeNode)featureNode.getParent()).getUserObject();
        this.layerCoverageTypes.add(coverage.coverageName);
        this.layerFeatureTypes.add(feature.featureTypeString);
        HashSet<String> featureSet = this.layerFeatures.get(feature.featureTypeString);
        if (featureSet == null) {
            featureSet = new HashSet();
            this.layerFeatures.put(feature.featureTypeString, featureSet);
        }
        featureSet.add(feature.featureName);
        feature.drawingAttributes.setPropertyPrefix(propertyPrefix + feature.featureName);
        feature.drawingAttributes.getProperties(layerProperties);
    }

    private void printProperties(Properties props) {
        Enumeration<?> keys = props.propertyNames();
        System.out.println("######## START Properties ########");
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            System.out.println(key + "=" + props.getProperty(key));
        }
        System.out.println("######## END Properties ########");
    }

    private String stringTogether(Iterator<String> it) {
        StringBuffer buf = null;
        while (it.hasNext()) {
            String val = it.next();
            if (buf == null) {
                buf = new StringBuffer(val);
                continue;
            }
            buf.append(" ").append(val);
        }
        if (buf == null) {
            return "";
        }
        return buf.toString();
    }

    private boolean addFeatureNodes(DefaultMutableTreeNode coverageNode, CoverageTable ct) {
        int numFeatures = 0;
        Hashtable<String, CoverageTable.FeatureClassRec> info = ct.getFeatureTypeInfo();
        for (CoverageTable.FeatureClassRec fcr : info.values()) {
            if (fcr.type == 'S') continue;
            coverageNode.add(new DefaultMutableTreeNode(new FeatureInfo(ct, fcr)));
            ++numFeatures;
        }
        return numFeatures > 0;
    }

    private void addCoverageNodes(DefaultMutableTreeNode libraryNode, CoverageAttributeTable cat) {
        String[] coverages = cat.getCoverageNames();
        for (int covi = 0; covi < coverages.length; ++covi) {
            String coverage = coverages[covi];
            CoverageInfo covInfo = new CoverageInfo(cat, coverage);
            DefaultMutableTreeNode covNode = new DefaultMutableTreeNode(covInfo);
            if (!this.showAll && !this.addFeatureNodes(covNode, cat.getCoverageTable(coverage)) && cat.isTiledData()) continue;
            libraryNode.add(covNode);
        }
    }

    private void createNodes(DefaultMutableTreeNode top, LibrarySelectionTable lst) throws FormatException {
        DefaultMutableTreeNode category = null;
        for (String library : lst.getLibraryNames()) {
            category = new DefaultMutableTreeNode(library);
            CoverageAttributeTable cat = lst.getCAT(library);
            top.add(category);
            this.addCoverageNodes(category, cat);
        }
    }

    private void createNodes(DefaultMutableTreeNode top, String[] dataPaths) throws FormatException {
        for (int i = 0; i < dataPaths.length; ++i) {
            String rootpath = dataPaths[i];
            LibrarySelectionTable lst = new LibrarySelectionTable(rootpath);
            this.createNodes(top, lst);
        }
    }

    public static void printFeatures(String[] dataPaths) {
        TreeMap<String, FeatureInfo> features = new TreeMap<String, FeatureInfo>();
        for (int i = 0; i < dataPaths.length; ++i) {
            String rootpath = dataPaths[i];
            try {
                LibrarySelectionTable lst = new LibrarySelectionTable(rootpath);
                for (String libraryName : lst.getLibraryNames()) {
                    CoverageAttributeTable cat = lst.getCAT(libraryName);
                    String[] coverages = cat.getCoverageNames();
                    for (int covi = 0; covi < coverages.length; ++covi) {
                        String coverage = coverages[covi];
                        CoverageTable ct = cat.getCoverageTable(coverage);
                        Hashtable<String, CoverageTable.FeatureClassRec> info = ct.getFeatureTypeInfo();
                        for (CoverageTable.FeatureClassRec fcr : info.values()) {
                            if (fcr.type == 'S') continue;
                            FeatureInfo fi = new FeatureInfo(ct, fcr);
                            if (features.containsKey(fi.featureName)) continue;
                            features.put(fi.featureName, fi);
                        }
                    }
                }
                continue;
            }
            catch (FormatException e) {
                e.printStackTrace();
            }
        }
        if (!features.isEmpty()) {
            for (Map.Entry entry : features.entrySet()) {
                System.out.println((String)entry.getKey() + ": " + entry.getValue());
            }
        }
    }

    public static void createLayer(String[] vpfPaths, LayerHandler layerHandler, String layerName) {
        VPFConfig.launchFrame(new VPFConfig(vpfPaths, layerHandler, layerName), false);
    }

    public static void createLayer(LibraryBean libraryBean, LayerHandler layerHandler, String layerName) {
        VPFConfig.launchFrame(new VPFConfig(libraryBean, layerHandler, layerName), false);
    }

    protected static void launchFrame(JComponent content, boolean exitOnClose) {
        JFrame frame = new JFrame("Create VPF Data Layer");
        frame.getContentPane().add(content);
        if (exitOnClose) {
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
        }
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        String[] arg;
        ArgParser argParser = new ArgParser("VPFConfig");
        argParser.add("features", "print available feature codes and descriptions, given paths to VPF directories", -1);
        argParser.add("path", "space-separated paths to VPF directories", -1);
        if (!argParser.parse(args)) {
            argParser.printUsage();
            System.exit(0);
        }
        if ((arg = argParser.getArgValues("features")) != null) {
            VPFConfig.printFeatures(arg);
            System.exit(0);
        }
        if ((arg = argParser.getArgValues("path")) != null) {
            VPFConfig vpfc = new VPFConfig(arg, null, "VPF Layer", true);
            VPFConfig.launchFrame(vpfc, true);
        } else {
            argParser.printUsage();
        }
    }

    protected static class CoverageInfo {
        public String coverageName;
        public String coverageDescription;

        public CoverageInfo(CoverageAttributeTable cat, String covName) {
            this.coverageName = covName;
            this.coverageDescription = cat.getCoverageDescription(covName);
        }

        public String toString() {
            return this.coverageDescription;
        }
    }

    protected static class FeatureInfo {
        public String featureName;
        public String featureDescription;
        public String featureTypeString;
        public int featureType;
        public CoverageTable.FeatureClassRec record;
        public DrawingAttributes drawingAttributes;

        public FeatureInfo(CoverageTable ct, CoverageTable.FeatureClassRec fcr) {
            this.record = fcr;
            this.featureTypeString = VPFConfig.UNKNOWN;
            if (fcr.type == 'T') {
                this.featureTypeString = VPFConfig.TEXT;
            } else if (fcr.type == 'L') {
                this.featureTypeString = VPFConfig.EDGE;
            } else if (fcr.type == 'A') {
                this.featureTypeString = VPFConfig.AREA;
            } else if (fcr.type == 'P') {
                FeatureClassInfo fci = ct.getFeatureClassInfo(fcr.feature_class);
                this.featureTypeString = fci == null ? VPFConfig.POINT : (fci.getFeatureType() == 'E' ? VPFConfig.EPOINT : (fci.getFeatureType() == 'N' ? VPFConfig.CPOINT : VPFConfig.POINT));
            } else if (fcr.type == 'C') {
                this.featureTypeString = VPFConfig.COMPLEX;
            }
            this.featureType = fcr.type;
            this.featureName = fcr.feature_class;
            this.featureDescription = fcr.description;
        }

        public String toString() {
            return this.featureDescription + " (" + this.featureTypeString + ")";
        }
    }
}

