/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import java.io.EOFException;

public class CoordFloatString {
    public int tcount;
    public int tsize;
    public double[] vals;

    public CoordFloatString(int tuplecount, int tuplesize, BinaryFile input) throws FormatException {
        this.tcount = tuplecount;
        this.tsize = tuplesize;
        int totallen = this.tcount * this.tsize;
        this.vals = new double[totallen];
        try {
            input.readFloatArray(this.vals, 0, totallen);
        }
        catch (EOFException e) {
            throw new FormatException("CoordFloatString EOFException");
        }
    }

    public int maxIndex() {
        return this.tcount;
    }

    public String toString() {
        int j;
        boolean singleCoord = this.vals.length == this.tsize;
        StringBuffer retval = new StringBuffer(singleCoord ? "" : "CFS:");
        if (!singleCoord) {
            retval.append(this.tcount).append("[");
        }
        if (this.vals.length > 0) {
            retval.append("(").append(this.vals[0]);
            for (j = 1; j < this.tsize; ++j) {
                retval.append(", ").append(this.vals[j]);
            }
            retval.append(")");
        }
        if (this.vals.length > this.tsize) {
            retval.append(" ... (").append(this.vals[this.vals.length - this.tsize]);
            for (j = this.tsize - 1; j > 0; --j) {
                retval.append(", ").append(this.vals[this.vals.length - j]);
            }
            retval.append(")");
        }
        if (!singleCoord) {
            retval.append("]");
        }
        return retval.toString();
    }

    public double getXasFloat(int tuple) {
        return this.vals[tuple * this.tsize];
    }

    public double getYasFloat(int tuple) {
        return this.vals[tuple * this.tsize + 1];
    }

    public double getZasFloat(int tuple) {
        return this.vals[tuple * this.tsize + 2];
    }

    public double[] getasFloatV(int tuple) {
        double[] rv = new double[this.tsize];
        for (int i = 0; i < this.tsize; ++i) {
            rv[i] = this.vals[this.tsize * tuple + i];
        }
        return rv;
    }

    public double getasFloat(int tuple, int val) {
        return this.vals[tuple * this.tsize + val];
    }
}

