/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.shape.ESRIBoundingBox;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.layer.shape.SpatialIndexHandler;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.DataBounds;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiShapeLayer
extends ShapeLayer {
    public static final String ShapeFileListProperty = "shapeFileList";
    protected Collection<SpatialIndexHandler> spatialIndexes;

    public void setSpatialIndexes(Collection<SpatialIndexHandler> siv) {
        this.spatialIndexes = siv;
    }

    public Collection<SpatialIndexHandler> getSpatialIndexes() {
        return this.spatialIndexes;
    }

    @Override
    protected void setFileProperties(String prefix, Properties props) {
        this.setSpatialIndexes(prefix, props);
    }

    protected void setSpatialIndexes(String prefix, Properties p) {
        Vector<String> shapeFileStrings;
        String shapeFileList = p.getProperty(prefix + ShapeFileListProperty);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.getName() + "| list = \"" + shapeFileList + "\"");
        }
        if ((shapeFileStrings = PropUtils.parseSpacedMarkers(shapeFileList)) != null) {
            this.spatialIndexes = new Vector<SpatialIndexHandler>(shapeFileStrings.size());
            for (String listName : shapeFileStrings) {
                SpatialIndexHandler sih = new SpatialIndexHandler(prefix + listName, p);
                this.spatialIndexes.add(sih);
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine(this.getName() + ": MultiShapeLayer adding: " + sih);
            }
        } else {
            logger.fine(this.getName() + ": " + prefix + ShapeFileListProperty + " not set in properties");
        }
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.remove(prefix + "shapeFile");
        props.remove(prefix + "pointImageURL");
        Iterator<SpatialIndexHandler> sis = this.spatialIndexes.iterator();
        StringBuffer list = new StringBuffer();
        while (sis.hasNext()) {
            SpatialIndexHandler sih = sis.next();
            sih.getProperties(props);
            String pp = sih.getPropertyPrefix();
            pp = pp.substring(pp.lastIndexOf(46) + 1);
            list.append(" ").append(pp);
        }
        props.put(prefix + ShapeFileListProperty, list.toString());
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        props.remove("shapeFile");
        props.remove("pointImageURL");
        props.remove("shapeFile.editor");
        props.remove("pointImageURL.editor");
        Iterator<SpatialIndexHandler> sis = this.spatialIndexes.iterator();
        while (sis.hasNext()) {
            sis.next().getPropertyInfo(props);
        }
        props.put(ShapeFileListProperty, "List of marker names for SpatialIndexHandlers");
        return props;
    }

    @Override
    public synchronized OMGraphicList prepare() {
        if (this.spatialIndexes == null || this.spatialIndexes.isEmpty()) {
            logger.fine(this.getName() + ": spatialIndexes is empty!");
            return new OMGraphicList();
        }
        Projection projection = this.getProjection();
        if (projection == null) {
            logger.fine(this.getName() + ": prepare called with null projection");
            return new OMGraphicList();
        }
        Object ul = projection.getUpperLeft();
        Object lr = projection.getLowerRight();
        double ulLat = ((Point2D)ul).getY();
        double ulLon = ((Point2D)ul).getX();
        double lrLat = ((Point2D)lr).getY();
        double lrLon = ((Point2D)lr).getX();
        OMGraphicList masterList = new OMGraphicList();
        OMGraphicList list = null;
        if (ProjMath.isCrossingDateline(ulLon, lrLon, projection.getScale())) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.getName() + ": Dateline is on screen");
            }
            double ymin = Math.min(ulLat, lrLat);
            double ymax = Math.max(ulLat, lrLat);
            for (SpatialIndexHandler sih : this.spatialIndexes) {
                if (!sih.enabled) continue;
                try {
                    list = sih.getGraphics(ulLon, ymin, 180.0, ymax, list, projection);
                    list = sih.getGraphics(-180.0, ymin, lrLon, ymax, list, projection);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (FormatException fe) {
                    fe.printStackTrace();
                }
                masterList.add(list);
            }
        } else {
            double xmin = Math.min(ulLon, lrLon);
            double xmax = Math.max(ulLon, lrLon);
            double ymin = Math.min(ulLat, lrLat);
            double ymax = Math.max(ulLat, lrLat);
            for (SpatialIndexHandler sih : this.spatialIndexes) {
                if (!sih.enabled) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(this.getName() + ": Getting graphics from " + sih.prettyName + " spatial index");
                }
                try {
                    list = sih.getGraphics(xmin, ymin, xmax, ymax, list, projection);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (FormatException fe) {
                    fe.printStackTrace();
                }
                masterList.add(list);
            }
        }
        return masterList;
    }

    @Override
    public Component getGUI() {
        if (this.box == null) {
            this.box = new JPanel();
            JTabbedPane tabs = new JTabbedPane();
            this.box.setLayout(new BoxLayout(this.box, 1));
            this.box.setAlignmentX(0.0f);
            for (SpatialIndexHandler sih : this.spatialIndexes) {
                JPanel stuff = (JPanel)sih.getGUI();
                if (stuff == null) continue;
                tabs.addTab(sih.getPrettyName(), stuff);
            }
            this.box.add(tabs);
            JPanel pal2 = new JPanel();
            JButton redraw = new JButton("Redraw Layer");
            redraw.setActionCommand("redrawCmd");
            redraw.addActionListener(this);
            pal2.add(redraw);
            this.box.add(pal2);
        }
        return this.box;
    }

    @Override
    public DataBounds getDataBounds() {
        ESRIBoundingBox bounds = new ESRIBoundingBox();
        for (SpatialIndexHandler sih : this.spatialIndexes) {
            ESRIBoundingBox boundingBox;
            if (sih == null || sih.spatialIndex == null || (boundingBox = sih.spatialIndex.getBounds()) == null) continue;
            bounds.addBounds(boundingBox);
        }
        return new DataBounds(bounds.min.x, bounds.min.y, bounds.max.x, bounds.max.y);
    }
}

