/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link.shape;

import com.bbn.openmap.Environment;
import com.bbn.openmap.layer.link.LinkServerStarter;
import com.bbn.openmap.layer.link.shape.ShapeLinkServer;
import com.bbn.openmap.util.Debug;
import java.net.Socket;
import java.util.Properties;

public class ShapeServerStarter
extends LinkServerStarter {
    protected String shapeFile;

    public ShapeServerStarter(int port, String shapeFile, String shapeIndex) {
        this(port, shapeFile);
    }

    public ShapeServerStarter(int port, String shapeFile) {
        super(port);
        this.shapeFile = shapeFile;
    }

    public Thread startNewServer(Socket sock) {
        return new ShapeLinkServer(sock, this.shapeFile);
    }

    public static void main(String[] argv) {
        Properties p = System.getProperties();
        Debug.init(p);
        Environment.init(p);
        int pnumber = -1;
        String shp = null;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-port") && argv.length > i + 1) {
                try {
                    pnumber = Integer.parseInt(argv[i + 1]);
                    break;
                }
                catch (NumberFormatException e) {
                    pnumber = -1;
                    continue;
                }
            }
            if (argv[i].indexOf(".shp") == -1 && argv[i].indexOf(".SHP") == -1) continue;
            shp = argv[i];
        }
        if (pnumber < 0 || shp == null) {
            System.out.println("Need to start the server with a port number and shape file.");
            System.err.println("Usage: java com.bbn.openmap.layer.link.shape.ShapeServerStarter <ShapeFile Name.shp> -port <port number>");
            System.exit(-1);
        }
        System.out.println("ShapeServerStarter: Starting up on port " + pnumber + ".");
        ShapeServerStarter serverStarter = new ShapeServerStarter(pnumber, shp);
        while (true) {
            serverStarter.run();
        }
    }
}

