/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link.shape;

import com.bbn.openmap.Environment;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkBoundingPoly;
import com.bbn.openmap.layer.link.LinkGraphicList;
import com.bbn.openmap.layer.link.LinkMapRequest;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.layer.link.LinkServer;
import com.bbn.openmap.layer.link.shape.ESRILinkRecord;
import com.bbn.openmap.layer.link.shape.LinkSpatialIndex;
import com.bbn.openmap.layer.shape.ESRIRecord;
import com.bbn.openmap.util.ColorFactory;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Vector;

public class ShapeLinkServer
extends LinkServer
implements LinkPropertiesConstants {
    protected LinkSpatialIndex spatialIndex;
    protected Color lineColor = Color.black;
    protected Color fillColor = ColorFactory.createColor(0, 0, 0, 0, true);
    protected LinkProperties lineProperties;

    public ShapeLinkServer(Socket socket, String shapeFile) {
        super(socket);
        this.locateAndSetShapeData(shapeFile);
    }

    protected void finalize() {
        if (Debug.debugging("gc")) {
            Debug.output("ShapeLinkServer instance gc'd - client gone");
        }
    }

    public void handleClient() throws IOException {
        try {
            while (true) {
                if (Debug.debugging("shape")) {
                    this.link.clearBytesWritten();
                }
                this.link.readAndParse();
                boolean validQuery = false;
                LinkMapRequest graphicsQuery = this.link.getMapRequest();
                if (graphicsQuery != null) {
                    this.getRectangle(graphicsQuery, this.link);
                    validQuery = true;
                }
                graphicsQuery = null;
                if (!validQuery) {
                    this.huh(this.link);
                }
                if (!Debug.debugging("shape")) continue;
                System.out.println("ShapeLinkServer: bytes written for response: " + this.link.getBytesWritten());
            }
        }
        catch (IOException ioe) {
            this.spatialIndex = null;
            this.lineColor = null;
            this.fillColor = null;
            this.lineProperties = null;
            throw ioe;
        }
    }

    public void setFillColor(Color fColor) {
        this.fillColor = fColor;
    }

    public void setLineColor(Color lColor) {
        this.lineColor = lColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void getRectangle(LinkMapRequest query, Link link) throws IOException {
        if (this.spatialIndex == null) {
            link.end("\r");
        }
        LinkProperties args = query.getProperties();
        LinkGraphicList lgl = new LinkGraphicList(link, args);
        this.lineProperties = new LinkProperties();
        this.lineProperties.setReuseProperties(Boolean.TRUE);
        LinkBoundingPoly[] bounds = query.getBoundingPolys();
        for (int i = 0; i < bounds.length; ++i) {
            this.fetchGraphics(bounds[i].minX, bounds[i].minY, bounds[i].maxX, bounds[i].maxY, lgl, this.lineProperties);
        }
        lgl.end("\r");
    }

    protected void fetchGraphics(double xmin, double ymin, double xmax, double ymax, LinkGraphicList lgl, LinkProperties properties) throws IOException {
        Debug.message("shape", "fetchGraphics: " + xmin + ", " + ymin + ", " + xmax + ", " + ymax);
        try {
            ESRIRecord[] records = this.spatialIndex.locateRecords(xmin, ymin, xmax, ymax);
            int nRecords = records.length;
            for (int i = 0; i < nRecords; ++i) {
                if (!(records[i] instanceof ESRILinkRecord)) continue;
                ESRILinkRecord rec = (ESRILinkRecord)((Object)records[i]);
                rec.writeLinkGraphics(lgl, properties);
            }
        }
        catch (IOException ex) {
            if (Debug.debugging("shape")) {
                ex.printStackTrace();
            }
            return;
        }
        catch (FormatException fe) {
            Debug.error("ShapeLinkServer caught FormatException in the file");
            fe.printStackTrace();
        }
    }

    protected void locateAndSetShapeData(String shapeFileName) {
        Debug.message("shape", "ShapeLinkServer: Reading shape file.");
        String spatialIndexFileName = shapeFileName.substring(0, shapeFileName.indexOf(".shp")) + ".ssx";
        File spatialIndexFile = new File(spatialIndexFileName);
        if (spatialIndexFile.isAbsolute()) {
            try {
                this.spatialIndex = new LinkSpatialIndex(shapeFileName);
            }
            catch (IOException e) {
                if (Debug.debugging("shape")) {
                    e.printStackTrace();
                }
            }
        } else {
            Vector<String> dirs = Environment.getClasspathDirs();
            int nDirs = dirs.size();
            if (nDirs > 0) {
                for (String dir : dirs) {
                    File sif = new File(dir, spatialIndexFileName);
                    if (!sif.isFile()) continue;
                    File sf = new File(dir, shapeFileName);
                    try {
                        this.spatialIndex = new LinkSpatialIndex(sf.toString());
                        break;
                    }
                    catch (IOException e) {
                        if (!Debug.debugging("shape")) continue;
                        e.printStackTrace();
                    }
                }
                if (this.spatialIndex == null) {
                    System.err.println("Unable to find file: " + shapeFileName);
                    System.err.println("Unable to find file: " + spatialIndexFileName);
                }
            } else {
                System.err.println("No directories in CLASSPATH!");
                System.err.println("Unable to locate file: " + shapeFileName);
                System.err.println("Unable to locate file: " + spatialIndexFileName);
            }
        }
    }
}

