/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.ClientLink;
import com.bbn.openmap.layer.link.LinkLayer;
import com.bbn.openmap.layer.link.LinkManager;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.omGraphics.grid.OMGridGenerator;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.SwingWorker;
import java.io.IOException;

public class LinkListener
extends Thread
implements LinkPropertiesConstants {
    protected LinkManager linkManager;
    protected LinkLayer layer;
    protected OMGridGenerator currentGenerator = null;
    protected boolean listening = false;

    private LinkListener() {
    }

    public LinkListener(LinkManager linkManager, LinkLayer layer, OMGridGenerator generator) {
        this.linkManager = linkManager;
        this.layer = layer;
        this.currentGenerator = generator;
    }

    public synchronized boolean isListening() {
        return this.listening;
    }

    protected synchronized void setListening(boolean value) {
        this.listening = value;
    }

    protected LinkListener getListener() {
        return this;
    }

    public void startUp() {
        SwingWorker sw = new SwingWorker(){

            public Object construct() {
                if (Debug.debugging("link")) {
                    Debug.output("LinkListener self-starting...");
                }
                LinkListener.this.getListener().start();
                return null;
            }
        };
        sw.execute();
    }

    public void run() {
        try {
            Debug.message("link", "*** LinkListener starting up ***");
            this.setListening(true);
            this.listen();
            Debug.message("link", "...done listening");
        }
        catch (IOException ioe) {
            if (Debug.debugging("link")) {
                Debug.error(ioe.getMessage());
            }
            Debug.message("link", "LinkListener: Server disconnected");
        }
        this.layer.setListener(null);
    }

    public void listen() throws IOException {
        Debug.message("link", "LinkListener: Asynchronously listening...");
        ClientLink link = this.linkManager.getLink(this);
        Debug.message("link", "LinkListener got link...");
        while (link != null) {
            Debug.message("link", "LinkListener: listening...");
            link.readAndParse(null, this.currentGenerator, this.layer);
            Debug.message("link", "LinkListener: received content from server");
            this.layer.handleLinkGraphicList(link.getGraphicList());
            this.layer.handleLinkActionRequest(link.getActionRequest());
            this.layer.handleLinkActionList(link.getActionList());
            link = this.linkManager.getLink(this);
        }
    }
}

