/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.editor;

import com.bbn.openmap.InformationDelegator;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.gui.GridBagToolBar;
import com.bbn.openmap.gui.OMGraphicDeleteTool;
import com.bbn.openmap.layer.DrawingToolLayer;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.editor.AbstractEditorTool;
import com.bbn.openmap.layer.editor.EditorLayer;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.tools.drawing.DrawingToolRequestor;
import com.bbn.openmap.tools.drawing.EditToolLoader;
import com.bbn.openmap.tools.drawing.OMCircleLoader;
import com.bbn.openmap.tools.drawing.OMDistanceLoader;
import com.bbn.openmap.tools.drawing.OMDrawingTool;
import com.bbn.openmap.tools.drawing.OMDrawingToolMouseMode;
import com.bbn.openmap.tools.drawing.OMLineLoader;
import com.bbn.openmap.tools.drawing.OMPointLoader;
import com.bbn.openmap.tools.drawing.OMPolyLoader;
import com.bbn.openmap.tools.drawing.OMRectLoader;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.beancontext.BeanContext;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class DrawingEditorTool
extends AbstractEditorTool
implements ActionListener,
PropertyChangeListener,
PropertyConsumer {
    protected OMDrawingTool drawingTool = null;
    protected OMDrawingToolMouseMode omdtmm = null;
    protected String thingToCreate = null;
    protected ButtonGroup bg = null;
    protected JToggleButton unpickBtn = null;
    protected GraphicAttributes ga = null;
    protected MouseDelegator mouseDelegator;
    protected ArrayList<EditToolLoader> loaderList = new ArrayList();
    public static final String RESET_CMD = "RESET_CMD";
    protected String propertyPrefix;
    protected Hashtable<String, DrawingAttributes> drawingAttributesTable = new Hashtable();
    protected boolean showAttributes = true;
    public static final String ShowAttributesProperty = "showAttributes";
    public static final String LoaderProperty = "loaders";
    public static final String AttributesClassProperty = "attributesClass";
    public static final String DefaultDrawingAttributesClass = "com.bbn.openmap.omGraphics.DrawingAttributes";

    public DrawingEditorTool(EditorLayer layer) {
        super(layer);
        this.initDrawingTool();
        layer.setDrawingTool(this.drawingTool);
    }

    public void initDrawingTool() {
        this.drawingTool = this.createDrawingTool();
        this.drawingTool.setUseAsTool(true);
        this.drawingTool.getMouseMode().setVisible(false);
        this.ga = this.drawingTool.getAttributes();
        this.ga.setRenderType(1);
        this.ga.setLineType(3);
    }

    protected OMDrawingTool createDrawingTool() {
        return new OMDrawingTool();
    }

    public void addEditToolLoader(EditToolLoader loader) {
        this.loaderList.add(loader);
        this.drawingTool.addLoader(loader);
    }

    public void removeEditToolLoader(EditToolLoader loader) {
        this.loaderList.remove(loader);
        this.drawingTool.removeLoader(loader);
    }

    public void clearEditToolLoaders() {
        this.loaderList.clear();
        this.drawingTool.setLoaders(null);
    }

    public void initDefaultDrawingToolLoaders() {
        this.addEditToolLoader(new OMDistanceLoader());
        this.addEditToolLoader(new OMLineLoader());
        this.addEditToolLoader(new OMPolyLoader());
        this.addEditToolLoader(new OMRectLoader());
        this.addEditToolLoader(new OMCircleLoader());
        this.addEditToolLoader(new OMPointLoader());
    }

    protected void setWantsEvents(String command) {
        if (Debug.debugging("editortool")) {
            Debug.output("DET.setWantsEvents(" + command + ")");
        }
        this.thingToCreate = command;
        this.setWantsEvents(true);
    }

    public void setWantsEvents(boolean value) {
        super.setWantsEvents(value);
        if (!value) {
            this.thingToCreate = null;
        }
        if (this.drawingTool != null && this.drawingTool.isActivated()) {
            this.drawingTool.resetGUIWhenDeactivated(true);
            this.drawingTool.deactivate();
        }
        this.resetForNewGraphic();
        if (this.drawingTool != null) {
            this.drawingTool.setVisible(this.showAttributes);
        }
    }

    public void findAndInit(Object someObj) {
        super.findAndInit(someObj);
        if (someObj instanceof MapBean || someObj instanceof InformationDelegator) {
            this.drawingTool.findAndInit(someObj);
        }
        if (someObj instanceof MouseDelegator) {
            this.setMouseDelegator((MouseDelegator)someObj);
            this.drawingTool.findAndInit(someObj);
        }
        if (someObj instanceof OMGraphicDeleteTool) {
            ((OMGraphicDeleteTool)someObj).findAndInit(this.getDrawingTool());
        }
    }

    public void findAndUndo(Object someObj) {
        super.findAndUndo(someObj);
        this.unhook(someObj);
    }

    public void dispose() {
        BeanContext bc;
        OMGraphicHandlerLayer layer = this.getLayer();
        if (layer != null && (bc = layer.getBeanContext()) instanceof MapHandler) {
            MapHandler mh = (MapHandler)bc;
            this.unhook(mh.get(MouseDelegator.class));
            this.unhook(mh.get(MapBean.class));
            this.unhook(mh.get(InformationDelegator.class));
            this.unhook(mh.get(OMGraphicDeleteTool.class));
        }
    }

    protected void unhook(Object someObj) {
        if (someObj == null) {
            return;
        }
        if (someObj == this.mouseDelegator) {
            this.setMouseDelegator(null);
        }
        if (someObj instanceof MapBean || someObj instanceof InformationDelegator) {
            this.drawingTool.findAndUndo(someObj);
        }
        if (someObj instanceof OMGraphicDeleteTool) {
            ((OMGraphicDeleteTool)someObj).findAndUndo(this.drawingTool);
        }
    }

    public void drawingComplete(OMGraphic omg, OMAction action) {
        if (this.thingToCreate != null) {
            this.drawingTool.resetGUIWhenDeactivated(false);
        }
        this.omdtmm = null;
    }

    public void resetForNewGraphic() {
        this.omdtmm = this.activateDrawingTool(this.thingToCreate);
    }

    public void totalReset() {
        if (this.wantsEvents()) {
            MapMouseMode[] modes;
            this.setWantsEvents(false);
            if (this.unpickBtn != null) {
                this.unpickBtn.doClick();
            }
            if (this.mouseDelegator != null && (modes = this.mouseDelegator.getMouseModes()) != null && modes.length > 0) {
                this.mouseDelegator.setActiveMouseMode(modes[0]);
            }
        }
    }

    public void setDrawingTool(OMDrawingTool omdt) {
        this.drawingTool = omdt;
    }

    public OMDrawingTool getDrawingTool() {
        return this.drawingTool;
    }

    public GraphicAttributes getGraphicAttributes() {
        return this.ga;
    }

    public void setGraphicAttributes(GraphicAttributes ga) {
        this.ga = ga;
    }

    public boolean isShowAttributes() {
        return this.showAttributes;
    }

    public void setShowAttributes(boolean showAttributes) {
        this.showAttributes = showAttributes;
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (Debug.debugging("editortool")) {
            Debug.output("DET.actionPerformed(" + command + ")");
        }
        if (command == RESET_CMD) {
            this.setWantsEvents(false);
        } else if (command != this.thingToCreate) {
            EditorLayer elayer = (EditorLayer)this.getLayer();
            elayer.releaseProxyMouseMode();
            if (this.thingToCreate == null && this.mouseDelegator != null) {
                this.mouseDelegator.setActiveMouseModeWithID(elayer.getMouseMode().getID());
            }
            this.setWantsEvents(command);
        }
    }

    protected OMDrawingToolMouseMode activateDrawingTool(String ttc) {
        if (this.drawingTool != null && ttc != null) {
            DrawingAttributes da = this.drawingAttributesTable.get(ttc);
            if (da != null) {
                da.setOrientation(this.ga.getOrientation());
                da.setTo(this.ga);
            }
            if (Debug.debugging("editortool")) {
                Debug.output("DrawingEditorTool.activateDrawingTool(" + ttc + ")");
            }
            this.drawingTool.setMask(16);
            OMGraphic newOMG = this.drawingTool.create(ttc, this.ga, (DrawingToolRequestor)((Object)this.getLayer()), true);
            if (newOMG == null) {
                if (Debug.debugging("editortool")) {
                    Debug.output("DrawingEditorTool.activateDrawingTool() failed, cleaning up...");
                }
                this.drawingTool.deactivate();
                return null;
            }
            OMGraphicHandlerLayer el = this.getLayer();
            if (el instanceof EditorLayer) {
                ((EditorLayer)el).creatingOMGraphic(newOMG);
            }
            return this.drawingTool.getMouseMode();
        }
        if (Debug.debugging("editortool")) {
            Debug.output("DrawingEditorTool.activateDrawingTool(" + ttc + ") with drawing tool = " + this.drawingTool);
        }
        return null;
    }

    public boolean mousePressed(MouseEvent e) {
        if (this.wantsEvents()) {
            if (this.omdtmm != null) {
                this.omdtmm.mousePressed(e);
            }
            return this.consumeEvents;
        }
        return super.mousePressed(e);
    }

    public boolean mouseReleased(MouseEvent e) {
        if (this.wantsEvents()) {
            if (this.omdtmm != null) {
                this.omdtmm.mouseReleased(e);
                return true;
            }
            return false;
        }
        return super.mouseReleased(e);
    }

    public boolean mouseClicked(MouseEvent e) {
        if (this.wantsEvents()) {
            if (this.omdtmm != null) {
                this.omdtmm.mouseClicked(e);
                return this.consumeEvents;
            }
            return false;
        }
        return super.mouseClicked(e);
    }

    public void mouseEntered(MouseEvent e) {
        if (this.wantsEvents()) {
            if (this.omdtmm != null) {
                this.omdtmm.mouseEntered(e);
            }
        } else {
            super.mouseEntered(e);
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.wantsEvents()) {
            if (this.omdtmm != null) {
                this.omdtmm.mouseExited(e);
            }
        } else {
            super.mouseExited(e);
        }
    }

    public boolean mouseDragged(MouseEvent e) {
        if (this.wantsEvents()) {
            if (this.omdtmm != null) {
                this.omdtmm.mouseDragged(e);
                return this.consumeEvents;
            }
            return false;
        }
        return super.mouseDragged(e);
    }

    public boolean mouseMoved(MouseEvent e) {
        if (this.wantsEvents()) {
            if (this.omdtmm != null) {
                this.omdtmm.mouseMoved(e);
                return this.consumeEvents;
            }
            if (this.thingToCreate != null) {
                this.omdtmm = this.activateDrawingTool(this.thingToCreate);
                return this.consumeEvents;
            }
            return false;
        }
        return super.mouseMoved(e);
    }

    public void setVisible(boolean value) {
        super.setVisible(value);
        if (!value) {
            this.totalReset();
        }
    }

    public Container getFace() {
        if (this.face == null) {
            GridBagToolBar faceTB = new GridBagToolBar();
            int orientation = ((EditorLayer)this.getLayer()).getOrientation();
            ((JToolBar)faceTB).setOrientation(orientation);
            if (this.bg == null) {
                this.bg = new ButtonGroup();
            }
            this.fillFaceToolBar(faceTB, this.bg);
            this.unpickBtn = new JToggleButton("", false);
            this.unpickBtn.setActionCommand(RESET_CMD);
            this.unpickBtn.addActionListener(this);
            this.unpickBtn.setVisible(false);
            this.bg.add(this.unpickBtn);
            ((Container)faceTB).add(this.unpickBtn);
            if (this.drawingTool != null && this.showAttributes) {
                this.drawingTool.setOrientation(orientation);
                ((Container)faceTB).add(this.drawingTool);
                this.drawingTool.showPalette();
            }
            this.face = faceTB;
            this.face.setVisible(this.visible);
        }
        return this.face;
    }

    protected void fillFaceToolBar(JToolBar faceTB, ButtonGroup bg) {
        for (EditToolLoader loader : this.loaderList) {
            String[] classnames = loader.getEditableClasses();
            for (int i = 0; i < classnames.length; ++i) {
                ImageIcon icon = loader.getIcon(classnames[i]);
                JToggleButton btn = new JToggleButton(icon, false);
                btn.setToolTipText(loader.getPrettyName(classnames[i]));
                btn.setFocusable(false);
                btn.setActionCommand(classnames[i]);
                btn.addActionListener(this);
                bg.add(btn);
                faceTB.add(btn);
            }
        }
    }

    public void setMouseDelegator(MouseDelegator md) {
        EditorLayer el = (EditorLayer)this.getLayer();
        if (this.mouseDelegator != null) {
            if (el != null) {
                this.mouseDelegator.removeMouseMode(el.getMouseMode());
            }
            this.mouseDelegator.removePropertyChangeListener(this);
        }
        this.mouseDelegator = md;
        if (this.mouseDelegator == null) {
            return;
        }
        if (el != null) {
            this.mouseDelegator.addMouseMode(el.getMouseMode());
        }
        this.mouseDelegator.addPropertyChangeListener(this);
    }

    public MouseDelegator getMouseDelegator() {
        return this.mouseDelegator;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "NewActiveMouseMode") {
            String mmID = ((MapMouseMode)evt.getNewValue()).getID();
            if (Debug.debugging("editortool")) {
                Debug.output("DET.propertyChange: mousemode changed to " + mmID);
            }
            if (mmID != ((EditorLayer)this.getLayer()).getMouseMode().getID()) {
                this.totalReset();
            }
            this.drawingTool.showPalette();
        }
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public void setProperties(String prefix, Properties props) {
        String loaderListString;
        this.setPropertyPrefix(prefix);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.showAttributes = PropUtils.booleanFromProperties(props, prefix + ShowAttributesProperty, this.showAttributes);
        if (this.drawingTool != null) {
            this.drawingTool.setProperties(prefix, props);
        }
        if ((loaderListString = props.getProperty(prefix + LoaderProperty)) != null) {
            Vector<String> loaderVector = PropUtils.parseSpacedMarkers(loaderListString);
            for (String loaderPrefix : loaderVector) {
                String loaderPropertyPrefix = PropUtils.getScopedPropertyPrefix(prefix + loaderPrefix);
                String loaderClassString = props.getProperty(loaderPropertyPrefix + "class");
                String loaderAttributeClass = props.getProperty(loaderPropertyPrefix + AttributesClassProperty);
                if (loaderClassString != null) {
                    Object obj = ComponentFactory.create(loaderClassString, loaderPropertyPrefix, props);
                    if (!(obj instanceof EditToolLoader)) continue;
                    EditToolLoader loader = (EditToolLoader)obj;
                    if (Debug.debugging("editortool")) {
                        Debug.output("DrawingEditorTool: adding " + loaderClassString);
                    }
                    this.addEditToolLoader(loader);
                    if (loaderAttributeClass != null) {
                        Object daObject;
                        if (Debug.debugging("editortool")) {
                            Debug.output("DrawingEditorTool: getting attributes for " + loaderAttributeClass);
                        }
                        if ((daObject = ComponentFactory.create(loaderAttributeClass, loaderPropertyPrefix, props)) instanceof DrawingAttributes) {
                            if (Debug.debugging("editortool")) {
                                Debug.output("DrawingEditorTool: attributes from " + loaderAttributeClass);
                            }
                            String[] classnames = loader.getEditableClasses();
                            for (int i = 0; i < classnames.length; ++i) {
                                this.drawingAttributesTable.put(classnames[i], (DrawingAttributes)daObject);
                            }
                            continue;
                        }
                        if (!Debug.debugging("editortool")) continue;
                        Debug.output("DrawingEditorTool: attributes not an instance of DrawingAttributes");
                        continue;
                    }
                    if (!Debug.debugging("editortool")) continue;
                    Debug.output("DrawingEditorTool: attributes not defined for " + loaderClassString);
                    continue;
                }
                Debug.output("DrawingEditorTool.setProperties:  no loader class provided for " + loaderPropertyPrefix);
            }
            if (this.layer instanceof DrawingToolLayer && this.ga != null) {
                ((DrawingToolLayer)this.layer).getDrawingAttributes().setTo(this.ga);
            }
        } else {
            Debug.output("DrawingEditorTool.setProperties: no loaders set in properties");
        }
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        return props;
    }
}

