/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.e00;

import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.e00.ArcData;
import com.bbn.openmap.layer.e00.E00Data;
import com.bbn.openmap.layer.e00.E00Parser;
import com.bbn.openmap.layer.location.BasicLocation;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class E00Layer
extends OMGraphicHandlerLayer
implements ActionListener {
    protected OMGraphicList arcs;
    protected OMGraphicList labs;
    protected OMGraphicList tx7;
    protected boolean ArcVisible = true;
    protected boolean LabVisible = true;
    protected boolean Tx7Visible = true;
    protected JPanel gui;
    protected JLabel label;
    protected Paint[] ArcColors;
    protected Paint[] LabColors;
    protected Paint Tx7Color;
    protected Paint SelectTx7Color;
    protected Paint SelectLabColor;
    protected Paint SelectArcColor;
    protected Paint LabTextColor;
    protected OMGraphic LabMarker;
    protected Font LabFont;
    protected Font Tx7Font;
    protected int filtreValeur = Integer.MIN_VALUE;
    protected int filtreType = Integer.MIN_VALUE;
    protected JFileChooser fileChooser;
    protected File E00File;

    public E00Layer() {
        this.setMouseModeIDsForEvents(new String[]{"Gestures"});
    }

    public synchronized OMGraphicList prepare() {
        Projection proj;
        OMGraphicList g = this.getList();
        if (g == null) {
            try {
                E00Parser parser = new E00Parser(this.E00File);
                parser.setPaints(this.ArcColors, this.LabColors, this.Tx7Color, this.SelectTx7Color, this.SelectLabColor, this.SelectArcColor, this.LabTextColor);
                parser.setLabMarker(this.LabMarker);
                parser.setFonts(this.LabFont, this.Tx7Font);
                g = parser.getOMGraphics();
                this.arcs = parser.getArcList();
                this.labs = parser.getLabList();
                this.tx7 = parser.getTx7List();
                this.setListVisibility();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                Debug.error("E00Layer|" + this.getName() + ".prepare(): " + ex.getMessage());
            }
        }
        if ((proj = this.getProjection()) != null && g != null) {
            g.generate(proj);
        }
        return g;
    }

    public void setProperties(String prefix, Properties props) {
        block2: {
            super.setProperties(prefix, props);
            String E00FileName = props.getProperty(prefix + ".FileName");
            this.ArcVisible = PropUtils.booleanFromProperties(props, prefix + ".ArcVisible", this.ArcVisible);
            this.LabVisible = PropUtils.booleanFromProperties(props, prefix + ".LabVisible", this.LabVisible);
            this.Tx7Visible = PropUtils.booleanFromProperties(props, prefix + ".Tx7Visible", this.Tx7Visible);
            Paint dfault = null;
            this.ArcColors = this.parseColors(props, prefix, "ArcColors", Color.black);
            this.LabColors = this.parseColors(props, prefix, "LabColors", Color.black);
            this.Tx7Color = this.parseColor(props, prefix, "Tx7Color", dfault);
            this.SelectTx7Color = this.parseColor(props, prefix, "SelectTx7Color", null);
            this.SelectLabColor = this.parseColor(props, prefix, "SelectLabColor", null);
            this.SelectArcColor = this.parseColor(props, prefix, "SelectArcColor", null);
            this.LabTextColor = this.parseColor(props, prefix, "LabTextColor", null);
            this.LabFont = this.parseFont(props, prefix, "LabFont", null);
            this.Tx7Font = this.parseFont(props, prefix, "tx7Font", null);
            try {
                this.openFile(new File(E00FileName));
            }
            catch (Exception ex) {
                Debug.error("E00Layer: error - " + ex.getMessage());
                if (!Debug.debugging("e00")) break block2;
                ex.printStackTrace();
            }
        }
    }

    public Component getGUI() {
        if (this.gui == null) {
            this.gui = PaletteHelper.createPaletteJPanel("E00");
            this.label = new JLabel(this.E00File != null ? this.E00File.getName() : "       ");
            this.gui.add(this.label);
            this.addToGUI(this.gui, new JCheckBox("Arcs", this.ArcVisible), "ARCS");
            this.addToGUI(this.gui, new JCheckBox("Points", this.LabVisible), "LABS");
            this.addToGUI(this.gui, new JCheckBox("Tx7", this.Tx7Visible), "TX7");
            this.gui.add(new JLabel("Filter"));
            this.gui.add(new JLabel(" By Value"));
            this.addToGUI(this.gui, new JTextField(10), "VALEUR");
            this.gui.add(new JLabel(" By Type"));
            this.addToGUI(this.gui, new JTextField(10), "TYPE");
            this.gui.add(new JSeparator());
            this.addToGUI(this.gui, new JButton("Open File"), "OPEN");
            this.addToGUI(this.gui, new JButton("Export Arcs"), "ExpArcs");
            this.addToGUI(this.gui, new JButton("Export Points"), "ExpPoints");
        }
        return this.gui;
    }

    protected void addToGUI(JPanel gui, AbstractButton b, String cmd) {
        b.setActionCommand(cmd);
        b.addActionListener(this);
        gui.add(b);
    }

    protected void addToGUI(JPanel gui, JTextField b, String cmd) {
        b.setActionCommand(cmd);
        b.addActionListener(this);
        gui.add(b);
    }

    public void actionPerformed(ActionEvent e) {
        String Action2 = e.getActionCommand();
        if ("OPEN".equals(Action2)) {
            this.openFile(this.chooseFile(0));
            this.doPrepare();
        } else if ("ExpArcs".equals(Action2)) {
            this.exportArcs1();
        } else if ("ExpPoints".equals(Action2)) {
            this.exportPoints();
        } else if ("VALEUR".equals(Action2)) {
            this.filtreValeur = this.getVal(e);
            this.filtre();
        } else if ("TYPE".equals(Action2)) {
            this.filtreType = this.getVal(e);
            this.filtre();
        } else if ("ARCS".equals(Action2)) {
            JCheckBox cb = (JCheckBox)e.getSource();
            this.ArcVisible = cb.isSelected();
            if (this.arcs != null) {
                this.arcs.setVisible(this.ArcVisible);
            }
            this.repaint();
        } else if ("LABS".equals(Action2)) {
            JCheckBox cb = (JCheckBox)e.getSource();
            this.LabVisible = cb.isSelected();
            if (this.labs != null) {
                this.labs.setVisible(this.LabVisible);
            }
            this.repaint();
        } else if ("TX7".equals(Action2)) {
            JCheckBox cb = (JCheckBox)e.getSource();
            this.Tx7Visible = cb.isSelected();
            if (this.tx7 != null) {
                this.tx7.setVisible(this.Tx7Visible);
            }
            this.repaint();
        }
    }

    public String getInfoText(OMGraphic omg) {
        String t = "";
        if (this.arcs != null && this.arcs.contains(omg)) {
            t = "arcs";
        } else if (this.labs != null && this.labs.contains(omg)) {
            t = "point";
        }
        E00Data d = (E00Data)omg.getAppObject();
        return t + d;
    }

    protected Frame getFrame() {
        if (this.gui == null) {
            return null;
        }
        for (Container p = this.gui.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            return (Frame)p;
        }
        return null;
    }

    void setLineColor(Color C) {
        OMGraphicList graphics = this.getList();
        if (graphics != null) {
            graphics.setLinePaint(C);
        }
        this.repaint();
    }

    int getVal(ActionEvent e) {
        int val;
        JTextField T = (JTextField)e.getSource();
        try {
            val = Integer.parseInt(T.getText());
        }
        catch (NumberFormatException ex) {
            val = Integer.MIN_VALUE;
        }
        return val;
    }

    public void setListVisibility() {
        if (this.arcs != null) {
            this.arcs.setVisible(this.ArcVisible);
        }
        if (this.labs != null) {
            this.labs.setVisible(this.LabVisible);
        }
        if (this.tx7 != null) {
            this.tx7.setVisible(this.Tx7Visible);
        }
    }

    protected void openFile(File f) {
        if (f == null) {
            return;
        }
        if (!f.exists()) {
            Debug.output("E00|" + this.getName() + ": missing file");
            return;
        }
        this.E00File = f;
        if (this.gui != null) {
            this.label.setText(this.E00File.getName());
        }
    }

    protected File chooseFile(int type) {
        Frame frame = this.getFrame();
        File f = null;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        this.fileChooser.setCurrentDirectory(this.E00File);
        if (type == 0) {
            this.fileChooser.setDialogType(0);
        } else {
            this.fileChooser.setDialogType(1);
        }
        int retval = this.fileChooser.showDialog(frame, null);
        if (retval == 0) {
            f = this.fileChooser.getSelectedFile();
        }
        return f;
    }

    protected void filtre() {
        System.out.print("E00: filter type=" + this.filtreType + "  value=" + this.filtreValeur);
        int count = 0;
        OMGraphicList g = this.arcs;
        int n = this.arcs.size();
        if (this.filtreType == Integer.MIN_VALUE && this.filtreValeur == Integer.MIN_VALUE) {
            for (int i = 0; i < n; ++i) {
                g.getOMGraphicAt(i).setVisible(true);
            }
            count = n;
        } else {
            for (int i = 0; i < n; ++i) {
                OMGraphic og = g.getOMGraphicAt(i);
                Object O = og.getAppObject();
                if (O == null) {
                    this.setVisible(false);
                    continue;
                }
                E00Data d = (E00Data)O;
                boolean r = true;
                if (this.filtreType != Integer.MIN_VALUE) {
                    r &= this.filtreType == d.type;
                }
                if (this.filtreValeur != Integer.MIN_VALUE) {
                    r &= this.filtreValeur == d.valeur;
                }
                og.setVisible(r);
                if (!r) continue;
                ++count;
            }
        }
        Debug.output(" count:" + count);
        this.repaint();
    }

    protected void exportArcs() {
        ArcData d0;
        int i;
        double ln;
        double lt;
        int llsize;
        double[] ll;
        double lnmin;
        if (this.arcs == null) {
            return;
        }
        Vector<ArcData> V = new Vector<ArcData>();
        int n = this.arcs.size();
        double lnmax = Double.MIN_VALUE;
        double ltmin = lnmin = Double.MAX_VALUE;
        double ltmax = lnmax;
        for (int i2 = 0; i2 < n; ++i2) {
            E00Data data;
            OMPoly oj = (OMPoly)this.arcs.getOMGraphicAt(i2);
            if (oj == null || (data = (E00Data)oj.getAppObject()) == null) continue;
            ll = oj.getLatLonArray();
            if (ll[0] != ll[(llsize = ll.length) - 2] || ll[1] != ll[llsize - 1]) {
                double[] coords = new double[]{ll[0], ll[1], ll[llsize - 2], ll[llsize - 1]};
                ArcData dn = new ArcData(data);
                dn.coords = coords;
                oj.setAppObject(dn);
                V.add(dn);
            }
            int k = 0;
            while (k < llsize) {
                lt = ll[k++];
                ln = ll[k++];
                if (lt > ltmax) {
                    ltmax = lt;
                } else if (lt < ltmin) {
                    ltmin = lt;
                }
                if (ln > lnmax) {
                    lnmax = ln;
                    continue;
                }
                if (!(ln < lnmin)) continue;
                lnmin = ln;
            }
        }
        System.out.println("#minmax " + lnmin + " " + lnmax + " " + ltmin + " " + ltmax);
        int unClosedCount = V.size();
        ArcData[] unClosed = V.toArray(new ArcData[unClosedCount]);
        V.clear();
        V = null;
        for (i = 0; i < unClosedCount; ++i) {
            d0 = unClosed[i];
            d0.deja = 0;
            if (d0.type > 1) continue;
            double lt1 = d0.coords[0];
            double lg1 = d0.coords[1];
            double lt2 = d0.coords[2];
            double lg2 = d0.coords[3];
            for (int j = i + 1; j < unClosedCount; ++j) {
                ArcData d1 = unClosed[j];
                if (d1.type > 1) continue;
                if (lt1 == d1.coords[0] && lg1 == d1.coords[1]) {
                    d1.setC(d0);
                    d0.setC(d1);
                } else if (lt1 == d1.coords[2] && lg1 == d1.coords[3]) {
                    d1.setF(d0);
                    d0.setC(d1);
                }
                if (lt2 == d1.coords[0] && lg2 == d1.coords[1]) {
                    d1.setC(d0);
                    d0.setF(d1);
                    continue;
                }
                if (lt2 != d1.coords[2] || lg2 != d1.coords[3]) continue;
                d1.setF(d0);
                d0.setF(d1);
            }
        }
        for (int k = 0; k < unClosedCount; ++k) {
            d0 = unClosed[k];
            if (d0.type != 0 || d0.deja != 0 || d0.c0 == null && d0.f0 == null) continue;
            ArcData d1 = d0;
            ArcData d2 = d1.c0 == null ? d1.f0 : d1.c0;
            System.out.print("#contour ");
            System.out.print(d0.id);
            System.out.print(' ');
            int decount = unClosedCount * 3 / 2;
            do {
                System.out.print(d2.id);
                if (d2.deja != 0) {
                    System.out.print('*');
                }
                System.out.print(' ');
                ArcData dx = d2.visit(d1);
                d1 = d2;
                d2 = dx;
                if (decount-- >= 0) continue;
                System.out.print(" BOUCLE ");
                break;
            } while (d2 != null && d2 != d0);
            if (d2 == null) {
                System.out.print(" unclosed");
            }
            System.out.println();
            System.out.println();
        }
        for (i = 0; i < n; ++i) {
            E00Data data;
            OMPoly oj = (OMPoly)this.arcs.getOMGraphicAt(i);
            if (oj == null || (data = (E00Data)oj.getAppObject()) == null) continue;
            ll = oj.getLatLonArray();
            llsize = ll.length;
            double z = (double)data.valeur * 0.304;
            boolean closed = true;
            if (data instanceof ArcData) {
                ArcData dn = (ArcData)data;
                dn.coords = null;
                closed = false;
            }
            int k = 0;
            System.out.println("#type " + data.type);
            while (k < llsize) {
                lt = ll[k++];
                ln = ll[k++];
                System.out.println("c " + ln + " " + lt + " " + z);
            }
            System.out.println(closed ? "#LC" : "#LX");
            System.out.println();
        }
    }

    protected void exportArcs1() {
        PrintStream out = null;
        File f = this.chooseFile(1);
        if (this.arcs == null) {
            return;
        }
        if (f == null) {
            return;
        }
        try {
            out = new PrintStream(new FileOutputStream(f));
        }
        catch (IOException e) {
            System.out.println(e);
            return;
        }
        int n = this.arcs.size();
        for (int i = 0; i < n; ++i) {
            OMPoly oj = (OMPoly)this.arcs.getOMGraphicAt(i);
            if (oj == null || !oj.isSelected()) continue;
            double[] ll = oj.getLatLonArray();
            int llsize = ll.length;
            out.println(oj.getLinePaint());
            if (ll[0] != ll[llsize - 2] || ll[1] != ll[llsize - 1]) {
                out.print("MetaPolyline: ");
            } else {
                llsize -= 2;
                out.print("MetaPolyline: ");
            }
            out.print(llsize / 2);
            Object o = oj.getAppObject();
            if (o instanceof String) {
                System.out.println(o);
            } else {
                out.println();
            }
            int k = 0;
            while (k < llsize) {
                double lt = ll[k++];
                double ln = ll[k++];
                out.println(ln + " " + lt);
            }
        }
        out.close();
    }

    protected void exportPoints() {
        if (this.labs == null) {
            return;
        }
        int n = this.labs.size();
        System.out.println("#type 0");
        for (int i = 0; i < n; ++i) {
            E00Data data;
            BasicLocation oj = (BasicLocation)this.labs.getOMGraphicAt(i);
            if (oj == null || (data = (E00Data)oj.getAppObject()) == null) continue;
            double lt = Math.toRadians(oj.lat);
            double ln = Math.toRadians(oj.lon);
            double z = (double)data.valeur * 0.304;
            System.out.println("c " + ln + " " + lt + " " + z);
        }
    }

    protected Paint parseColor(Properties props, String prefix, String prop, Paint dfault) {
        try {
            return PropUtils.parseColorFromProperties(props, prefix + "." + prop, dfault);
        }
        catch (NumberFormatException exc) {
            System.out.println("Color Error " + prefix + "." + prop);
            return dfault;
        }
    }

    protected Paint[] parseColors(Properties props, String prefix, String prop, Paint err) {
        Color[] colors = null;
        String[] colorStrings = PropUtils.stringArrayFromProperties(props, prefix + "." + prop, " ,");
        if (colorStrings != null) {
            colors = new Color[colorStrings.length];
            for (int i = 0; i < colorStrings.length; ++i) {
                try {
                    colors[i] = PropUtils.parseColor(colorStrings[i]);
                    continue;
                }
                catch (NumberFormatException exc) {
                    System.out.println("Colors Error " + prefix + "." + prop + " " + i);
                    colors[i] = err;
                }
            }
        }
        return colors;
    }

    protected Font parseFont(Properties props, String prefix, String prop, Font dfault) {
        String[] fontItems = PropUtils.stringArrayFromProperties(props, prefix + "." + prop, " ,");
        int style = 0;
        int size = 10;
        if (fontItems == null || fontItems.length == 0) {
            return dfault;
        }
        try {
            size = Integer.parseInt(fontItems[1]);
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i = 2; i < fontItems.length; ++i) {
            String S = fontItems[i];
            if ("BOLD".equals(S)) {
                style |= 1;
                continue;
            }
            if ("ITALIC".equals(S)) {
                style |= 2;
                continue;
            }
            if (!"PLAIN".equals(S)) continue;
            style |= 0;
        }
        return new Font(fontItems[0], style, size);
    }
}

