/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.layer.LabelLayer;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.Taskable;
import java.awt.Graphics;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;
import java.util.TimeZone;

public class DateLayer
extends LabelLayer
implements Taskable,
MapMouseListener {
    public static final transient String dateFormatProperty = "date.format";
    protected DateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String dateFormatString = props.getProperty(prefix + dateFormatProperty, ((SimpleDateFormat)this.dateFormat).toPattern());
        this.dateFormat = new SimpleDateFormat(dateFormatString);
    }

    public String getCurrentTimeString() {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        return " " + this.dateFormat.format(cal.getTime()) + " ";
    }

    protected void setDateFormat(DateFormat df) {
        this.dateFormat = df;
    }

    protected DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void paint(Graphics g) {
        String data = this.getCurrentTimeString();
        if (Debug.debugging("datelayer")) {
            System.out.println("DateLayer.paint(): " + data);
        }
        this.labelText = data;
        super.paint(g);
    }

    public int getSleepHint() {
        return 1000;
    }
}

