/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.util.PropUtils;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;

public class AOILayer
extends OMGraphicHandlerLayer {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.layer.AOILayer");
    public static final String AOIProperty = "aoi";
    public static final String AOICoordsProperty = "coords";
    public static final String AOINameProperty = "name";

    public AOILayer() {
        this.setMouseModeIDsForEvents(new String[]{"Gestures"});
    }

    public String getToolTipTextFor(OMGraphic omg) {
        return (String)omg.getAttribute("Tooltip");
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        DrawingAttributes attributes = new DrawingAttributes();
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        Vector<String> aois = PropUtils.parseSpacedMarkers(props.getProperty(prefix + AOIProperty));
        OMGraphicList list = new OMGraphicList();
        for (String aoi : aois) {
            String aoiPrefix = PropUtils.getScopedPropertyPrefix(prefix + aoi);
            Vector<String> coordV = PropUtils.parseSpacedMarkers(props.getProperty(aoiPrefix + AOICoordsProperty));
            double[] coords = new double[coordV.size()];
            int coordCount = 0;
            Iterator<String> cit = coordV.iterator();
            while (cit.hasNext()) {
                try {
                    coords[coordCount++] = Double.parseDouble(cit.next());
                }
                catch (NumberFormatException nfe) {
                    logger.warning("can't parse coords for " + aoi + ": " + coordV);
                    break;
                }
            }
            if (coordCount < coordV.size()) continue;
            attributes.setProperties(aoiPrefix, props);
            String name = props.getProperty(aoiPrefix + AOINameProperty);
            OMPoly aoiGraphic = new OMPoly(coords, 0, 3);
            attributes.setTo(aoiGraphic);
            aoiGraphic.putAttribute("Tooltip", name);
            list.add(aoiGraphic);
        }
        this.setList(list);
    }
}

