/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image.wms;

import com.bbn.openmap.Layer;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.image.ImageFormatter;
import com.bbn.openmap.image.ImageServer;
import com.bbn.openmap.image.ImageServerConstants;
import com.bbn.openmap.image.MapRequestFormatException;
import com.bbn.openmap.image.wms.CapabilitiesSupport;
import com.bbn.openmap.image.wms.DefaultFeatureInfoResponse;
import com.bbn.openmap.image.wms.DefaultLayerAdapter;
import com.bbn.openmap.image.wms.FeatureInfoResponse;
import com.bbn.openmap.image.wms.FormatRequestParameter;
import com.bbn.openmap.image.wms.GetCapabilitiesRequestParameters;
import com.bbn.openmap.image.wms.GetFeatureInfoRequestParameters;
import com.bbn.openmap.image.wms.GetLegendGraphicRequestParameters;
import com.bbn.openmap.image.wms.GetMapRequestParameters;
import com.bbn.openmap.image.wms.IWmsLayer;
import com.bbn.openmap.image.wms.IWmsNestedLayer;
import com.bbn.openmap.image.wms.LayerFeatureInfoResponse;
import com.bbn.openmap.image.wms.Legend;
import com.bbn.openmap.image.wms.Version;
import com.bbn.openmap.image.wms.WMSException;
import com.bbn.openmap.image.wms.WidthAndHeightRequestParameters;
import com.bbn.openmap.image.wms.WmsLayerFactory;
import com.bbn.openmap.image.wms.WmsRequestParameters;
import com.bbn.openmap.layer.util.http.IHttpResponse;
import com.bbn.openmap.proj.AspectRatioProjection;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.CoordinateReferenceSystem;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class WmsRequestHandler
extends ImageServer
implements ImageServerConstants {
    private CapabilitiesSupport capabilities;
    private Map<String, IWmsLayer> wmsLayerByName = new HashMap<String, IWmsLayer>();
    private List<IWmsLayer> wmsLayers = new ArrayList<IWmsLayer>();
    private WmsLayerFactory wmsLayerFactory;
    private Map<String, ImageFormatter> imageFormatterByContentType = new HashMap<String, ImageFormatter>();
    private FeatureInfoResponse featureInfoResponse;
    public static final String WMSPrefix = "openmap.wms.";
    private static final String FeatureInfoResponseClassNameProperty = "featureInfoResponse.class";

    public WmsRequestHandler(String wmsScheme, String wmsHostName, int wmsPort, String wmsUrlPath, Properties props) throws IOException, WMSException {
        super(props);
        this.setProperties(props);
        boolean antialias = PropUtils.booleanFromProperties(props, "openmap.wms.antialiasing", false);
        this.setDoAntiAliasing(antialias);
        this.wmsLayerFactory = new WmsLayerFactory(props);
        this.createWmsLayers();
        for (ImageFormatter formatter : this.getFormatters().values()) {
            this.imageFormatterByContentType.put(formatter.getContentType(), formatter);
        }
        this.featureInfoResponse = (FeatureInfoResponse)PropUtils.objectFromProperties(props, "openmap.wms.featureInfoResponse.class");
        if (this.featureInfoResponse == null) {
            this.featureInfoResponse = new DefaultFeatureInfoResponse();
        }
        this.capabilities = new CapabilitiesSupport(props, wmsScheme, wmsHostName, wmsPort, wmsUrlPath);
        ArrayList<String> formatsList = new ArrayList<String>(this.imageFormatterByContentType.keySet());
        this.capabilities.setFormats(0, formatsList);
        this.capabilities.setFormats(1, this.getFeatureInfoResponse().getInfoFormats());
    }

    protected void createWmsLayers() {
        this.wmsLayerByName.clear();
        this.wmsLayers.clear();
        for (int i = 0; i < this.layers.length; ++i) {
            Layer layer = this.layers[i];
            this.createWmsLayers(this.wmsLayerFactory.createWmsLayer(layer));
        }
    }

    private void createWmsLayers(IWmsLayer layer) {
        IWmsNestedLayer n;
        this.wmsLayerByName.put(layer.getWmsName(), layer);
        this.wmsLayers.add(layer);
        if (layer instanceof IWmsNestedLayer && (n = (IWmsNestedLayer)layer).getNestedLayers() != null) {
            for (int i = 0; i < n.getNestedLayers().length; ++i) {
                this.createWmsLayers(n.getNestedLayers()[i]);
            }
        }
    }

    protected void setRequestParametersOnLayers(Properties requestProperties) {
        HashSet<String> handledNames = new HashSet<String>();
        for (IWmsLayer wmsLayer : this.wmsLayers) {
            IWmsNestedLayer nestedLayer;
            if (!handledNames.contains(wmsLayer.getWmsName())) {
                wmsLayer.setRequestParameters(requestProperties);
                handledNames.add(wmsLayer.getWmsName());
            }
            if (!(wmsLayer instanceof IWmsNestedLayer) || handledNames.contains((nestedLayer = (IWmsNestedLayer)wmsLayer).getTopLayer().getWmsName())) continue;
            nestedLayer.getTopLayer().setRequestParameters(requestProperties);
            handledNames.add(nestedLayer.getTopLayer().getWmsName());
        }
    }

    protected IWmsLayer getLayerByName(String wmsName) {
        return this.wmsLayerByName.get(wmsName);
    }

    protected Layer getTopLayerByName(String wmsName) {
        IWmsLayer layer = this.getLayerByName(wmsName);
        if (layer == null) {
            return null;
        }
        if (layer instanceof IWmsNestedLayer) {
            layer = ((IWmsNestedLayer)layer).getTopLayer();
        }
        if (layer instanceof DefaultLayerAdapter) {
            return ((DefaultLayerAdapter)layer).layer;
        }
        if (layer instanceof Layer) {
            return (Layer)((Object)layer);
        }
        throw new IllegalStateException("Top layer must be a OpenMap Layer, not " + layer.getClass());
    }

    public void handleRequest(Properties requestProperties, IHttpResponse httpResponse) throws IOException, MapRequestFormatException {
        block7: {
            try {
                String requestType = requestProperties.getProperty("REQUEST");
                this.checkRequest(requestProperties);
                if (requestType == null) {
                    throw new WMSException("Missing REQUEST type parameter");
                }
                this.setRequestParametersOnLayers(requestProperties);
                if (requestType.equalsIgnoreCase("GetMap")) {
                    Debug.message("ms", "OGCMRH: GetMap request...");
                    this.handleGetMapRequest(requestProperties, httpResponse);
                    break block7;
                }
                if (requestType.equals("GetCapabilities")) {
                    Debug.message("ms", "OGCMRH: GetCapabilities request...");
                    this.handleGetCapabilitiesRequest(requestProperties, httpResponse);
                    break block7;
                }
                if (requestType.equalsIgnoreCase("GetFeatureInfo")) {
                    Debug.message("ms", "OGCMRH: GetFeatureInfo request...");
                    this.handleGetFeatureInfoRequest(requestProperties, httpResponse);
                    break block7;
                }
                if (requestType.equalsIgnoreCase("GetLegendGraphic")) {
                    Debug.message("ms", "OGCMRH: GetFeatureInfo request...");
                    this.handleGetLegendGraphicRequest(requestProperties, httpResponse);
                    break block7;
                }
                throw new WMSException("Invalid REQUEST parameter: " + requestType, "OperationNotSupported");
            }
            catch (WMSException e) {
                Debug.output("WMSException(" + e.getCode() + "): " + e.getMessage());
                httpResponse.writeHttpResponse("application/vnd.ogc.se_xml", e.getXML());
            }
        }
    }

    public void handleGetMapRequest(Properties requestProperties, IHttpResponse httpResponse) throws IOException, MapRequestFormatException, WMSException {
        String contentType;
        byte[] image = this.handleGetMapRequest(requestProperties);
        if (Debug.debugging("imageserver")) {
            Debug.output("OGCMRH: have completed image, size " + image.length);
        }
        if ((contentType = this.getFormatter().getContentType()) == null) {
            contentType = "text/plain";
        }
        httpResponse.writeHttpResponse(contentType, image);
    }

    public byte[] handleGetMapRequest(Properties requestProperties) throws IOException, MapRequestFormatException, WMSException {
        GetMapRequestParameters parameters = new GetMapRequestParameters();
        this.checkVersion(requestProperties, parameters);
        this.checkExceptions(requestProperties, parameters);
        this.checkFormat(requestProperties, parameters);
        this.setFormatter(parameters.formatter);
        this.checkBackground(requestProperties, parameters);
        Paint bgPaint = parameters.background;
        this.checkProjectionType(requestProperties, parameters);
        this.checkWidthAndHeight(requestProperties, parameters);
        this.checkBoundingBox(requestProperties, parameters);
        Proj projection = this.createProjection(requestProperties, parameters);
        this.checkLayersAndStyles(requestProperties, parameters);
        Debug.message("ms", "handleGetMapRequest: createImage layers:" + parameters.topLayerNames.toString());
        return this.createImage((Projection)projection, parameters.width, parameters.height, parameters.topLayerNames, bgPaint);
    }

    public byte[] handleGetLegendGraphicRequest(Properties requestProperties) throws IOException, MapRequestFormatException, WMSException {
        GetLegendGraphicRequestParameters parameters = new GetLegendGraphicRequestParameters();
        this.checkVersion(requestProperties, parameters);
        this.checkExceptions(requestProperties, parameters);
        this.checkWidthAndHeight(requestProperties, parameters);
        this.checkFormat(requestProperties, parameters);
        this.setFormatter(parameters.getFormatter());
        this.checkLayerAndStyle(requestProperties, parameters);
        Debug.message("ms", "handleGetLegendGraphic: createImage layer:" + parameters.layerName);
        IWmsLayer layer = this.wmsLayerByName.get(parameters.layerName);
        ImageFormatter imageFormatter = this.formatter.makeClone();
        Graphics graphics = this.createGraphics(imageFormatter, parameters.getWidth(), parameters.getHeight());
        if (graphics == null) {
            return new byte[0];
        }
        Legend legend = layer.getLegend();
        if (legend != null) {
            legend.setSize(parameters.getWidth(), parameters.getHeight());
            legend.paint(graphics);
        }
        byte[] formattedImage = this.getFormattedImage(imageFormatter, parameters.getWidth(), parameters.getHeight());
        graphics.dispose();
        return formattedImage;
    }

    public void handleGetCapabilitiesRequest(Properties requestProperties, IHttpResponse httpResponse) throws IOException, MapRequestFormatException, WMSException {
        String response = this.handleGetCapabilitiesRequest(requestProperties);
        httpResponse.writeHttpResponse("text/xml", response.getBytes("UTF-8"));
    }

    public CapabilitiesSupport getCapabilities() {
        return this.capabilities;
    }

    public String handleGetCapabilitiesRequest(Properties requestProperties) throws IOException, MapRequestFormatException, WMSException {
        GetCapabilitiesRequestParameters parameters = new GetCapabilitiesRequestParameters();
        this.checkVersion(requestProperties, parameters);
        String format = requestProperties.getProperty("FORMAT");
        if (format != null && !format.equals("application/vnd.ogc.wms_xml")) {
            throw new WMSException("Invalid FORMAT parameter.", "InvalidFormat");
        }
        Layer[] layers = this.getLayers();
        for (int i = 0; i < layers.length; ++i) {
            if (layers[i].getPropertyPrefix() == null) continue;
            this.getCapabilities().addLayer(this.wmsLayerFactory.createWmsLayer(layers[i]));
        }
        try {
            return this.getCapabilities().generateXMLString(parameters.getVersion());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WMSException("Unable to compile a response due to server misconfiguration.", "InternalError");
        }
    }

    public void handleGetLegendGraphicRequest(Properties requestProperties, IHttpResponse httpResponse) throws IOException, MapRequestFormatException, WMSException {
        byte[] image = this.handleGetLegendGraphicRequest(requestProperties);
        String contentType = this.getFormatter().getContentType();
        httpResponse.writeHttpResponse(contentType, image);
    }

    public void handleGetFeatureInfoRequest(Properties requestProperties, IHttpResponse httpResponse) throws IOException, MapRequestFormatException, WMSException {
        GetFeatureInfoRequestParameters parameters = new GetFeatureInfoRequestParameters();
        this.checkVersion(requestProperties, parameters);
        this.checkExceptions(requestProperties, parameters);
        this.checkFormat(requestProperties, parameters);
        this.setFormatter(parameters.formatter);
        this.checkBackground(requestProperties, parameters);
        this.checkProjectionType(requestProperties, parameters);
        this.checkWidthAndHeight(requestProperties, parameters);
        this.checkBoundingBox(requestProperties, parameters);
        this.checkFeatureInfoPoint(requestProperties, parameters);
        this.checkLayersAndStyles(requestProperties, parameters);
        this.checkQueryLayers(requestProperties, parameters);
        this.checkInfoFormat(requestProperties, parameters);
        Proj projection = this.createProjection(requestProperties, parameters);
        FeatureInfoResponse featureInfoResponse = this.getFeatureInfoResponse();
        StringBuffer out = new StringBuffer();
        featureInfoResponse.setOutput(parameters.infoFormat, out);
        for (String queryLayerName : parameters.queryLayerNames) {
            IWmsLayer wmslayer = this.wmsLayerByName.get(queryLayerName);
            Layer layer = this.getTopLayerByName(queryLayerName);
            layer.setProjection(new ProjectionEvent(this, projection));
            LayerFeatureInfoResponse layerResponse = wmslayer.query(parameters.x, parameters.y);
            featureInfoResponse.output(layerResponse);
        }
        featureInfoResponse.flush();
        byte[] response = out.toString().getBytes("UTF-8");
        httpResponse.writeHttpResponse(parameters.infoFormat, response);
    }

    private FeatureInfoResponse getFeatureInfoResponse() {
        return this.featureInfoResponse;
    }

    protected byte[] getFormattedImage(ImageFormatter formatter, int scaledWidth, int scaledHeight) {
        Debug.message("imageserver", "ImageServer: using full scale image (unscaled).");
        byte[] formattedImage = formatter.getImageBytes();
        return formattedImage;
    }

    private void checkRequest(Properties requestProperties) throws WMSException {
        boolean getcaps;
        String service = requestProperties.getProperty("SERVICE");
        String requestType = requestProperties.getProperty("REQUEST");
        boolean bl = getcaps = requestType != null && requestType.equals("GetCapabilities");
        if (getcaps && (service == null || !service.equals("WMS"))) {
            throw new WMSException("Unsupported service name: " + service);
        }
    }

    private void checkProjectionType(Properties requestProperties, GetMapRequestParameters parameters) throws WMSException {
        String strSRS = requestProperties.getProperty("SRS");
        if (strSRS == null) {
            strSRS = requestProperties.getProperty("CRS");
        }
        if (strSRS == null) {
            throw new WMSException("Missing SRS parameter.");
        }
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.getForCode(strSRS);
        if (crs == null) {
            throw new WMSException("Invalid SRS/CRS parameter: " + strSRS, "InvalidSRS");
        }
        parameters.crs = crs;
    }

    private void checkWidthAndHeight(Properties requestProperties, WidthAndHeightRequestParameters parameters) throws WMSException {
        String strWidth = requestProperties.getProperty("WIDTH");
        if (strWidth == null) {
            throw new WMSException("Missing WIDTH parameter.", "MissingDimensionValue");
        }
        String strHeight = requestProperties.getProperty("HEIGHT");
        if (strHeight == null) {
            throw new WMSException("Missing HEIGHT parameter.", "MissingDimensionValue");
        }
        parameters.setWidth(0);
        try {
            parameters.setWidth(Integer.parseInt(strWidth));
            if (parameters.getWidth() <= 0) {
                throw new WMSException("Invalid value encountered while parsing WIDTH parameter.");
            }
        }
        catch (NumberFormatException e) {
            throw new WMSException("Invalid value encountered while parsing WIDTH parameter.");
        }
        parameters.setHeight(0);
        try {
            parameters.setHeight(Integer.parseInt(strHeight));
            if (parameters.getHeight() <= 0) {
                throw new WMSException("Invalid value encountered while parsing HEIGHT parameter.");
            }
        }
        catch (NumberFormatException e) {
            throw new WMSException("Invalid value encountered while parsing HEIGHT parameter.");
        }
    }

    private void checkBoundingBox(Properties requestProperties, GetMapRequestParameters parameters) throws WMSException {
        String strBBox = requestProperties.getProperty("BBOX");
        if (strBBox == null) {
            throw new WMSException("Missing BBOX parameter.", "MissingDimensionValue");
        }
        String[] arrayBBox = strBBox.split(",");
        if (arrayBBox.length != 4) {
            throw new WMSException("Invalid BBOX parameter. BBOX must contain exactly 4 values separated with comas.", "InvalidDimensionValue");
        }
        try {
            double minX = Double.parseDouble(arrayBBox[0]);
            double minY = Double.parseDouble(arrayBBox[1]);
            double maxX = Double.parseDouble(arrayBBox[2]);
            double maxY = Double.parseDouble(arrayBBox[3]);
            double medX = (maxX - minX) / 2.0 + minX;
            double medY = (maxY - minY) / 2.0 + minY;
            CoordinateReferenceSystem crs = parameters.crs;
            parameters.bboxLatLonLowerLeft = crs.inverse(minX, minY, parameters.getVersion().usesAxisOrder());
            parameters.bboxLatLonUpperRight = crs.inverse(maxX, maxY, parameters.getVersion().usesAxisOrder());
            parameters.bboxLatLonCenter = crs.inverse(medX, medY, parameters.getVersion().usesAxisOrder());
        }
        catch (NumberFormatException e) {
            throw new WMSException("Invalid BBOX parameter. BBOX parameter must be in the form of minx, miny, maxx, maxy confirming to the selected SRS/CRS.", "InvalidDimensionValue");
        }
    }

    private void checkLayersAndStyles(Properties requestProperties, GetMapRequestParameters parameters) throws WMSException {
        String strLayers = requestProperties.getProperty("LAYERS");
        if (strLayers == null) {
            throw new WMSException("LAYERS not specified.", "LayerNotDefined");
        }
        if (Debug.debugging("imageserver")) {
            Debug.output("OGCMRH.checkLayersAndStyles: requested layers >> " + strLayers);
        }
        String[] layers_in = strLayers.replace('\"', '\u0000').split(",", -1);
        String strStyles = requestProperties.getProperty("STYLES");
        Object[] styles_in = null;
        if (strStyles != null) {
            styles_in = strStyles.replace('\"', '\u0000').split(",", -1);
            if (strStyles.length() == 0) {
                styles_in = new String[layers_in.length];
                Arrays.fill(styles_in, "");
            }
            if (styles_in.length != layers_in.length) {
                throw new WMSException("Number of specified styles does not match the number of specified layers.");
            }
        }
        parameters.topLayerNames.clear();
        parameters.layerNames.clear();
        for (int i = layers_in.length - 1; i >= 0; --i) {
            String layerName = layers_in[i];
            IWmsLayer wmsLayer = this.wmsLayerByName.get(layerName);
            if (wmsLayer == null) {
                throw new WMSException("Unknown layer specified (" + layerName + ").", "LayerNotDefined");
            }
            if (wmsLayer instanceof IWmsNestedLayer) {
                IWmsNestedLayer nestedLayer = (IWmsNestedLayer)wmsLayer;
                String topLayerName = nestedLayer.getTopLayer().getWmsName();
                if (!parameters.topLayerNames.contains(topLayerName)) {
                    parameters.topLayerNames.add(topLayerName);
                }
                nestedLayer.setIsActive(true);
            } else if (!parameters.topLayerNames.contains(layerName)) {
                parameters.topLayerNames.add(layerName);
            }
            if (styles_in == null) {
                wmsLayer.setDefaultStyle();
            } else {
                Object styleName = styles_in[i];
                if (((String)styleName).length() == 0) {
                    wmsLayer.setDefaultStyle();
                } else if (wmsLayer.isStyleSupported((String)styleName)) {
                    wmsLayer.setStyle((String)styleName);
                } else {
                    throw new WMSException("Unknown style specified (" + (String)styleName + ").", "StyleNotDefined");
                }
            }
            parameters.layerNames.add(layerName);
        }
        if (parameters.layerNames.isEmpty()) {
            throw new WMSException("LAYERS not specified.", "LayerNotDefined");
        }
    }

    private void checkLayerAndStyle(Properties requestProperties, GetLegendGraphicRequestParameters parameters) throws WMSException {
        String layerName = requestProperties.getProperty("LAYER");
        if (layerName == null) {
            throw new WMSException("LAYER not specified.", "LayerNotDefined");
        }
        IWmsLayer wmsLayer = this.wmsLayerByName.get(layerName);
        if (wmsLayer == null) {
            throw new WMSException("Unknown layer specified (" + layerName + ").", "LayerNotDefined");
        }
        parameters.layerName = layerName;
        String styleName = requestProperties.getProperty("STYLE");
        if (styleName == null) {
            wmsLayer.setDefaultStyle();
        } else if (styleName.length() == 0) {
            wmsLayer.setDefaultStyle();
        } else if (wmsLayer.isStyleSupported(styleName)) {
            wmsLayer.setStyle(styleName);
        } else {
            throw new WMSException("Unknown style specified (" + styleName + ").", "StyleNotDefined");
        }
    }

    private void checkQueryLayers(Properties requestProperties, GetFeatureInfoRequestParameters parameters) throws WMSException {
        String strLayers = requestProperties.getProperty("QUERY_LAYERS");
        if (strLayers == null) {
            throw new WMSException("QUERY_LAYERS not specified.", "LayerNotDefined");
        }
        if (Debug.debugging("imageserver")) {
            Debug.output("OGCMRH.checkQueryLayers: requested layers >> " + strLayers);
        }
        String[] layers_in = strLayers.replace('\"', '\u0000').split(",", -1);
        parameters.queryLayerNames.clear();
        for (int i = 0; i < layers_in.length; ++i) {
            String layerName = layers_in[i];
            if (!parameters.layerNames.contains(layerName)) {
                throw new WMSException("Layers missing Query Layer " + layerName + ".", "LayerNotDefined");
            }
            IWmsLayer layer = this.wmsLayerByName.get(layerName);
            if (layer == null) {
                throw new WMSException("Could not find layer " + layerName);
            }
            if (!layer.isQueryable()) {
                throw new WMSException("Layer " + layerName + " is not queryable");
            }
            parameters.queryLayerNames.add(layerName);
        }
    }

    private Proj createProjection(Properties requestProperties, GetMapRequestParameters parameters) throws WMSException {
        Properties projProps = new Properties();
        projProps.put("CENTER", new LatLonPoint.Double(0.0, 0.0));
        projProps.setProperty("WIDTH", Integer.toString(parameters.width));
        projProps.setProperty("HEIGHT", Integer.toString(parameters.height));
        GeoProj projection = parameters.crs.createProjection(projProps);
        parameters.crs.prepareProjection(projection);
        projection.setScale(projection.getMinScale());
        LatLonPoint llp1 = parameters.bboxLatLonLowerLeft;
        LatLonPoint llp2 = parameters.bboxLatLonUpperRight;
        Debug.message("wms", "bbox toLatLon: 1: " + llp1 + ", 2: " + llp2 + ", center: " + parameters.bboxLatLonCenter);
        projection.setCenter(parameters.bboxLatLonCenter);
        int intnewwidth = parameters.width;
        int intnewheight = parameters.height;
        float newscale = projection.getScale(llp1, llp2, (Point2D)new Point(0, 0), (Point2D)new Point(intnewwidth, intnewheight));
        projection.setScale(newscale);
        Point2D xyp1 = projection.forward(llp1);
        Point2D xyp2 = projection.forward(llp2);
        int w = (int)(xyp2.getX() - xyp1.getX());
        int h = (int)(xyp1.getY() - xyp2.getY());
        if (Math.abs(w - parameters.width) > 2 || Math.abs(h - parameters.height) > 2) {
            Debug.message("wms", "use aspect ratio fix");
            projection.setWidth(w);
            projection.setHeight(h);
            projection.setCenter(parameters.bboxLatLonCenter);
            float underlyingScale = projection.getScale(llp1, llp2, (Point2D)new Point(0, 0), (Point2D)new Point(w, h));
            projection.setScale(underlyingScale);
            AspectRatioProjection p = new AspectRatioProjection(projection, parameters.width, parameters.height);
            projection = p;
        }
        return projection;
    }

    private void checkFormat(Properties requestProperties, FormatRequestParameter parameters) throws WMSException {
        String format = requestProperties.getProperty("FORMAT");
        if (format == null && parameters instanceof GetFeatureInfoRequestParameters) {
            parameters.setFormatter(this.getFormatters().values().iterator().next());
            format = parameters.getFormatter().getContentType();
        }
        if (format == null) {
            throw new WMSException("Missing FORMAT parameter.", "InvalidFormat");
        }
        parameters.setFormatter(this.imageFormatterByContentType.get(format));
        if (parameters.getFormatter() == null) {
            throw new WMSException("Invalid FORMAT parameter: " + format, "InvalidFormat");
        }
    }

    private void checkVersion(Properties requestProperties, WmsRequestParameters parameters) throws WMSException {
        String versionString = requestProperties.getProperty("VERSION");
        if (versionString == null) {
            parameters.setVersion(Version.getDefault());
            Debug.message("wms", "missing version string. default to " + parameters.getVersion());
        } else {
            if (parameters instanceof GetCapabilitiesRequestParameters) {
                parameters.setVersion(Version.getVersionBestMatch(versionString));
            } else {
                parameters.setVersion(Version.getVersion(versionString));
            }
            if (parameters.getVersion() == null) {
                throw new WMSException("Unsupported protocol version: " + versionString);
            }
        }
    }

    private void checkExceptions(Properties requestProperties, WmsRequestParameters parameters) throws WMSException {
        Version version = parameters.getVersion();
        if (version == null) {
            return;
        }
        String ex = requestProperties.getProperty("EXCEPTIONS");
        if (ex == null) {
            return;
        }
    }

    private void checkFeatureInfoPoint(Properties requestProperties, GetFeatureInfoRequestParameters parameters) throws WMSException {
        parameters.x = -1;
        parameters.y = -1;
        try {
            parameters.x = Integer.parseInt(requestProperties.getProperty("X"));
        }
        catch (NumberFormatException e) {
            throw new WMSException("Invalid X parameter: " + requestProperties.getProperty("X"), "InvalidPoint");
        }
        try {
            parameters.y = Integer.parseInt(requestProperties.getProperty("Y"));
        }
        catch (NumberFormatException e) {
            throw new WMSException("Invalid Y parameter: " + requestProperties.getProperty("Y"), "InvalidPoint");
        }
    }

    private void checkInfoFormat(Properties requestProperties, GetFeatureInfoRequestParameters parameters) throws WMSException {
        String format = requestProperties.getProperty("INFO_FORMAT");
        if (format == null) {
            format = this.getFeatureInfoResponse().getInfoFormats().contains("text/html") ? "text/html" : "text/plain";
        } else if (!this.getFeatureInfoResponse().getInfoFormats().contains(format)) {
            throw new WMSException("Invalid value for INFO_FORMAT: " + format, "InvalidFormat");
        }
        parameters.infoFormat = format;
    }

    private void checkBackground(Properties requestProperties, GetMapRequestParameters parameters) throws WMSException {
        String transparent = requestProperties.getProperty("TRANSPARENT");
        String bgcolor = requestProperties.getProperty("BGCOLOR");
        if (transparent != null) {
            if (transparent.equals("1") || transparent.equalsIgnoreCase("TRUE")) {
                parameters.setTransparent(true);
                bgcolor = null;
            } else if (transparent.equals("0") || transparent.equalsIgnoreCase("FALSE")) {
                parameters.setTransparent(false);
            } else {
                throw new WMSException("Invalid TRANSPARENT format '" + transparent + "'. Please specify a boolean value (0,1,FALSE,TRUE)");
            }
        }
        if (bgcolor != null) {
            if (Pattern.matches("0x[0-9a-fA-F]{6}", bgcolor)) {
                parameters.background = Color.decode(bgcolor);
                parameters.setTransparent(false);
            } else {
                throw new WMSException("Invalid BGCOLOR format. Please specify an hexadecimal number in the form 0xXXXXXX, where X is a hexadecimal digit (0..9,A-F)");
            }
        }
        this.setTransparent(parameters.getTransparent());
        this.setBackground(parameters.background);
    }
}

