/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.dock;

import com.bbn.openmap.gui.dock.BasicDockPanel;
import com.bbn.openmap.gui.dock.DockConstraint;
import com.bbn.openmap.gui.dock.TransparentButtonUI;
import com.bbn.openmap.util.Debug;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ButtonUI;

public class DockWrapper
extends JPanel {
    static final int UNDEF = -1;
    static final int EXTERNAL = 1;
    static final int INTERNAL = 2;
    static final int DOCK_NORTH = 3;
    static final int DOCK_SOUTH = 4;
    static final int DOCK_WEST = 5;
    static final int DOCK_EAST = 6;
    private boolean resizable = false;
    private int state = -1;
    private boolean transparent = false;
    private JTabbedPane tabPane = null;
    BasicDockPanel dockPanel;
    private List children = new ArrayList(1);
    private List dockedWrappers = new ArrayList(0);
    private MouseHandler mouseHandler = new MouseHandler();

    public DockWrapper(BasicDockPanel dp) {
        this.dockPanel = dp;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
    }

    DockWrapper(BasicDockPanel dp, int state) {
        this(dp);
        this.state = state;
    }

    public void addChild(JComponent child) {
        this.children.add(child);
        if (this.isTabbed()) {
            String tabName = this.dockPanel.getConstraint(child).getTabName();
            if (tabName == null) {
                tabName = child.getName();
            }
            this.tabPane.insertTab(tabName, null, child, null, 0);
        } else {
            this.add((Component)child, "Center");
        }
    }

    public void removeChild(JComponent child) {
        if (this.children.size() < 1) {
            Debug.error("DockWrapper: Unexpected children list");
        }
        if (this.isTabbed()) {
            this.tabPane.remove(child);
        } else {
            this.remove(child);
        }
        this.children.remove(child);
    }

    public List getChildren() {
        return this.children;
    }

    public JComponent getChild() {
        return this.children.isEmpty() ? null : (JComponent)this.children.get(0);
    }

    void setTabName(JComponent child, String name) {
        if (this.isTabbed()) {
            this.tabPane.setTitleAt(this.tabPane.indexOfComponent(child), name);
        }
    }

    public boolean isTabbed() {
        return this.tabPane != null;
    }

    public int getDockedWrapperIndexForTabbing() {
        int idx = 0;
        for (DockWrapper dw : this.getDockedWrappers()) {
            if (dw.canTab()) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    private void tab(DockWrapper w) {
        this.dockPanel.removeWrapper(w);
        if (this.children.size() == 1) {
            JComponent child = this.getChild();
            this.removeChild(child);
            this.tabPane = new JTabbedPane(3);
            this.add((Component)this.tabPane, "Center");
            this.setOpaque(true);
            this.addChild(child);
        }
        for (JComponent child : w.getChildren()) {
            this.dockPanel.setWrapper(child, this);
            this.addChild(child);
        }
    }

    public void doLayout() {
        this.updateTransparency();
        super.doLayout();
    }

    protected static boolean setTransparent(JComponent child, boolean t) {
        boolean ret = false;
        if (child instanceof JPanel) {
            child.setOpaque(!t);
            ret |= child.isOpaque() == t;
        }
        if (child instanceof JToolBar) {
            child.setOpaque(!t);
            ret |= child.isOpaque() == t;
        }
        if (child instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)child;
            if (t) {
                if (!(b.getUI() instanceof TransparentButtonUI)) {
                    b.setContentAreaFilled(false);
                    b.setUI((ButtonUI)TransparentButtonUI.createUI(b));
                    ret = true;
                }
            } else if (b.getUI() instanceof TransparentButtonUI) {
                b.setContentAreaFilled(true);
                b.setUI((ButtonUI)UIManager.getUI(b));
                ret = true;
            }
        }
        for (int i = 0; i < child.getComponentCount(); ++i) {
            Component o = child.getComponent(i);
            if (!(o instanceof JComponent)) continue;
            JComponent c = (JComponent)o;
            ret |= DockWrapper.setTransparent(c, t);
        }
        return ret;
    }

    protected void makeNotResizable() {
        this.setBorder(null);
        this.removeMouseListener(this.mouseHandler);
        this.removeMouseMotionListener(this.mouseHandler);
    }

    protected void makeResizable() {
        this.setBorder(this.makeResizeBorder());
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseHandler);
    }

    protected int inBorder(int x, int y) {
        Border b = this.getBorder();
        if (b == null) {
            return -1;
        }
        Insets i = b.getBorderInsets(this);
        if (x <= i.left) {
            return 5;
        }
        if (x >= this.getWidth() - i.right) {
            return 6;
        }
        if (y <= i.top) {
            return 3;
        }
        if (y >= this.getHeight() - i.bottom) {
            return 4;
        }
        return -1;
    }

    protected Border makeResizeBorder() {
        Color highlightOuter = UIManager.getColor("controlLtHighlight");
        Color highlightInner = UIManager.getColor("controlHighlight");
        Color shadowOuter = UIManager.getColor("controlDkShadow");
        Color shadowInner = UIManager.getColor("controlShadow");
        if (this.transparent) {
            highlightOuter = new Color(0, 0, 0, 50);
            highlightInner = new Color(0, 0, 0, 75);
            shadowOuter = new Color(0, 0, 0, 175);
            shadowInner = new Color(0, 0, 0, 150);
        }
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0, highlightOuter, highlightInner, shadowOuter, shadowInner), BorderFactory.createBevelBorder(1, highlightOuter, highlightInner, shadowOuter, shadowInner));
        return border;
    }

    public boolean updateTransparency() {
        boolean ret = false;
        if (this.children.size() == 1) {
            boolean t;
            this.transparent = t = this.dockPanel.getConstraint(this.getChild()).canTransparent();
            ret |= DockWrapper.setTransparent(this.getChild(), t);
        } else {
            this.transparent = false;
            for (JComponent c : this.children) {
                ret |= DockWrapper.setTransparent(c, this.transparent);
            }
        }
        return ret;
    }

    public void updateResizable() {
        List constraints = this.dockPanel.getConstraints(this.getChildren());
        boolean canResize = DockConstraint.canResize(constraints);
        if (this.resizable && !canResize) {
            this.makeNotResizable();
        }
        if (!this.resizable && canResize) {
            this.makeResizable();
        }
    }

    public boolean canOcclude() {
        List constraints = this.dockPanel.getConstraints(this.getChildren());
        return DockConstraint.canOcclude(constraints);
    }

    public boolean canTab() {
        List constraints = this.dockPanel.getConstraints(this.getChildren());
        return DockConstraint.canTab(constraints);
    }

    public boolean canClose() {
        List constraints = this.dockPanel.getConstraints(this.getChildren());
        return DockConstraint.canClose(constraints);
    }

    public boolean canInternalFrame() {
        List constraints = this.dockPanel.getConstraints(this.getChildren());
        return DockConstraint.canInternalFrame(constraints);
    }

    public boolean canExternalFrame() {
        List constraints = this.dockPanel.getConstraints(this.getChildren());
        return DockConstraint.canExternalFrame(constraints);
    }

    public boolean canDockNorth() {
        List constraints = this.dockPanel.getConstraints(this.getChildren());
        return DockConstraint.canDockNorth(constraints);
    }

    public boolean canDockSouth() {
        List constraints = this.dockPanel.getConstraints(this.getChildren());
        return DockConstraint.canDockSouth(constraints);
    }

    public boolean canDockEast() {
        List constraints = this.dockPanel.getConstraints(this.getChildren());
        return DockConstraint.canDockEast(constraints);
    }

    public boolean canDockWest() {
        List constraints = this.dockPanel.getConstraints(this.getChildren());
        return DockConstraint.canDockWest(constraints);
    }

    public void makeExternalFrame() {
        this.freeWrapper();
        this.state = 1;
    }

    protected void removeExternalFrame() {
        this.state = -1;
    }

    public void makeInternalFrame() {
        this.freeWrapper();
        this.state = 2;
    }

    protected void removeInternalFrame() {
        this.state = -1;
    }

    public void makeDockNorth() {
        this.makeDock(3);
    }

    protected void removeDockNorth() {
        this.removeDock();
    }

    public void makeDockSouth() {
        this.makeDock(4);
    }

    protected void removeDockSouth() {
        this.removeDock();
    }

    public void makeDockEast() {
        this.makeDock(6);
    }

    protected void removeDockEast() {
        this.removeDock();
    }

    public void makeDockWest() {
        this.makeDock(5);
    }

    protected void removeDockWest() {
        this.removeDock();
    }

    protected void makeDock(int state) {
        this.freeWrapper();
        this.state = state;
        this.dockPanel.addDockWrapper(this);
        this.orientToolbars();
    }

    protected void orientToolbars() {
        for (JComponent child : this.getChildren()) {
            if (!(child instanceof JToolBar)) continue;
            JToolBar t = (JToolBar)child;
            switch (this.state) {
                case 3: 
                case 4: {
                    t.setOrientation(0);
                    break;
                }
                case 5: 
                case 6: {
                    t.setOrientation(1);
                }
            }
        }
    }

    protected void removeDock() {
        this.dockPanel.removeDockWrapper(this);
        this.state = -1;
    }

    protected void setState(int state) {
        switch (state) {
            case 2: {
                this.makeInternalFrame();
                break;
            }
            case 1: {
                this.makeExternalFrame();
                break;
            }
            case 3: {
                this.makeDockNorth();
                break;
            }
            case 4: {
                this.makeDockSouth();
                break;
            }
            case 5: {
                this.makeDockWest();
                break;
            }
            case 6: {
                this.makeDockEast();
            }
        }
    }

    public void freeWrapper() {
        switch (this.state) {
            case 2: {
                this.removeInternalFrame();
                break;
            }
            case 1: {
                this.removeExternalFrame();
                break;
            }
            case 3: {
                this.removeDockNorth();
                break;
            }
            case 4: {
                this.removeDockSouth();
                break;
            }
            case 5: {
                this.removeDockWest();
                break;
            }
            case 6: {
                this.removeDockEast();
            }
        }
    }

    public boolean freeWrapper(DockWrapper w) {
        if (this.dockedWrappers.remove(w)) {
            w.freeWrapper();
            return true;
        }
        for (DockWrapper dw : this.dockedWrappers) {
            if (!dw.freeWrapper(w)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDockedWrappers() {
        return !this.getDockedWrappers().isEmpty();
    }

    public List getDockedWrappers() {
        return this.dockedWrappers;
    }

    public DockWrapper getDockedWrapper(int idx) {
        return (DockWrapper)this.dockedWrappers.get(idx);
    }

    public void dock(DockWrapper w) {
        this.dock(w, -1);
    }

    public void dock(DockWrapper w, int i) {
        w.setState(this.state);
        int idx = this.getDockedWrapperIndexForTabbing();
        if (idx != -1 && w.canTab()) {
            this.getDockedWrapper(idx).tab(w);
        } else if (i == -1) {
            this.dockedWrappers.add(w);
        } else {
            this.dockedWrappers.set(i, w);
        }
    }

    public boolean isDockedOnRecurse(DockWrapper w) {
        if (this.equals(w)) {
            return true;
        }
        for (DockWrapper dw : this.dockedWrappers) {
            if (!dw.isDockedOnRecurse(w)) continue;
            return true;
        }
        return false;
    }

    public void setPreferredHeight(int i) {
        Dimension d = this.getPreferredSize();
        d.height = i;
        this.setPreferredSize(d);
    }

    public void setPreferredWidth(int i) {
        Dimension d = this.getPreferredSize();
        d.width = i;
        this.setPreferredSize(d);
    }

    protected class MouseHandler
    extends MouseInputAdapter {
        int resizeLoc = -1;
        int pressedVal = 0;

        protected MouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            this.resizeLoc = DockWrapper.this.inBorder(e.getX(), e.getY());
            switch (this.resizeLoc) {
                case 3: 
                case 4: {
                    this.pressedVal = e.getY();
                    break;
                }
                case 5: 
                case 6: {
                    this.pressedVal = e.getX();
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            Dimension d = DockWrapper.this.getSize();
            switch (this.resizeLoc) {
                case 3: {
                    d.height += this.pressedVal - e.getY();
                    DockWrapper.this.setPreferredSize(d);
                    DockWrapper.this.revalidate();
                    break;
                }
                case 4: {
                    d.height -= this.pressedVal - e.getY();
                    DockWrapper.this.setPreferredSize(d);
                    DockWrapper.this.revalidate();
                    break;
                }
                case 6: {
                    d.width -= this.pressedVal - e.getX();
                    DockWrapper.this.setPreferredSize(d);
                    DockWrapper.this.revalidate();
                    break;
                }
                case 5: {
                    d.width += this.pressedVal - e.getX();
                    DockWrapper.this.setPreferredSize(d);
                    DockWrapper.this.revalidate();
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
            int loc = DockWrapper.this.inBorder(e.getX(), e.getY());
            switch (loc) {
                case 3: {
                    DockWrapper.this.setCursor(Cursor.getPredefinedCursor(8));
                    break;
                }
                case 4: {
                    DockWrapper.this.setCursor(Cursor.getPredefinedCursor(9));
                    break;
                }
                case 6: {
                    DockWrapper.this.setCursor(Cursor.getPredefinedCursor(11));
                    break;
                }
                case 5: {
                    DockWrapper.this.setCursor(Cursor.getPredefinedCursor(10));
                    break;
                }
                default: {
                    DockWrapper.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }

        public void mouseExited(MouseEvent e) {
            DockWrapper.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

