/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.event.CenterSupport;
import com.bbn.openmap.gui.CoordPanel;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.proj.coords.UTMPoint;
import com.bbn.openmap.util.Debug;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class UTMCoordPanel
extends CoordPanel
implements Serializable {
    protected transient JTextField zoneLetter;
    protected transient JTextField zoneNumber;
    protected transient JTextField easting;
    protected transient JTextField northing;

    public UTMCoordPanel() {
    }

    public UTMCoordPanel(CenterSupport support) {
        super(support);
    }

    protected void makeWidgets() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Insets leftInsets = new Insets(0, 10, 0, 10);
        Insets centerInsets = new Insets(0, 0, 0, 0);
        Insets rightInsets = new Insets(0, 0, 0, 10);
        this.setLayout(gridbag);
        String locText = this.i18n.get(UTMCoordPanel.class, "border", "Zone Number|Hemisphere|Easting|Northing");
        this.setBorder(new TitledBorder(new EtchedBorder(), locText));
        locText = this.i18n.get(UTMCoordPanel.class, "utmLabel", "UTM: ");
        JLabel utmLabel = new JLabel(locText);
        c.gridx = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.insets = leftInsets;
        c.anchor = 13;
        gridbag.setConstraints(utmLabel, c);
        this.add(utmLabel);
        c.gridx = -1;
        this.zoneNumber = new JTextField(3);
        this.zoneNumber.setToolTipText(this.i18n.get(UTMCoordPanel.class, "zone", 3, "Zone Number: 1-60"));
        c.insets = centerInsets;
        gridbag.setConstraints(this.zoneNumber, c);
        this.add(this.zoneNumber);
        this.zoneLetter = new JTextField(2);
        this.zoneLetter.setToolTipText(this.i18n.get(UTMCoordPanel.class, "hemi", 3, "Hemisphere: N or S"));
        gridbag.setConstraints(this.zoneLetter, c);
        this.add(this.zoneLetter);
        this.easting = new JTextField(8);
        c.fill = 2;
        c.weightx = 0.5;
        gridbag.setConstraints(this.easting, c);
        this.add(this.easting);
        this.northing = new JTextField(8);
        c.insets = rightInsets;
        gridbag.setConstraints(this.northing, c);
        this.add(this.northing);
    }

    public LatLonPoint getLatLon() {
        try {
            int iZoneNumber = Float.valueOf(this.zoneNumber.getText()).intValue();
            char cZoneLetter = this.zoneLetter.getText().charAt(0);
            float minEasting = this.easting.getText().length() == 0 ? 0.0f : Float.valueOf(this.easting.getText()).floatValue();
            this.easting.setText(Float.toString(Math.abs(minEasting)));
            float minNorthing = this.northing.getText().length() == 0 ? 0.0f : Float.valueOf(this.northing.getText()).floatValue();
            this.northing.setText(Float.toString(Math.abs(minNorthing)));
            UTMPoint utm = new UTMPoint(minNorthing, minEasting, iZoneNumber, cZoneLetter);
            return utm.toLatLonPoint();
        }
        catch (NumberFormatException except) {
            Debug.output(except.toString());
            this.clearTextBoxes();
            return null;
        }
    }

    public void setLatLon(LatLonPoint llpoint) {
        if (llpoint == null) {
            this.clearTextBoxes();
            return;
        }
        UTMPoint utm = new UTMPoint(llpoint);
        this.northing.setText(Double.toString(utm.northing));
        this.easting.setText(Double.toString(utm.easting));
        this.zoneNumber.setText(Integer.toString(utm.zone_number));
        this.zoneLetter.setText(utm.zone_letter + "");
    }

    protected void clearTextBoxes() {
        this.northing.setText("");
        this.easting.setText("");
        this.zoneLetter.setText("");
        this.zoneNumber.setText("");
    }
}

