/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.event.CenterSupport;
import com.bbn.openmap.gui.CoordPanel;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.proj.coords.MGRSPoint;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class MGRSCoordPanel
extends CoordPanel
implements Serializable {
    protected transient JTextField mgrs;

    public MGRSCoordPanel() {
    }

    public MGRSCoordPanel(CenterSupport support) {
        super(support);
    }

    protected void makeWidgets() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Insets leftInsets = new Insets(0, 10, 0, 10);
        Insets rightInsets = new Insets(0, 0, 0, 10);
        this.setLayout(gridbag);
        String locText = this.i18n.get(MGRSCoordPanel.class, "border", "MGRS Coordinate");
        this.setBorder(new TitledBorder(new EtchedBorder(), locText));
        locText = this.i18n.get(MGRSCoordPanel.class, "mgrsLabel", "MGRS: ");
        JLabel mgrsLabel = new JLabel(locText);
        c.gridx = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.insets = leftInsets;
        gridbag.setConstraints(mgrsLabel, c);
        this.add(mgrsLabel);
        this.mgrs = new JTextField(20);
        c.gridx = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = rightInsets;
        gridbag.setConstraints(this.mgrs, c);
        this.add(this.mgrs);
    }

    public LatLonPoint getLatLon() {
        try {
            return new MGRSPoint(this.mgrs.getText()).toLatLonPoint();
        }
        catch (NumberFormatException except) {
            this.clearTextBoxes();
            return null;
        }
    }

    public void setLatLon(LatLonPoint llpoint) {
        if (llpoint == null) {
            this.clearTextBoxes();
            return;
        }
        MGRSPoint mgrsp = new MGRSPoint(llpoint);
        this.mgrs.setText(mgrsp.getMGRS());
    }

    protected void clearTextBoxes() {
        this.mgrs.setText("");
    }
}

