/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.BufferedMapBean;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.event.CoordMouseMode;
import com.bbn.openmap.event.MapMouseEvent;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.event.OMMouseMode;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.gui.OMToolComponent;
import com.bbn.openmap.gui.Tool;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.PropUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class DistQuickTool
extends OMToolComponent
implements Tool,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    protected Logger logger = Logger.getLogger("com.bbn.openmap.gui.DistQuickTool");
    protected MouseMode mouseMode = this.getMouseMode();
    protected JButton launchButton = null;
    protected boolean ommmActive = false;

    public DistQuickTool() {
        try {
            this.setOpaque(false);
            URL url = PropUtils.getResourceOrFileOrURL("com/bbn/openmap/tools/drawing/distance.png");
            ImageIcon ii = new ImageIcon(url);
            this.launchButton = new JButton(ii);
            this.launchButton.setPreferredSize(new Dimension(25, 25));
            this.launchButton.setToolTipText("Measure Distance");
            this.launchButton.setFocusable(false);
            this.launchButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    DistQuickTool.this.go();
                }
            });
            this.add(this.launchButton);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    protected void go() {
        MapMouseMode proxyParent;
        MouseDelegator mouseDelegator = ((MapHandler)this.getBeanContext()).get(MouseDelegator.class);
        if (mouseDelegator != null && (proxyParent = mouseDelegator.getActiveMouseMode()) instanceof OMMouseMode) {
            this.ommmActive = true;
            this.mouseMode.go(proxyParent);
            this.launchButton.setEnabled(false);
        }
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        this.mouseMode.setProperties(prefix, props);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        this.mouseMode.getProperties(props);
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        this.mouseMode.getPropertyInfo(props);
        return props;
    }

    public void findAndInit(Object someObj) {
        super.findAndInit(someObj);
        if (someObj instanceof MouseDelegator) {
            ((MouseDelegator)someObj).addPropertyChangeListener(this);
            this.ommmActive = ((MouseDelegator)someObj).getActiveMouseMode() instanceof OMMouseMode;
        }
    }

    public void findAndUndo(Object someObj) {
        super.findAndUndo(someObj);
        if (someObj instanceof MouseDelegator) {
            ((MouseDelegator)someObj).removePropertyChangeListener(this);
        }
    }

    public MouseMode getMouseMode() {
        if (this.mouseMode == null) {
            this.mouseMode = new MouseMode();
        }
        return this.mouseMode;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Object obj = evt.getSource();
        if (obj instanceof MouseDelegator) {
            String propName = evt.getPropertyName();
            if (propName.equals("NewActiveMouseMode")) {
                Object newVal = evt.getNewValue();
                this.ommmActive = newVal instanceof OMMouseMode;
                this.launchButton.setEnabled(this.ommmActive);
                if (this.mouseMode != null) {
                    this.mouseMode.reset();
                }
            } else if (propName.equals("MouseModeProxy")) {
                if (!this.equals(evt.getNewValue())) {
                    this.mouseMode.reset();
                }
                this.ommmActive = ((MouseDelegator)obj).getActiveMouseMode() instanceof OMMouseMode;
                this.launchButton.setEnabled(evt.getNewValue() == null && this.ommmActive);
            }
        }
    }

    public class MouseMode
    extends CoordMouseMode
    implements ProjectionListener {
        private static final long serialVersionUID = 1L;
        public static final String UnitProperty = "units";
        public static final String ShowCircleProperty = "showCircle";
        public static final String ShowAngleProperty = "showAngle";
        public static final transient String modeID = "Distance";
        public transient DecimalFormat df;
        private Length unit;
        boolean showAngle;
        public Point2D rPoint1;
        public Point2D rPoint2;
        public boolean mousePressed;
        public Vector<Point2D> segments;
        public double distance;
        public double totalDistance;
        private boolean displayCircle;
        public static final String AllUnitsPropertyValue = "all";
        protected BufferedMapBean theMap;
        protected String coordString;
        protected OMGraphicList distanceList;
        protected MapMouseMode proxyParent;

        public MouseMode() {
            super(modeID, true);
            this.df = new DecimalFormat("0");
            this.unit = Length.MILE;
            this.showAngle = true;
            this.mousePressed = false;
            this.segments = new Vector();
            this.distance = 0.0;
            this.totalDistance = 0.0;
            this.displayCircle = true;
            this.theMap = null;
            this.coordString = null;
            this.proxyParent = null;
        }

        public void setProperties(String prefix, Properties props) {
            super.setProperties(prefix, props);
            prefix = PropUtils.getScopedPropertyPrefix(prefix);
            String name = props.getProperty(prefix + UnitProperty);
            if (name != null) {
                Length length = Length.get(name);
                if (length != null) {
                    this.setUnit(length);
                } else if (name.equals(AllUnitsPropertyValue)) {
                    this.setUnit(null);
                }
            }
            this.setDisplayCircle(PropUtils.booleanFromProperties(props, prefix + ShowCircleProperty, this.isDisplayCircle()));
            this.setShowAngle(PropUtils.booleanFromProperties(props, prefix + ShowAngleProperty, this.isShowAngle()));
        }

        public Properties getProperties(Properties props) {
            props = super.getProperties(props);
            String prefix = PropUtils.getScopedPropertyPrefix(this);
            String unitValue = this.unit != null ? this.unit.toString() : AllUnitsPropertyValue;
            props.put(prefix + UnitProperty, unitValue);
            props.put(prefix + ShowCircleProperty, new Boolean(this.isDisplayCircle()).toString());
            props.put(prefix + ShowAngleProperty, new Boolean(this.isShowAngle()).toString());
            return props;
        }

        public Properties getPropertyInfo(Properties props) {
            props = super.getPropertyInfo(props);
            PropUtils.setI18NPropertyInfo(this.i18n, props, DistQuickTool.class, UnitProperty, "Units", "Units to use for measurements, from Length.name possibilities.", null);
            PropUtils.setI18NPropertyInfo(this.i18n, props, DistQuickTool.class, ShowCircleProperty, "Show Distance Circle", "Flag to set whether the range circle is drawn at the end of the line (true/false).", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
            PropUtils.setI18NPropertyInfo(this.i18n, props, DistQuickTool.class, ShowAngleProperty, "Show Angle", "Flag to note the azimuth angle of the line in the information line (true/false).", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
            return props;
        }

        protected BufferedMapBean getBufferedMapBean(MouseEvent evt) {
            if (evt instanceof MapMouseEvent) {
                MapBean mb = ((MapMouseEvent)evt).getMap();
                if (mb instanceof BufferedMapBean) {
                    return (BufferedMapBean)mb;
                }
            } else {
                Object src = evt.getSource();
                if (src instanceof BufferedMapBean) {
                    return (BufferedMapBean)src;
                }
            }
            return null;
        }

        public void mouseDragged(MouseEvent arg0) {
            if (this.theMap == null) {
                return;
            }
            if (this.rPoint1 == null) {
                this.rPoint1 = this.theMap.getCoordinates(arg0);
            } else {
                this.rPoint2 = this.theMap.getCoordinates(arg0);
                double lat1 = this.rPoint1.getY();
                double long1 = this.rPoint1.getX();
                double lat2 = this.rPoint2.getY();
                double long2 = this.rPoint2.getX();
                this.distance = GreatCircle.sphericalDistance(ProjMath.degToRad(lat1), ProjMath.degToRad(long1), ProjMath.degToRad(lat2), ProjMath.degToRad(long2));
                double azimuth = this.getSphericalAzimuth(lat1, long1, lat2, long2);
                this.coordString = this.createDistanceInformationLine(this.rPoint2, this.distance, azimuth);
                this.paintRubberband(this.rPoint1, this.rPoint2, this.coordString);
                this.theMap.repaint();
            }
        }

        public void mousePressed(MouseEvent e) {
            e.getComponent().requestFocus();
            this.mousePressed = true;
            BufferedMapBean mb = this.getBufferedMapBean(e);
            if (mb == null) {
                return;
            }
            this.theMap = mb;
            this.theMap.addPaintListener(this);
            if (mb != null) {
                this.rPoint1 = this.theMap.getCoordinates(e);
                this.rPoint2 = null;
                this.totalDistance = 0.0;
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent arg0) {
            this.reset();
        }

        public void go(MapMouseMode proxyParent) {
            proxyParent.actAsProxyFor(this);
            this.proxyParent = proxyParent;
        }

        protected void reset() {
            if (this.theMap != null) {
                this.distanceList = null;
                this.cleanUp();
                this.theMap.removePaintListener(this);
                this.theMap = null;
            }
            if (this.proxyParent != null && this.proxyParent.isProxyFor(DistQuickTool.this.mouseMode)) {
                this.proxyParent.releaseProxy();
                this.proxyParent = null;
            }
            DistQuickTool.this.launchButton.setEnabled(DistQuickTool.this.ommmActive);
        }

        public void listenerPaint(Graphics g) {
            if (this.distanceList != null) {
                this.distanceList.render(g);
            }
        }

        public void projectionChanged(ProjectionEvent e) {
            Projection p = e.getProjection();
            if (p != null && this.distanceList != null) {
                this.distanceList.generate(p);
            }
        }

        public void paintRubberband(Point2D pt1, Point2D pt2, String coordString) {
            if (this.distanceList == null) {
                this.distanceList = new OMGraphicList(){

                    public void render(Graphics g) {
                        Graphics g2 = g.create();
                        g2.setXORMode(Color.lightGray);
                        for (OMGraphic omg : this) {
                            if (omg instanceof OMText) {
                                omg.render(g);
                                continue;
                            }
                            omg.render(g2);
                        }
                        g2.dispose();
                    }
                };
            }
            this.distanceList.clear();
            this.paintLine(pt1, pt2);
            this.paintCircle(pt1, pt2);
            this.paintText(pt1, pt2, coordString);
        }

        public void paintLine(Point2D pt1, Point2D pt2) {
            if (pt1 != null && pt2 != null) {
                OMLine cLine = new OMLine(pt1.getY(), pt1.getX(), pt2.getY(), pt2.getX(), 3);
                Projection proj = this.theMap.getProjection();
                cLine.generate(proj);
                this.distanceList.add(cLine);
            }
        }

        public void paintText(Point2D base, Point2D pt1, String coordString) {
            if (coordString != null && (base = this.theMap.getProjection().forward(base)).distance(pt1 = this.theMap.getProjection().forward(pt1)) > 3.0) {
                OMText text = new OMText((int)pt1.getX() + 5, (int)pt1.getY() - 5, coordString, 0);
                Font font = text.getFont();
                text.setFont(font.deriveFont(1, font.getSize() + 4));
                text.setLinePaint(Color.BLACK);
                text.setTextMatteColor(Color.WHITE);
                text.setTextMatteStroke(new BasicStroke(5.0f));
                text.setMattingPaint(OMColor.clear);
                text.generate(this.theMap.getProjection());
                this.distanceList.add(text);
            }
        }

        public void paintCircle(Point2D pt1, Point2D pt2) {
            if (this.displayCircle && pt1 != null && pt2 != null) {
                double radphi1 = ProjMath.degToRad(pt1.getY());
                double radlambda0 = ProjMath.degToRad(pt1.getX());
                double radphi = ProjMath.degToRad(pt2.getY());
                double radlambda = ProjMath.degToRad(pt2.getX());
                double dRad = GreatCircle.sphericalDistance(radphi1, radlambda0, radphi, radlambda);
                double rad = ProjMath.radToDeg(dRad);
                OMCircle circle = new OMCircle(pt1.getY(), pt1.getX(), rad);
                Projection proj = this.theMap.getProjection();
                circle.generate(proj);
                this.distanceList.add(circle);
            }
        }

        public void cleanUp() {
            this.segments = new Vector();
            this.totalDistance = 0.0;
            this.distance = 0.0;
            this.coordString = null;
        }

        public double getSphericalAzimuth(double phi1, double lambda0, double phi, double lambda) {
            double radphi1 = ProjMath.degToRad(phi1);
            double radlambda0 = ProjMath.degToRad(lambda0);
            double radphi = ProjMath.degToRad(phi);
            double radlambda = ProjMath.degToRad(lambda);
            double az = GreatCircle.sphericalAzimuth(radphi1, radlambda0, radphi, radlambda);
            return ProjMath.radToDeg(az);
        }

        protected String createDistanceInformationLine(Point2D llp, double distance, double azimuth) {
            String unitInfo = null;
            unitInfo = this.unit == null ? this.df.format(Length.NM.fromRadians((float)distance)) + Length.NM.getAbbr() + ",  " + this.df.format(Length.KM.fromRadians((float)distance)) + Length.KM.getAbbr() + ",  " + this.df.format(Length.MILE.fromRadians((float)distance)) + Length.MILE.getAbbr() + "  " : this.df.format(this.unit.fromRadians(distance)) + " " + this.unit.getAbbr();
            return unitInfo;
        }

        public void setUnit(Length units) {
            this.unit = units;
        }

        public boolean isShowAngle() {
            return this.showAngle;
        }

        public void setShowAngle(boolean showAngle) {
            this.showAngle = showAngle;
        }

        public boolean isDisplayCircle() {
            return this.displayCircle;
        }

        public void setDisplayCircle(boolean displayCircle) {
            this.displayCircle = displayCircle;
        }

        public Length getUnit() {
            return this.unit;
        }
    }
}

