/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.geo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public interface MatchCollector {
    public void collect(Object var1, Object var2);

    public Iterator iterator();

    public static class CollectionMatchCollector
    implements MatchCollector {
        protected final Collection c;

        public CollectionMatchCollector(Collection c) {
            this.c = c;
        }

        public void collect(Object a, Object b) {
            this.c.add(b);
        }

        public Iterator iterator() {
            return this.c.iterator();
        }
    }

    public static class SetMatchCollector
    implements MatchCollector {
        protected final HashSet result = new HashSet();

        public void collect(Object a, Object b) {
            this.result.add(b);
        }

        public Iterator iterator() {
            return this.result.iterator();
        }
    }

    public static class Pair {
        private Object a;
        private Object b;

        public Pair(Object a, Object b) {
            this.a = a;
            this.b = b;
        }

        public Object getA() {
            return this.a;
        }

        public Object getB() {
            return this.b;
        }
    }

    public static class PairArrayMatchCollector
    implements MatchCollector {
        protected final ArrayList result = new ArrayList();

        public void collect(Object a, Object b) {
            this.result.add(new Pair(a, b));
        }

        public Iterator iterator() {
            return this.result.iterator();
        }
    }
}

