/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.geo;

import com.bbn.openmap.geo.BoundingCircle;
import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.GeoArray;
import com.bbn.openmap.geo.GeoRegion;
import com.bbn.openmap.geo.Intersection;
import junit.framework.TestCase;

public class IntersectionTest
extends TestCase {
    private static double[] _Polygon = new double[]{73.0, 46.0, 73.0, 121.0, 73.0, -169.0, 72.0, -141.0, 69.2, -141.0, 60.9, -141.0, 59.5, -139.6, 57.9, -141.6, 57.75, -152.33, 56.95, -158.62, 55.2667, -162.775, 53.905, -166.55, 51.9167, -176.567, 50.515, 175.945, 46.4317, 162.31, 39.625, 150.482, 37.2, 150.5, 35.2, 146.0, 32.0, 146.0, 25.0, 144.343, 21.0, 145.2, 17.42, 146.5, 16.5367, 147.925, 14.875, 148.982, 12.215, 148.962, 7.0, 158.2, 8.7, 167.7, 7.1, 171.3, 11.7083, -180.0, 21.1567, -164.0, 22.8, -162.617, 25.1617, -154.563, 30.0, -146.15, 34.6, -135.7, 37.8483, -127.0, 37.8333, -125.835, 37.0, -125.0, 36.1817, -124.76, 34.2, -123.1, 33.5, -122.6, 32.7, -122.0, 31.6, -121.4, 25.0, -120.0, 14.535, -132.312, -5.0, -142.515, -14.9483, -147.683, -17.5483, -149.602, -33.0917, -175.0, -37.0, 178.967, -39.8167, 178.933, -45.2333, 172.233, -46.4667, 168.483, -38.3117, 75.0, -35.0, 26.0, -35.2167, 10.0, -18.0, 10.0, -9.66667, 11.4, -4.79833, 6.58333, 0.391667, -7.745, 4.57167, -12.165, 6.96, -14.72, 12.2833, -17.3667, 13.0, -18.0, 20.9167, -18.0, 25.0, -19.8117, 35.9667, -11.45, 36.7617, -13.6733, 38.0, -15.0, 42.0, -15.0, 43.0, -13.0, 45.0, -13.0, 45.0, -9.0, 46.0, -8.75, 48.0, -8.75, 48.5983, -9.0, 49.0667, -11.745, 49.0, -15.0, 57.0, -15.0, 57.0, -10.0, 61.0, -10.0, 61.0, 0.001667, 63.0, 3.71667, 68.0967, 10.9583, 69.7033, 18.9967, 70.3667, 32.0, 73.0, 46.0};
    private static double[] _BadPolygon = new double[]{73.0, 46.0, 73.0, 121.0, 73.0, -169.0, 72.0, -141.0, 69.2, -141.0, 60.9, -141.0, 59.5, -139.6, 57.9, -141.6, 57.75, -152.33, 56.95, -158.62, 55.2667, -162.775, 53.905, -166.55, 51.9167, -176.567, 50.515, 175.945, 46.4317, 162.31, 39.625, 150.482, 37.2, 150.5, 35.2, 146.0, 32.0, 146.0, 25.0, 144.343, 21.0, 145.2, 17.42, 146.5, 16.5367, 147.925, 14.875, 148.982, 12.215, 148.962, 7.0, 158.2, 8.7, 167.7, 7.1, 171.3, 11.7083, -180.0, 21.1567, -164.0, 22.8, -162.617, 25.1617, -154.563, 30.0, -146.15, 34.6, -135.7, 37.8483, -127.0, 37.8333, -125.835, 37.0, -125.0, 36.1817, -124.76, 34.2, -123.1, 33.5, -122.6, 32.7, -122.0, 31.6, -121.4, 25.0, -120.0, 85.9999, 176.0, 14.535, -132.312, -5.0, -142.515, -14.9483, -147.683, -17.5483, -149.602, -33.0917, -175.0, -37.0, 178.967, -39.8167, 178.933, -45.2333, 172.233, -46.4667, 168.483, -38.3117, 75.0, -35.0, 26.0, -35.2167, 10.0, -18.0, 10.0, -9.66667, 11.4, -4.79833, 6.58333, 0.391667, -7.745, 4.57167, -12.165, 6.96, -14.72, 12.2833, -17.3667, 13.0, -18.0, 20.9167, -18.0, 25.0, -19.8117, 35.9667, -11.45, 36.7617, -13.6733, 38.0, -15.0, 42.0, -15.0, 43.0, -13.0, 45.0, -13.0, 45.0, -9.0, 46.0, -8.75, 48.0, -8.75, 48.5983, -9.0, 49.0667, -11.745, 49.0, -15.0, 57.0, -15.0, 57.0, -10.0, 61.0, -10.0, 61.0, 0.001667, 63.0, 3.71667, 68.0967, 10.9583, 75.0, 75.0, 69.7033, 18.9967, 70.3667, 32.0, 73.0, 46.0};

    public void testIsSelfIntersectingPoly() {
        IntersectionTest.assertTrue((boolean)Intersection.isSelfIntersectingPoly(IntersectionTest.toFloatArray(_BadPolygon)));
        IntersectionTest.assertFalse((boolean)Intersection.isSelfIntersectingPoly(IntersectionTest.toFloatArray(_Polygon)));
    }

    public void testIsPointInPolygonGeoGeoArrayBoolean() {
        GeoArray.Double ga = GeoArray.Double.createFromLatLonDegrees(_Polygon);
        GeoRegion.Impl reg = new GeoRegion.Impl(_Polygon);
        BoundingCircle bound = reg.getBoundingCircle();
        Geo centroid = bound.getCenter();
        Geo internal = Geo.makeGeoDegrees(32.0, 40.0);
        IntersectionTest.assertTrue((boolean)Intersection.isPointInPolygon(internal, ga, internal));
        IntersectionTest.assertTrue((boolean)Intersection.isPointInPolygon(centroid, ga, internal));
        IntersectionTest.assertFalse((boolean)Intersection.isPointInPolygon(centroid.antipode(), ga, internal));
        IntersectionTest.assertTrue((boolean)Intersection.isPointInPolygon(new Geo(38.75, -27.6, true), ga, internal));
        IntersectionTest.assertFalse((boolean)Intersection.isPointInPolygon(new Geo(39.0, -90.0, true), ga, internal));
    }

    private static float[] toFloatArray(double[] ar) {
        float[] fa = new float[ar.length];
        for (int i = 0; i < ar.length; ++i) {
            fa[i] = (float)ar[i];
        }
        return fa;
    }
}

