/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.geo;

import com.bbn.openmap.geo.Intersection;
import com.bbn.openmap.geo.Rotation;
import com.bbn.openmap.proj.Length;
import java.util.ArrayList;
import java.util.Enumeration;

public class Geo {
    public static final double flattening = 0.0033528106647474805;
    public static final double FLATTENING_C = 0.9933056200098587;
    public static final double METERS_PER_NM = 1852.0;
    private static final double NPD_LTERM1 = 60.15812095032397;
    private static final double NPD_LTERM2 = -0.05048596112311015;
    private static final double NPD_LTERM3 = 6.371490280777538E-5;
    private double x;
    private double y;
    private double z;
    public static final Geo north = new Geo(0.0, 0.0, 1.0);

    public static final double npdAtLat(double latdeg) {
        double lat = Math.toRadians(latdeg);
        return 60.15812095032397 * Math.cos(lat) + -0.05048596112311015 * Math.cos(3.0 * lat) + 6.371490280777538E-5 * Math.cos(5.0 * lat);
    }

    public static double geocentricLatitude(double geographicLatitude) {
        return Math.atan(Math.tan(geographicLatitude) * 0.9933056200098587);
    }

    public static double geographicLatitude(double geocentricLatitude) {
        return Math.atan(Math.tan(geocentricLatitude) / 0.9933056200098587);
    }

    public static double radians(double degrees) {
        return Length.DECIMAL_DEGREE.toRadians(degrees);
    }

    public static double degrees(double radians) {
        return Length.DECIMAL_DEGREE.fromRadians(radians);
    }

    public static double km(double radians) {
        return Length.KM.fromRadians(radians);
    }

    public static double kmToAngle(double km) {
        return Length.KM.toRadians(km);
    }

    public static double nm(double radians) {
        return Length.NM.fromRadians(radians);
    }

    public static double nmToAngle(double nm) {
        return Length.NM.toRadians(nm);
    }

    public Geo() {
    }

    public Geo(double lat, double lon) {
        this.initialize(lat, lon);
    }

    public Geo(double lat, double lon, boolean isDegrees) {
        if (isDegrees) {
            this.initialize(lat, lon);
        } else {
            this.initializeRadians(lat, lon);
        }
    }

    public Geo(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Geo(Geo geo) {
        this(geo.x, geo.y, geo.z);
    }

    public static final Geo makeGeoRadians(double latr, double lonr) {
        double rlat = Geo.geocentricLatitude(latr);
        double c = Math.cos(rlat);
        return new Geo(c * Math.cos(lonr), c * Math.sin(lonr), Math.sin(rlat));
    }

    public static final Geo makeGeoDegrees(double latd, double lond) {
        return Geo.makeGeoRadians(Geo.radians(latd), Geo.radians(lond));
    }

    public static final Geo makeGeo(double x, double y, double z) {
        return new Geo(x, y, z);
    }

    public static final Geo makeGeo(Geo p) {
        return new Geo(p.x, p.y, p.z);
    }

    public void initialize(Geo g) {
        this.x = g.x;
        this.y = g.y;
        this.z = g.z;
    }

    public void initialize(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void initialize(double lat, double lon) {
        this.initializeRadians(Geo.radians(lat), Geo.radians(lon));
    }

    public void initializeRadians(double lat, double lon) {
        double rlat = Geo.geocentricLatitude(lat);
        double c = Math.cos(rlat);
        this.x = c * Math.cos(lon);
        this.y = c * Math.sin(lon);
        this.z = Math.sin(rlat);
    }

    public Geo midPoint(Geo g2) {
        return this.add(g2).normalize();
    }

    public Geo midPoint(Geo g2, Geo ret) {
        return this.add(g2).normalize(ret);
    }

    public Geo interpolate(Geo g2, double x) {
        return this.scale(x).add(g2.scale(1.0 - x)).normalize();
    }

    public Geo interpolate(Geo g2, double x, Geo ret) {
        return this.scale(x).add(g2.scale(1.0 - x, ret), ret).normalize(ret);
    }

    public String toString() {
        return "Geo[" + this.getLatitude() + "," + this.getLongitude() + "]";
    }

    public double getLatitude() {
        return Geo.degrees(Geo.geographicLatitude(Math.atan2(this.z, Math.sqrt(this.x * this.x + this.y * this.y))));
    }

    public double getLongitude() {
        return Geo.degrees(Math.atan2(this.y, this.x));
    }

    public double getLatitudeRadians() {
        return Geo.geographicLatitude(Math.atan2(this.z, Math.sqrt(this.x * this.x + this.y * this.y)));
    }

    public double getLongitudeRadians() {
        return Math.atan2(this.y, this.x);
    }

    public final double x() {
        return this.x;
    }

    public final double y() {
        return this.y;
    }

    public final double z() {
        return this.z;
    }

    public void setLength(double r) {
        double rlat = Math.atan2(this.z, Math.sqrt(this.x * this.x + this.y * this.y));
        double rlon = this.getLongitudeRadians();
        double c = r * Math.cos(rlat);
        this.x = c * Math.cos(rlon);
        this.y = c * Math.sin(rlon);
        this.z = r * Math.sin(rlat);
    }

    public double dot(Geo b) {
        return this.x() * b.x() + this.y() * b.y() + this.z() * b.z();
    }

    public static double dot(Geo a, Geo b) {
        return a.x() * b.x() + a.y() * b.y() + a.z() * b.z();
    }

    public double length() {
        return Math.sqrt(this.dot(this));
    }

    public Geo scale(double s) {
        return this.scale(s, new Geo());
    }

    public Geo scale(double s, Geo ret) {
        ret.initialize(this.x() * s, this.y() * s, this.z() * s);
        return ret;
    }

    public Geo normalize() {
        return this.scale(1.0 / this.length());
    }

    public Geo normalize(Geo ret) {
        return this.scale(1.0 / this.length(), ret);
    }

    public Geo cross(Geo b) {
        return this.cross(b, new Geo());
    }

    public Geo cross(Geo b, Geo ret) {
        ret.initialize(this.y() * b.z() - this.z() * b.y(), this.z() * b.x() - this.x() * b.z(), this.x() * b.y() - this.y() * b.x());
        return ret;
    }

    public double crossLength(Geo b) {
        double x = this.y() * b.z() - this.z() * b.y();
        double y = this.z() * b.x() - this.x() * b.z();
        double z = this.x() * b.y() - this.y() * b.x();
        return Math.sqrt(x * x + y * y + z * z);
    }

    public Geo crossNormalize(Geo b) {
        return this.crossNormalize(b, new Geo());
    }

    public Geo crossNormalize(Geo b, Geo ret) {
        double x = this.y() * b.z() - this.z() * b.y();
        double y = this.z() * b.x() - this.x() * b.z();
        double z = this.x() * b.y() - this.y() * b.x();
        double L = Math.sqrt(x * x + y * y + z * z);
        ret.initialize(x / L, y / L, z / L);
        return ret;
    }

    public static Geo crossNormalize(Geo a, Geo b, Geo ret) {
        return a.crossNormalize(b, ret);
    }

    public Geo add(Geo b) {
        return this.add(b, new Geo());
    }

    public Geo add(Geo b, Geo ret) {
        ret.initialize(this.x() + b.x(), this.y() + b.y(), this.z() + b.z());
        return ret;
    }

    public Geo subtract(Geo b) {
        return this.subtract(b, new Geo());
    }

    public Geo subtract(Geo b, Geo ret) {
        ret.initialize(this.x() - b.x(), this.y() - b.y(), this.z() - b.z());
        return ret;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Geo)) {
            return false;
        }
        Geo v2 = (Geo)obj;
        return this.x == v2.x && this.y == v2.y && this.z == v2.z;
    }

    public double distance(Geo v2) {
        return Math.atan2(v2.crossLength(this), v2.dot(this));
    }

    public static double distance(Geo v1, Geo v2) {
        return v1.distance(v2);
    }

    public static double distance(double lat1, double lon1, double lat2, double lon2) {
        return Geo.distance(new Geo(lat1, lon1), new Geo(lat2, lon2));
    }

    public double distanceKM(Geo v2) {
        return Geo.km(this.distance(v2));
    }

    public static double distanceKM(Geo v1, Geo v2) {
        return v1.distanceKM(v2);
    }

    public static double distanceKM(double lat1, double lon1, double lat2, double lon2) {
        return Geo.distanceKM(new Geo(lat1, lon1), new Geo(lat2, lon2));
    }

    public double distanceNM(Geo v2) {
        return Geo.nm(this.distance(v2));
    }

    public static double distanceNM(Geo v1, Geo v2) {
        return v1.distanceNM(v2);
    }

    public static double distanceNM(double lat1, double lon1, double lat2, double lon2) {
        return Geo.distanceNM(new Geo(lat1, lon1), new Geo(lat2, lon2));
    }

    public double strictAzimuth(Geo v2) {
        Geo n1 = north.crossNormalize(this);
        Geo n2 = v2.crossNormalize(this);
        double az = Math.atan2(-north.dot(n2), n1.dot(n2));
        return az > 0.0 ? az : Math.PI * 2 + az;
    }

    public double azimuth(Geo v2) {
        double ret = this.strictAzimuth(v2);
        if (Double.isNaN(ret)) {
            return 0.0;
        }
        return ret;
    }

    public static double angle(Geo p0, Geo p1, Geo p2) {
        return Math.PI - p0.cross(p1).distance(p1.cross(p2));
    }

    public static double area(Enumeration vs) {
        int count = 0;
        double area = 0.0;
        Geo v0 = (Geo)vs.nextElement();
        Geo v1 = (Geo)vs.nextElement();
        Geo p0 = v0;
        Geo p1 = v1;
        Geo p2 = null;
        while (vs.hasMoreElements()) {
            ++count;
            p2 = (Geo)vs.nextElement();
            area += Geo.angle(p0, p1, p2);
            p0 = p1;
            p1 = p2;
        }
        ++count;
        p2 = v0;
        area += Geo.angle(p0, p1, p2);
        p0 = p1;
        p1 = p2;
        p2 = v1;
        return (area += Geo.angle(p0, p1, p2)) - (double)(++count - 2) * Math.PI;
    }

    public boolean isInside(Geo v2, double radius, Geo p) {
        Geo dp;
        Geo tmp = new Geo();
        Geo gc = this.crossNormalize(v2, tmp);
        if (Math.abs(gc.dot(p)) > Math.cos(1.5707963267948966 - radius)) {
            return false;
        }
        if (this.distance(p) <= radius || v2.distance(p) <= radius) {
            return true;
        }
        Geo d = v2.subtract(this, tmp);
        double L = d.length();
        Geo n = d.normalize(tmp);
        double size = n.dot(dp = p.subtract(this, new Geo()));
        return 0.0 <= size && size <= L;
    }

    public static boolean isInside(Geo v1, Geo v2, double radius, Geo p1, Geo p2) {
        return v1.isInside(v2, radius, p1) || v1.isInside(v2, radius, p2) || p1.isInside(p2, radius, v1) || p1.isInside(p2, radius, v2);
    }

    public static boolean isInside(double lat1, double lon1, double lat2, double lon2, double radius, double lat3, double lon3) {
        return new Geo(lat1, lon1).isInside(new Geo(lat2, lon2), radius, new Geo(lat3, lon3));
    }

    public boolean inBubble(Geo v2, double forwardRadius, double backRadius, Geo p) {
        return this.distance(p) <= (v2.subtract(this).normalize().dot(p.subtract(this)) > 0.0 ? forwardRadius : backRadius);
    }

    public Geo antipode() {
        return this.scale(-1.0, new Geo());
    }

    public Geo antipode(Geo ret) {
        return this.scale(-1.0, ret);
    }

    public Geo intersect(Geo q, Geo r) {
        return this.intersect(q, r, new Geo());
    }

    public Geo intersect(Geo q, Geo r, Geo ret) {
        double a = this.dot(r);
        double b = q.dot(r);
        double x = -b / (a - b);
        return this.scale(x, ret).add(q.scale(1.0 - x), ret).normalize(ret);
    }

    public static Geo[] computeCorridor(Geo[] path, double radius) {
        return Geo.computeCorridor(path, radius, Geo.radians(10.0), true);
    }

    public static Geo[] computeCorridor(Geo[] path, double radius, double err, boolean capp) {
        if (path == null || radius <= 0.0) {
            return new Geo[0];
        }
        int pl = path.length;
        if (pl < 2) {
            return null;
        }
        ArrayList<Geo> right = new ArrayList<Geo>((int)((double)pl * 1.5));
        ArrayList<Geo> left = new ArrayList<Geo>((int)((double)pl * 1.5));
        Geo g0 = null;
        Geo n0 = null;
        Geo l0 = null;
        Geo r0 = null;
        Geo g1 = path[0];
        for (int i = 1; i < pl; ++i) {
            Geo g2 = path[i];
            Geo n1 = g1.crossNormalize(g2);
            n1 = n1.scale(radius);
            Geo r1b = g1.add(n1);
            Geo l1b = g1.subtract(n1);
            if (n0 == null || g0 == null) {
                if (capp && err > 0.0) {
                    Geo[] arc = Geo.approximateArc(g1, l1b, r1b, err);
                    for (int j = arc.length - 1; j >= 0; --j) {
                        right.add(arc[j]);
                    }
                } else {
                    right.add(l1b);
                    left.add(r1b);
                }
                l0 = l1b;
                r0 = r1b;
            } else {
                Geo ip;
                Geo r1a = g1.add(n0);
                Geo l1a = g1.subtract(n0);
                double handed = g0.cross(g1).dot(g2);
                if (handed > 0.0) {
                    if (err > 0.0) {
                        Geo[] arc = Geo.approximateArc(g1, l1b, l1a, err);
                        for (int j = arc.length - 1; j >= 0; --j) {
                            right.add(arc[j]);
                        }
                    } else {
                        right.add(l1a);
                        right.add(l1b);
                    }
                    l0 = l1b;
                    ip = Intersection.segmentsIntersect(r0, r1a, r1b, g2.add(n1));
                    if (ip != null) {
                        left.add(ip);
                    } else {
                        left.add(r1a);
                        left.add(r1b);
                    }
                    r0 = ip;
                } else {
                    ip = Intersection.segmentsIntersect(l0, l1a, l1b, g2.subtract(n1));
                    if (ip != null) {
                        right.add(ip);
                    } else {
                        right.add(l1a);
                        right.add(l1b);
                    }
                    l0 = ip;
                    if (err > 0.0) {
                        Geo[] arc = Geo.approximateArc(g1, r1a, r1b, err);
                        for (int j = 0; j < arc.length; ++j) {
                            left.add(arc[j]);
                        }
                    } else {
                        left.add(r1a);
                        left.add(r1b);
                    }
                    r0 = r1b;
                }
            }
            g0 = g1;
            n0 = n1;
            g1 = g2;
        }
        Geo rn = g1.subtract(n0);
        Geo ln = g1.add(n0);
        if (capp && err > 0.0) {
            Geo[] arc = Geo.approximateArc(g1, ln, rn, err);
            for (int j = arc.length - 1; j >= 0; --j) {
                right.add(arc[j]);
            }
        } else {
            right.add(rn);
            left.add(ln);
        }
        int ll = right.size();
        int rl = left.size();
        Geo[] result = new Geo[ll + rl];
        for (int i = 0; i < ll; ++i) {
            result[i] = (Geo)right.get(i);
        }
        int j = ll;
        for (int i = rl - 1; i >= 0; --i) {
            result[j++] = (Geo)left.get(i);
        }
        return result;
    }

    static double simpleAngle(Geo p1, Geo p2) {
        return Math.acos(p1.dot(p2) / (p1.length() * p2.length()));
    }

    public static final Geo[] approximateArc(Geo pc, Geo p0, Geo p1, double err) {
        double theta = Geo.angle(p0, pc, p1);
        if (Double.isNaN(theta)) {
            return new Geo[]{p0, p1};
        }
        int n = (int)(2.0 + Math.abs(theta / err));
        Geo[] result = new Geo[n];
        result[0] = p0;
        double dtheta = theta / (double)(n - 1);
        double rho = 0.0;
        for (int i = 1; i < n - 1; ++i) {
            result[i] = Rotation.rotate(pc, Math.PI * 2 - (rho += dtheta), p0, new Geo());
        }
        result[n - 1] = p1;
        return result;
    }

    public final Geo[] approximateArc(Geo p0, Geo p1, double err) {
        return Geo.approximateArc(this, p0, p1, err);
    }

    public Geo geoAt(double distance, double azimuth) {
        return this.offset(distance, azimuth);
    }

    public Geo offset(double distance, double azimuth) {
        return this.offset(distance, azimuth, new Geo());
    }

    public Geo offset(double distance, double azimuth, Geo ret) {
        Geo m = this.crossNormalize(north, ret);
        Geo p = Rotation.rotate(m, distance, this, ret);
        return Rotation.rotate(this, Math.PI * 2 - azimuth, p, ret);
    }

    public int hashCode() {
        int result = 17;
        long lx = Double.doubleToLongBits(this.x);
        long ly = Double.doubleToLongBits(this.y);
        long lz = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(lx ^ lx >>> 32);
        result = 31 * result + (int)(ly ^ ly >>> 32);
        result = 31 * result + (int)(lz ^ lz >>> 32);
        return result;
    }

    public static Geo offset(Geo origin, double distance, double azimuth) {
        return origin.offset(distance, azimuth);
    }

    public static Geo offset(Geo origin, double distance, double azimuth, Geo ret) {
        return origin.offset(distance, azimuth, ret);
    }

    public static Geo[] posToGa(String coords) {
        return Geo.posToGa(coords.split(" "));
    }

    public static Geo[] posToGa(String[] coords) {
        Geo[] ga = new Geo[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            String[] ll = coords[i].split(",");
            ga[i] = Geo.makeGeoDegrees(Double.parseDouble(ll[0]), Double.parseDouble(ll[1]));
        }
        return ga;
    }

    public static double[] GaToLLa(Geo[] ga, double[] lla) {
        if (lla == null) {
            lla = new double[2 * ga.length];
        }
        for (int i = 0; i < ga.length; ++i) {
            Geo g = ga[i];
            lla[i * 2] = g.getLatitude();
            lla[i * 2 + 1] = g.getLongitude();
        }
        return lla;
    }

    public static float[] GaToLLa(Geo[] ga, float[] lla) {
        if (lla == null) {
            lla = new float[2 * ga.length];
        }
        for (int i = 0; i < ga.length; ++i) {
            Geo g = ga[i];
            lla[i * 2] = (float)g.getLatitude();
            lla[i * 2 + 1] = (float)g.getLongitude();
        }
        return lla;
    }

    public static float[] GaToLLa(Geo[] ga) {
        return Geo.GaToLLa(ga, new float[2 * ga.length]);
    }

    public static Geo[] removeDups(Geo[] ga) {
        Geo[] r = new Geo[ga.length];
        int p = 0;
        for (int i = 0; i < ga.length; ++i) {
            if (p != 0 && r[p - 1].equals(ga[i])) continue;
            r[p] = ga[i];
            ++p;
        }
        if (p != ga.length) {
            Geo[] x = new Geo[p];
            System.arraycopy(r, 0, x, 0, p);
            return x;
        }
        return ga;
    }

    public static Geo[] LLaToGa(float[] lla) {
        return Geo.LLaToGa(lla, true);
    }

    public static Geo[] LLaToGa(float[] lla, boolean isDegrees) {
        Geo[] r = new Geo[lla.length / 2];
        for (int i = 0; i < lla.length / 2; ++i) {
            r[i] = isDegrees ? Geo.makeGeoDegrees(lla[i * 2], lla[i * 2 + 1]) : Geo.makeGeoRadians(lla[i * 2], lla[i * 2 + 1]);
        }
        return r;
    }

    public static Geo[] LLaToGa(double[] lla) {
        return Geo.LLaToGa(lla, true);
    }

    public static Geo[] LLaToGa(double[] lla, boolean isDegrees) {
        Geo[] r = new Geo[lla.length / 2];
        for (int i = 0; i < lla.length / 2; ++i) {
            r[i] = isDegrees ? Geo.makeGeoDegrees(lla[i * 2], lla[i * 2 + 1]) : Geo.makeGeoRadians(lla[i * 2], lla[i * 2 + 1]);
        }
        return r;
    }

    public static float[] closeLLa(float[] lla) {
        int l = lla.length;
        int s = l / 2 - 1;
        if (lla[0] == lla[s * 2] && lla[1] == lla[s * 2 + 1]) {
            return lla;
        }
        float[] llx = new float[l + 2];
        System.arraycopy(lla, 0, llx, 0, l);
        llx[l] = lla[0];
        llx[l + 1] = lla[1];
        return llx;
    }

    public static Geo[] closeGa(Geo[] ga) {
        int l = ga.length;
        if (ga[0].equals(ga[l - 1])) {
            return ga;
        }
        Geo[] x = new Geo[l + 1];
        System.arraycopy(ga, 0, x, 0, l);
        x[l] = ga[0];
        return x;
    }
}

