/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.examples.hello;

import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.MultipleSoloMapComponentException;
import com.bbn.openmap.event.NavMouseMode;
import com.bbn.openmap.gui.OMToolSet;
import com.bbn.openmap.gui.ToolPanel;
import com.bbn.openmap.proj.coords.LatLonPoint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;

public class HelloWorld
extends JFrame {
    public static final String layersProperty = "hello.layers";
    public static String helloResources = "HelloWorld.properties";
    public static String message = "Hello, World!";

    public HelloWorld() throws MultipleSoloMapComponentException {
        this(new Properties());
    }

    public HelloWorld(Properties props) throws MultipleSoloMapComponentException {
        super("HelloWorld Example");
        this.getContentPane().setLayout(new BorderLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                HelloWorld.this.quit();
            }
        });
        System.out.println("Creating MapHandler");
        MapHandler mapHandler = new MapHandler();
        System.out.println("Creating MapBean");
        MapBean map = new MapBean();
        map.setCenter(new LatLonPoint.Double(43.0, -95.0));
        map.setScale(8.0E7f);
        mapHandler.add(map);
        this.getContentPane().add((Component)map, "Center");
        System.out.println("Adding MouseEvent support...");
        mapHandler.add(new MouseDelegator());
        mapHandler.add(new NavMouseMode());
        System.out.println("Creating ToolPanel...");
        mapHandler.add(new OMToolSet());
        ToolPanel toolPanel = new ToolPanel();
        mapHandler.add(toolPanel);
        this.getContentPane().add((Component)toolPanel, "North");
        System.out.println("Creating Layers...");
        Layer[] layers = this.getLayers(props);
        LayerHandler layerHandler = new LayerHandler();
        for (int i = 0; i < layers.length; ++i) {
            layers[i].setVisible(true);
            layerHandler.addLayer(layers[i]);
        }
        mapHandler.add(layerHandler);
        System.out.println("Done creating...");
    }

    protected void quit() {
        System.exit(0);
    }

    public static void main(String[] args) {
        Properties helloProps = new Properties();
        HelloWorld.loadResource(helloResources, helloProps);
        try {
            HelloWorld hello = new HelloWorld(helloProps);
            hello.setSize(700, 500);
            hello.pack();
            hello.setVisible(true);
        }
        catch (MultipleSoloMapComponentException multipleSoloMapComponentException) {
            // empty catch block
        }
    }

    private static void loadResource(String resources, Properties props) {
        InputStream in = HelloWorld.class.getResourceAsStream(resources);
        if (props == null) {
            System.err.println("Unable to locate resources: " + resources);
            System.err.println("Using default resources.");
        } else {
            try {
                props.load(in);
            }
            catch (IOException e) {
                System.err.println("Caught IOException loading resources: " + resources);
                System.err.println("Using default resources.");
            }
        }
    }

    private Layer[] getLayers(Properties p) {
        String layersValue = p.getProperty(layersProperty);
        if (layersValue == null) {
            System.err.println("No property \"hello.layers\" found in application properties.");
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(layersValue, " ");
        Vector<String> layerNames = new Vector<String>();
        while (tokens.hasMoreTokens()) {
            layerNames.addElement(tokens.nextToken());
        }
        int nLayerNames = layerNames.size();
        Vector<Layer> layers = new Vector<Layer>(nLayerNames);
        for (int i = 0; i < nLayerNames; ++i) {
            String layerName = (String)layerNames.elementAt(i);
            String classProperty = layerName + ".class";
            String className = p.getProperty(classProperty);
            if (className == null) {
                System.err.println("Failed to locate property \"" + classProperty + "\"");
                System.err.println("Skipping layer \"" + layerName + "\"");
                continue;
            }
            try {
                Object obj = Beans.instantiate(null, className);
                if (!(obj instanceof Layer)) continue;
                Layer l = (Layer)obj;
                l.setProperties(layerName, p);
                layers.addElement(l);
                continue;
            }
            catch (ClassNotFoundException e) {
                System.err.println("Layer class not found: \"" + className + "\"");
                System.err.println("Skipping layer \"" + layerName + "\"");
                continue;
            }
            catch (IOException e) {
                System.err.println("IO Exception instantiating class \"" + className + "\"");
                System.err.println("Skipping layer \"" + layerName + "\"");
            }
        }
        int nLayers = layers.size();
        if (nLayers == 0) {
            return null;
        }
        Object[] value = new Layer[nLayers];
        layers.copyInto(value);
        return value;
    }
}

