/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.proj.Proj;
import java.awt.geom.Point2D;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionChangeVetoException
extends RuntimeException {
    protected Properties parameters;
    public static final String CENTER = "center";
    public static final String SCALE = "scale";
    public static final String PROJECTION_TYPE = "projType";

    public ProjectionChangeVetoException() {
    }

    public ProjectionChangeVetoException(String message) {
        super(message);
    }

    public ProjectionChangeVetoException(String message, Class<? extends Proj> projectionType, Point2D center, Number scale) {
        super(message);
        this.parameters = new Properties();
        if (projectionType != null) {
            this.parameters.put(PROJECTION_TYPE, projectionType);
        }
        if (center != null) {
            this.parameters.put(CENTER, center);
        }
        if (scale != null) {
            this.parameters.put(SCALE, scale);
        }
    }

    public ProjectionChangeVetoException(String message, Properties suggestedChanges) {
        this.parameters = suggestedChanges;
    }

    public Object getSuggested(String parameter) {
        return this.parameters.get(parameter);
    }

    public void removeSuggested(String parameter) {
        this.parameters.remove(parameter);
    }

    public void updateWithParameters(MapBean mapBean) {
        Proj projection = (Proj)mapBean.getProjection();
        Object suggested = this.getSuggested(PROJECTION_TYPE);
        if (suggested instanceof Class && suggested != projection.getClass()) {
            projection = (Proj)mapBean.getProjectionFactory().makeProjection((Class)suggested, projection.getCenter(), projection.getScale(), projection.getWidth(), projection.getHeight());
        }
        if ((suggested = this.getSuggested(CENTER)) instanceof Point2D) {
            projection.setCenter((Point2D)suggested);
        }
        if ((suggested = this.getSuggested(SCALE)) instanceof Number) {
            projection.setScale(((Number)suggested).floatValue());
        }
        mapBean.setProjection(projection);
    }

    @Override
    public String toString() {
        String message = this.getMessage();
        if (message == null) {
            message = "[no message]";
        }
        return "ProjectionChangeVetoException: " + message + ", suggested parameters: " + this.parameters;
    }
}

