/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.event.OMEvent;
import com.bbn.openmap.util.HashCodeUtil;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMEventComparator
implements Comparator<OMEvent> {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.event.OMEventComparator");

    @Override
    public int compare(OMEvent obj1, OMEvent obj2) {
        int ret = 0;
        long ts1 = obj1.getTimeStamp();
        short tsc1 = obj1.getTimeStampComparator();
        long ts2 = obj2.getTimeStamp();
        short tsc2 = obj2.getTimeStampComparator();
        if (ts1 < ts2) {
            ret = -1;
            obj1.setSorted(true);
        } else if (ts1 > ts2) {
            ret = 1;
        } else {
            boolean logging = false;
            String id1 = null;
            String id2 = null;
            if (logger.isLoggable(Level.FINE)) {
                id1 = obj1.getDescription();
                id2 = obj2.getDescription();
                logging = true;
            }
            if (tsc1 == 0) {
                tsc1 = tsc2;
                if (logging) {
                    logger.info("new event..." + id1);
                }
            } else {
                obj1.setSorted(true);
            }
            if (logging) {
                logger.info("comparing [" + id1 + "] at " + tsc1 + " to [" + id2 + "] at " + tsc2);
            }
            if (tsc1 < tsc2 && obj1.isSorted()) {
                ret = -1;
                if (logging) {
                    logger.info("-----");
                }
            } else if (tsc1 > tsc2) {
                ret = 1;
                if (logging) {
                    logger.info("+++++");
                }
            } else {
                tsc1 = (short)(tsc2 + 1);
                obj2.setTimeStampComparator(tsc1);
                ret = 1;
                if (logging) {
                    logger.info("^^^^^ " + ts1 + ", upping [" + id1 + "] to " + tsc1 + " over [" + id2 + "]");
                }
            }
        }
        return ret;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtil.hash(result, this.getClass().getName());
        return result;
    }
}

