/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.Layer;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.dataAccess.mapTile.MapTileMakerComponent;
import com.bbn.openmap.dataAccess.mapTile.ZoomLevelMaker;
import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.Projection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoomLevelMakerFace
extends OMComponentPanel {
    protected static Logger logger = Logger.getLogger("com.bbn.openmap.dataAccess.mapTile.ZoomLevelMakerFace");
    private static final long serialVersionUID = 1L;
    protected ZoomLevelMaker zfi;
    boolean active = false;
    boolean include = false;
    protected JList boundsList;
    protected List<BoundsObject> boundsObjectList;
    protected BoundsListModel boundsModel;
    protected OMGraphicList boundaries = new OMGraphicList();
    protected List<LayerObject> layerList = new ArrayList<LayerObject>();
    protected MapTileMakerComponent organizer;
    protected JPanel layerPanel;
    protected JButton createBoundaryButton;
    protected JButton editBoundaryButton;
    protected JButton deleteBoundaryButton;
    protected JLabel intro;
    protected JLabel tileDimensions;
    protected JButton scaleButton;
    JSpinner rangeLevelChoice;

    public ZoomLevelMakerFace(ZoomLevelMaker zfi, MapTileMakerComponent mtmc) {
        this.zfi = zfi;
        this.organizer = mtmc;
        this.setLayout(new GridBagLayout());
        JPanel introPanel = new JPanel(new GridBagLayout());
        JLabel intro = new JLabel(this.i18n.get(ZoomLevelMakerFace.class, "zoom_level", "Make tiles for zoom levels"));
        JLabel tileDimLabel = new JLabel(this.i18n.get(ZoomLevelMakerFace.class, "tile_dim", "Tile Dimensions"));
        JLabel baseScaleLabel = new JLabel(this.i18n.get(ZoomLevelMakerFace.class, "base_scale", "Base Scale for Zoom Level"));
        JSpinner zoomLevelChoice = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 20.0, 1.0)){

            public void setValue(Object value) {
                if (value instanceof Number) {
                    value = new Double(((Number)value).intValue());
                }
                super.setValue(value);
                ZoomLevelMakerFace.this.updateZoomLevel(((Double)this.getValue()).intValue());
            }
        };
        String upperZoomLevelTT = this.i18n.get(ZoomLevelMakerFace.class, "upper_zoom_level", 3, "Upper zoom level");
        String lowerZoomLevelTT = this.i18n.get(ZoomLevelMakerFace.class, "lower_zoom_level", 3, "Lower zoom level");
        zoomLevelChoice.setToolTipText(upperZoomLevelTT);
        this.tileDimensions = new JLabel();
        this.scaleButton = new JButton();
        this.scaleButton.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.scaleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MapHandler mHandler = (MapHandler)ZoomLevelMakerFace.this.organizer.getBeanContext();
                MapBean map = mHandler.get(MapBean.class);
                map.setScale(ZoomLevelMakerFace.this.getZoomLevelMaker().getScale());
            }
        });
        this.rangeLevelChoice = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 20.0, 1.0)){

            public void setValue(Object value) {
                if (value instanceof Number) {
                    int limit;
                    int newVal = ((Number)value).intValue();
                    if (newVal > (limit = ZoomLevelMakerFace.this.getZoomLevelMaker().getZoomLevel())) {
                        newVal = limit;
                    }
                    value = new Double(newVal);
                    ZoomLevelMakerFace.this.getZoomLevelMaker().setRange(newVal);
                }
                super.setValue(value);
            }
        };
        this.rangeLevelChoice.setToolTipText(lowerZoomLevelTT);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        JPanel zoomHolder = new JPanel();
        zoomHolder.add((Component)zoomLevelChoice, c);
        zoomHolder.add((Component)new JLabel(" to "), c);
        zoomHolder.add((Component)this.rangeLevelChoice, c);
        this.addIntroEntry(introPanel, intro, zoomHolder, 0, new Insets(0, 0, 0, 0));
        this.addIntroEntry(introPanel, tileDimLabel, this.tileDimensions, 1, new Insets(0, 0, 5, 0));
        this.addIntroEntry(introPanel, baseScaleLabel, this.scaleButton, 2, new Insets(0, 0, 5, 0));
        this.updateZoomLevel(0);
        this.add((Component)introPanel, c);
        c.gridx = 0;
        c.anchor = 17;
        this.include = true;
        c.fill = 1;
        c.weightx = 1.0;
        this.layerPanel = new JPanel(new GridBagLayout());
        this.setLayers(this.layerList);
        JPanel outerLayerPanel = new JPanel(new GridBagLayout());
        String layers_for_title = this.i18n.get(ZoomLevelMakerFace.class, "layers_for_title", "Layers");
        outerLayerPanel.setBorder(BorderFactory.createTitledBorder(layers_for_title));
        JScrollPane jsp = new JScrollPane(this.layerPanel, 20, 30);
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        outerLayerPanel.add((Component)jsp, c);
        c.weighty = 0.8f;
        c.insets = new Insets(3, 0, 3, 0);
        this.add((Component)outerLayerPanel, c);
        JPanel boundsPanel = new JPanel(new BorderLayout());
        String boundaries_for_title = this.i18n.get(ZoomLevelMakerFace.class, "boundaries_for_title", "Boundaries");
        boundsPanel.setBorder(BorderFactory.createTitledBorder(boundaries_for_title));
        this.boundsObjectList = new ArrayList<BoundsObject>();
        this.boundsModel = new BoundsListModel();
        this.boundsList = new JList(this.boundsModel);
        this.boundsList.setSelectionMode(0);
        this.boundsList.setLayoutOrientation(0);
        this.boundsList.setVisibleRowCount(4);
        this.boundsList.addListSelectionListener(new SelectionListener());
        this.boundsList.addMouseListener(new ListMouseListener());
        JScrollPane scrollableBoundsList = new JScrollPane(this.boundsList, 20, 30);
        boundsPanel.add((Component)scrollableBoundsList, "Center");
        JPanel boundsButtonPanel = new JPanel();
        ImageIcon ii = this.createImageIcon("add_16x16.png");
        this.createBoundaryButton = new JButton(ii);
        String create_a_boundary_rectangle = this.i18n.get(ZoomLevelMakerFace.class, "create_a_boundary_rectangle", "Create a boundary rectangle");
        this.createBoundaryButton.setToolTipText(create_a_boundary_rectangle);
        this.createBoundaryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ZoomLevelMakerFace.this.organizer.createRectangle();
            }
        });
        boundsButtonPanel.add(this.createBoundaryButton);
        ii = this.createImageIcon("edit_16x16.png");
        this.editBoundaryButton = new JButton(ii);
        String edit_a_selected_boundary_rectangle = this.i18n.get(ZoomLevelMakerFace.class, "edit_a_selected_boundary_rectangle", "Edit a selected boundary rectangle");
        this.editBoundaryButton.setToolTipText(edit_a_selected_boundary_rectangle);
        this.editBoundaryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (ZoomLevelMakerFace.this.boundsList.getSelectedIndex() != -1) {
                    BoundsObject selected = (BoundsObject)ZoomLevelMakerFace.this.boundsList.getSelectedValue();
                    ZoomLevelMakerFace.this.organizer.edit(selected.bounds, null);
                }
            }
        });
        boundsButtonPanel.add(this.editBoundaryButton);
        ii = this.createImageIcon("remov_16x16.png");
        this.deleteBoundaryButton = new JButton(ii);
        String delete_a_selected_boundary_rectangle = this.i18n.get(ZoomLevelMakerFace.class, "delete_a_selected_boundary_rectangle", "Delete a selected boundary rectangle");
        this.deleteBoundaryButton.setToolTipText(delete_a_selected_boundary_rectangle);
        this.deleteBoundaryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (ZoomLevelMakerFace.this.boundsList.getSelectedIndex() != -1) {
                    BoundsObject selected = (BoundsObject)ZoomLevelMakerFace.this.boundsList.getSelectedValue();
                    ZoomLevelMakerFace.this.boundaries.remove(selected.bounds);
                    ZoomLevelMakerFace.this.boundsObjectList.remove(selected);
                    ZoomLevelMakerFace.this.boundsList.repaint();
                    if (ZoomLevelMakerFace.this.organizer.drawingTool.isActivated()) {
                        ZoomLevelMakerFace.this.organizer.drawingTool.deactivate(4);
                    }
                    ((MapHandler)ZoomLevelMakerFace.this.organizer.getBeanContext()).get(MapBean.class).repaint();
                }
            }
        });
        boundsButtonPanel.add(this.deleteBoundaryButton);
        boundsPanel.add((Component)boundsButtonPanel, "South");
        c.weighty = 0.8f;
        this.add((Component)boundsPanel, c);
    }

    protected void addIntroEntry(JPanel panel, JComponent left, JComponent right, int y, Insets i) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = i;
        panel.add((Component)left, c);
        c.fill = 2;
        c.weightx = 1.0;
        panel.add(Box.createHorizontalGlue(), c);
        c.gridx = 1;
        c.fill = 0;
        c.weightx = 0.0;
        c.anchor = 13;
        panel.add((Component)right, c);
    }

    public void updateZoomLevel(int zoomLevel) {
        int rangeVal;
        DecimalFormat df = new DecimalFormat("000,000");
        this.zfi.setZoomLevel(zoomLevel);
        int etc = this.zfi.getEdgeTileCount();
        this.tileDimensions.setText(etc + " x " + etc);
        String scale = "1:" + df.format(this.zfi.getScale());
        this.scaleButton.setText(scale);
        String tooltip = this.i18n.get(ZoomLevelMakerFace.class, "set_map_scale_to", 3, "Set map scale to");
        this.scaleButton.setToolTipText(tooltip + " " + scale);
        Object obj = this.rangeLevelChoice.getValue();
        if (obj instanceof Number && (rangeVal = ((Number)obj).intValue()) > zoomLevel) {
            rangeVal = zoomLevel;
            this.rangeLevelChoice.setValue(new Integer(zoomLevel));
            this.zfi.setRange(rangeVal);
        }
    }

    protected void enableBoundaryButtons(boolean setting) {
        this.createBoundaryButton.setEnabled(setting);
        boolean somethingSelected = this.boundsList.getSelectedIndex() != -1;
        this.editBoundaryButton.setEnabled(setting && somethingSelected);
        this.deleteBoundaryButton.setEnabled(setting && somethingSelected);
    }

    protected void setLayers(Layer[] layers) {
        ArrayList<LayerObject> layerObjects = new ArrayList<LayerObject>();
        for (Layer layer : layers) {
            boolean foundOne = false;
            for (LayerObject lo : this.layerList) {
                if (!lo.getLayer().equals(layer)) continue;
                foundOne = true;
                layerObjects.add(lo);
                break;
            }
            if (foundOne) continue;
            layerObjects.add(new LayerObject(layer));
        }
        this.setLayers(layerObjects);
    }

    protected void setLayers(List<LayerObject> layerObjects) {
        this.layerList = layerObjects;
        if (this.layerPanel == null) {
            return;
        }
        this.layerPanel.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.anchor = 17;
        for (LayerObject lo : layerObjects) {
            String layerMarker = lo.getLayer().getPropertyPrefix();
            if (layerMarker != null) {
                lo.setSelected(this.zfi.getLayers().contains(layerMarker));
            }
            this.layerPanel.add((Component)lo, c);
        }
        c.fill = 1;
        c.weighty = 1.0;
        this.layerPanel.add(Box.createGlue(), c);
    }

    protected void matchObjects(List<LayerObject> layerObjects) {
        for (LayerObject lo : this.layerList) {
            for (LayerObject toMatch : layerObjects) {
                Layer matchedLayer = toMatch.getLayer();
                if (!lo.getLayer().equals(matchedLayer)) continue;
                boolean turnOn = toMatch.isSelected();
                String layerMarker = matchedLayer.getPropertyPrefix();
                lo.setSelected(turnOn);
                if (turnOn) {
                    if (this.zfi.getLayers().contains(layerMarker)) continue;
                    this.zfi.getLayers().add(layerMarker);
                    continue;
                }
                this.zfi.getLayers().remove(layerMarker);
            }
            this.setInclude(!this.zfi.getLayers().isEmpty());
        }
    }

    public void matchBounds(List<BoundsObject> bounds) {
        this.boundsModel.clear();
        this.boundaries.clear();
        for (BoundsObject bo : bounds) {
            BoundsObject copy = bo.clone();
            this.boundsModel.addElement(copy);
            this.boundaries.add(bo.bounds);
        }
    }

    protected boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean active) {
        this.active = active;
    }

    public boolean isInclude() {
        return this.include;
    }

    public void setInclude(boolean include) {
        this.include = include;
    }

    ZoomLevelMaker getZoomLevelMaker() {
        return this.zfi;
    }

    void setZoomLevelMaker(ZoomLevelMaker zfi) {
        this.zfi = zfi;
    }

    public void handleBoundary(OMGraphic omg, OMAction action) {
        this.boundaries.doAction(omg, action);
        this.boundsModel.clear();
        int count = 1;
        for (OMGraphic omr : this.boundaries) {
            if (!(omr instanceof OMRect)) continue;
            String bounding_rectangle = this.i18n.get(ZoomLevelMakerFace.class, "bounding_rectangle", "Bounding Rectangle");
            this.boundsModel.addElement(new BoundsObject((OMRect)omr, bounding_rectangle + " " + count++));
        }
    }

    protected boolean generate(Projection proj) {
        if (this.boundaries != null) {
            return this.boundaries.generate(proj);
        }
        return false;
    }

    protected void paintBoundaries(Graphics graphics) {
        if (this.boundaries != null) {
            this.boundaries.render(graphics);
        }
    }

    public ImageIcon createImageIcon(String path) {
        URL imgURL = ZoomLevelMakerFace.class.getClassLoader().getResource("com/bbn/openmap/dataAccess/mapTile/" + path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    private class ListMouseListener
    extends MouseAdapter {
        private ListMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            int index;
            if (e.getClickCount() == 2 && (index = ZoomLevelMakerFace.this.boundsList.locationToIndex(e.getPoint())) != -1) {
                BoundsObject selected = (BoundsObject)ZoomLevelMakerFace.this.boundsList.getSelectedValue();
                ZoomLevelMakerFace.this.organizer.edit(selected.bounds, null);
            }
        }
    }

    private final class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                boolean somethingSelected = ZoomLevelMakerFace.this.boundsList.getSelectedIndex() != -1;
                ZoomLevelMakerFace.this.editBoundaryButton.setEnabled(somethingSelected);
                ZoomLevelMakerFace.this.deleteBoundaryButton.setEnabled(somethingSelected);
            }
        }
    }

    public class LayerObject
    extends JCheckBox {
        private static final long serialVersionUID = 1L;
        protected Layer layer;

        public LayerObject(Layer layer) {
            super(layer.getName(), layer.isVisible());
            this.layer = layer;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    String pp = LayerObject.this.getLayer().getPropertyPrefix();
                    if (((JCheckBox)ae.getSource()).isSelected()) {
                        if (!ZoomLevelMakerFace.this.zfi.getLayers().contains(pp)) {
                            ZoomLevelMakerFace.this.zfi.getLayers().add(pp);
                        }
                    } else {
                        ZoomLevelMakerFace.this.zfi.getLayers().remove(pp);
                    }
                    if (ZoomLevelMakerFace.this.active && ZoomLevelMakerFace.this.organizer != null) {
                        ZoomLevelMakerFace.this.organizer.shuffleLayers(ZoomLevelMakerFace.this);
                        ZoomLevelMakerFace.this.setInclude(ZoomLevelMakerFace.this.zfi.getLayers() != null && !ZoomLevelMakerFace.this.zfi.getLayers().isEmpty());
                    }
                }
            });
        }

        Layer getLayer() {
            return this.layer;
        }

        public String toString() {
            return this.layer.getName();
        }
    }

    public class BoundsObject
    implements Cloneable {
        protected OMRect bounds;
        protected String name;

        public BoundsObject(OMRect rect, String displayName) {
            this.bounds = rect;
            this.name = displayName;
        }

        public String toString() {
            return this.name;
        }

        public BoundsObject clone() {
            OMRect copy = new OMRect(this.bounds.getNorthLat(), this.bounds.getWestLon(), this.bounds.getSouthLat(), this.bounds.getEastLon(), 2);
            DrawingAttributes atts = DrawingAttributes.getDefaultClone();
            atts.setFrom(this.bounds);
            atts.setTo(copy);
            return new BoundsObject(this.bounds, this.name);
        }
    }

    private final class BoundsListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;

        private BoundsListModel() {
        }

        public int getSize() {
            return ZoomLevelMakerFace.this.boundsObjectList.size();
        }

        public Object getElementAt(int index) {
            return ZoomLevelMakerFace.this.boundsObjectList.get(index);
        }

        public void editElement(int index) {
            this.fireContentsChanged(this, index, index);
        }

        public void insertElement(BoundsObject obj, int index) {
            ZoomLevelMakerFace.this.boundsObjectList.add(index, obj);
            this.fireIntervalAdded(this, index, index);
        }

        public void addElement(BoundsObject obj) {
            int index = this.getSize();
            ZoomLevelMakerFace.this.boundsObjectList.add(obj);
            this.fireIntervalAdded(this, index, index);
        }

        public BoundsObject removeElementAt(int index) {
            BoundsObject obj = ZoomLevelMakerFace.this.boundsObjectList.remove(index);
            this.fireIntervalRemoved(this, index, index);
            return obj;
        }

        public void clear() {
            int size = ZoomLevelMakerFace.this.boundsObjectList.size();
            ZoomLevelMakerFace.this.boundsObjectList.clear();
            this.fireIntervalRemoved(this, 0, size);
        }
    }
}

