/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.dataAccess.mapTile.MapTileCoordinateTransform;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.proj.coords.MercatorUVGCT;
import java.awt.geom.Point2D;

public class TMSMapTileCoordinateTransform
implements MapTileCoordinateTransform {
    protected MercatorUVGCT transform = new MercatorUVGCT.TMS(0);

    public Point2D latLonToTileUV(Point2D latlon, int zoom) {
        return this.latLonToTileUV(latlon, zoom, null);
    }

    public Point2D latLonToTileUV(Point2D latlon, int zoom, Point2D ret) {
        if (ret == null) {
            ret = new Point2D.Double();
        }
        ret.setLocation((latlon.getX() + 180.0) / 360.0 * Math.pow(2.0, zoom), Math.pow(2.0, zoom) - (1.0 - Math.log(Math.tan(latlon.getY() * Math.PI / 180.0) + 1.0 / Math.cos(latlon.getY() * Math.PI / 180.0)) / Math.PI) / 2.0 * Math.pow(2.0, zoom));
        return ret;
    }

    public Point2D tileUVToLatLon(Point2D tileUV, int zoom) {
        return this.tileUVToLatLon(tileUV, zoom, null);
    }

    public LatLonPoint tileUVToLatLon(Point2D tileUV, int zoom, LatLonPoint ret) {
        if (ret == null) {
            ret = new LatLonPoint.Double();
        }
        ret.setLocation(360.0 / Math.pow(2.0, zoom) * tileUV.getX() - 180.0, -90.0 + 114.59155902616465 * Math.atan(Math.exp(Math.PI * -2 * -(tileUV.getY() - Math.pow(2.0, zoom)) / Math.pow(2.0, zoom) + Math.PI)));
        return ret;
    }

    public int[] getTileBoundsForProjection(Point2D upperLeft, Point2D lowerRight, int zoomLevel) {
        int uvup;
        Point2D uvul = this.latLonToTileUV(upperLeft, zoomLevel);
        Point2D uvlr = this.latLonToTileUV(lowerRight, zoomLevel);
        int[] ret = new int[4];
        int uvleft = (int)Math.floor(uvul.getX());
        int uvright = (int)Math.ceil(uvlr.getX());
        int uvbottom = (int)Math.floor(uvlr.getY()) - 1;
        if (uvbottom < 0) {
            uvbottom = 0;
        }
        ret[0] = uvup = (int)Math.ceil(uvul.getY()) + 1;
        ret[1] = uvleft;
        ret[2] = uvbottom;
        ret[3] = uvright;
        return ret;
    }

    public static void main(String[] args) {
        for (int i = 9; i < 15; ++i) {
            System.out.println("Zoom Level " + i);
            TMSMapTileCoordinateTransform tms = new TMSMapTileCoordinateTransform();
            LatLonPoint llp = new LatLonPoint.Double(0.0, 0.0);
            Point2D uv = tms.latLonToTileUV(llp, i);
            System.out.println(" " + llp + " transformed to " + uv);
            llp = tms.tileUVToLatLon(uv, i, llp);
            System.out.println(" " + uv + " transformed to " + llp);
            llp = new LatLonPoint.Double(41.389, 2.169);
            uv = tms.latLonToTileUV(llp, i);
            System.out.println(" " + llp + " transformed to " + uv);
            llp = tms.tileUVToLatLon(uv, i, llp);
            System.out.println(" " + uv + " transformed to " + llp);
        }
    }

    public boolean isYDirectionUp() {
        return true;
    }

    public MercatorUVGCT getTransform(int zoomLevel) {
        return new MercatorUVGCT.TMS(zoomLevel);
    }
}

