/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.dataAccess.mapTile.EmptyTileHandler;
import com.bbn.openmap.dataAccess.mapTile.MapTileCoordinateTransform;
import com.bbn.openmap.dataAccess.mapTile.MapTileFactory;
import com.bbn.openmap.dataAccess.mapTile.MapTileMaker;
import com.bbn.openmap.dataAccess.mapTile.OSMMapTileCoordinateTransform;
import com.bbn.openmap.dataAccess.mapTile.ZoomLevelInfo;
import com.bbn.openmap.image.BufferedImageHelper;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMScalingRaster;
import com.bbn.openmap.omGraphics.OMTextLabeler;
import com.bbn.openmap.omGraphics.OMWarpingImage;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.ClasspathHacker;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.DataBounds;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.cacheHandler.CacheHandler;
import com.bbn.openmap.util.cacheHandler.CacheObject;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StandardMapTileFactory
extends CacheHandler
implements MapTileFactory,
PropertyConsumer {
    protected String prefix = null;
    protected static final Logger logger = Logger.getLogger("com.bbn.openmap.dataAccess.mapTile.StandardMapTileFactory");
    protected static final Logger mapTileLogger = Logger.getLogger("MAPTILE_DEBUGGING");
    public static final String ROOT_DIR_PROPERTY = "rootDir";
    public static final String FILE_EXT_PROPERTY = "fileExt";
    public static final String CACHE_SIZE_PROPERTY = "cacheSize";
    public static final String MTCTRANSFORM_PROPERTY = "mapTileTransform";
    public static final String EMPTY_TILE_HANDLER_PROPERTY = "emptyTileHandler";
    public static final String ZOOM_LEVEL_INFO_PROPERTY = "zoomLevelInfo";
    public static final String ZOOM_LEVEL_TILE_SIZE_PROPERTY = "zoomLevelTileSize";
    public static final String ROOT_DIR_PATH_PROPERTY = "rootDirPath";
    public static final String TILE_PROPERTIES = "tiles.omp";
    protected ZoomLevelInfo zoomLevelInfo = new ZoomLevelInfo();
    protected String rootDir;
    protected String fileExt = ".png";
    protected String rootDirProperty;
    protected EmptyTileHandler emptyTileHandler = null;
    protected boolean verbose = false;
    protected int zoomLevelTileSize = 350;
    protected Component repaintCallback;
    private boolean doExtraTiles = false;
    protected MapTileCoordinateTransform mtcTransform = new OSMMapTileCoordinateTransform();
    protected Projection lastProj;
    protected float[] scales;

    public StandardMapTileFactory() {
        super(100);
        this.verbose = logger.isLoggable(Level.FINE);
    }

    public StandardMapTileFactory(Component layer, String rootDir, String tileFileExt) {
        super(100);
        this.setRootDir(rootDir);
        this.setFileExt(tileFileExt);
        this.verbose = logger.isLoggable(Level.FINE);
        this.repaintCallback = layer;
    }

    public CacheObject load(Object key) {
        return null;
    }

    public void reset() {
        this.clear();
    }

    public CacheObject load(Object key, int x, int y, int zoomLevel, Projection proj) {
        if (key instanceof String) {
            String imagePath = (String)key;
            if (this.verbose) {
                logger.fine("fetching file for cache: " + imagePath);
            }
            try {
                URL imageURL = PropUtils.getResourceOrFileOrURL(imagePath);
                if (imageURL != null) {
                    BufferedImage bi = BufferedImageHelper.getBufferedImage(imageURL);
                    OMGraphic raster = this.createOMGraphicFromBufferedImage(bi, x, y, zoomLevel, proj);
                    if (raster != null) {
                        return new CacheObject(imagePath, raster);
                    }
                } else {
                    logger.fine("Can't find resource located at " + imagePath);
                }
            }
            catch (MalformedURLException e) {
                logger.fine("Can't find resource located at " + imagePath);
            }
            catch (InterruptedException e) {
                logger.fine("Reading the image file was interrupted: " + imagePath);
            }
        }
        return null;
    }

    protected OMGraphic createOMGraphicFromBufferedImage(BufferedImage bi, int x, int y, int zoomLevel, Projection proj) throws InterruptedException {
        OMGraphic raster = null;
        if (bi != null) {
            BufferedImage rasterImage = this.preprocessImage(bi, bi.getWidth(), bi.getHeight());
            raster = proj instanceof Mercator ? this.getTileMatchingProjectionType(rasterImage, x, y, zoomLevel) : this.getTileNotMatchingProjectionType(rasterImage, x, y, zoomLevel);
            if (mapTileLogger.isLoggable(Level.FINE)) {
                raster.putAttribute("Label", new OMTextLabeler("Tile: " + zoomLevel + "|" + x + "|" + y, 1));
                raster.setSelected(true);
            }
        }
        return raster;
    }

    protected OMGraphic getTileMatchingProjectionType(BufferedImage image, int x, int y, int zoomLevel) {
        Point2D.Double pnt = new Point2D.Double();
        ((Point2D)pnt).setLocation(x, y);
        Point2D tileUL = this.mtcTransform.tileUVToLatLon(pnt, zoomLevel);
        ((Point2D)pnt).setLocation(x + 1, y + 1);
        Point2D tileLR = this.mtcTransform.tileUVToLatLon(pnt, zoomLevel);
        if (this.verbose) {
            logger.fine("tile coords: " + tileUL + ", " + tileLR);
        }
        double x1 = Math.min(tileUL.getX(), tileLR.getX());
        double x2 = Math.max(tileUL.getX(), tileLR.getX());
        double y1 = Math.min(tileUL.getY(), tileLR.getY());
        double y2 = Math.max(tileUL.getY(), tileLR.getY());
        return new OMScalingRaster(y2, x1, y1, x2, (Image)image);
    }

    protected OMGraphic getTileNotMatchingProjectionType(BufferedImage image, int x, int y, int zoomLevel) {
        DataBounds dataBounds = new DataBounds(new Point(x, y), new Point(x + 1, y + 1));
        dataBounds.setyDirUp(this.mtcTransform.isYDirectionUp());
        return new OMWarpingImage(image, (GeoCoordTransformation)this.mtcTransform.getTransform(zoomLevel), dataBounds);
    }

    protected BufferedImage preprocessImage(Image origImage, int imageWidth, int imageHeight) throws InterruptedException {
        if (origImage instanceof BufferedImage) {
            return (BufferedImage)origImage;
        }
        return BufferedImageHelper.getBufferedImage(origImage, 0, 0, imageWidth, imageHeight, 2);
    }

    public Object get(Object key, int x, int y, int zoomLevel, Projection proj) {
        CacheObject ret = this.searchCache(key);
        if (ret != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("found tile (" + x + ", " + y + ") in cache");
            }
            return ret.obj;
        }
        ret = this.load(key, x, y, zoomLevel, proj);
        if (ret == null) {
            return null;
        }
        this.replaceLeastUsed(ret);
        return ret.obj;
    }

    public Object getFromCache(Object key, int x, int y, int zoomLevel) {
        CacheObject ret = this.searchCache(key);
        if (ret != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("found tile (" + x + ", " + y + ") in cache");
            }
            return ret.obj;
        }
        return null;
    }

    public CacheObject getEmptyTile(Object key, int x, int y, int zoomLevel, Projection proj) {
        block5: {
            EmptyTileHandler empTileHandler = this.getEmptyTileHandler();
            if (empTileHandler != null) {
                BufferedImage bi = empTileHandler.getImageForEmptyTile((String)key, x, y, zoomLevel, this.mtcTransform, proj);
                try {
                    OMGraphic raster = this.createOMGraphicFromBufferedImage(bi, x, y, zoomLevel, proj);
                    if (raster != null) {
                        Object labelObj;
                        if (mapTileLogger.isLoggable(Level.FINE) && (labelObj = raster.getAttribute("Label")) instanceof OMTextLabeler) {
                            OMTextLabeler label = (OMTextLabeler)labelObj;
                            label.setData("EMPTY " + label.getData());
                        }
                        return new CacheObject(key, raster);
                    }
                }
                catch (InterruptedException e) {
                    if (!logger.isLoggable(Level.FINE)) break block5;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public OMGraphicList getTiles(Projection proj) {
        return this.getTiles(proj, -1, new OMGraphicList());
    }

    public OMGraphicList getTiles(Projection proj, int zoomLevel) {
        return this.getTiles(proj, zoomLevel, new OMGraphicList());
    }

    public OMGraphicList getTiles(Projection proj, int zoomLevel, OMGraphicList list) {
        if (this.fileExt == null || this.rootDir == null) {
            logger.warning("No path to tile files provided (" + this.rootDir + "), or file extension (" + this.fileExt + ") not specified");
            return list;
        }
        if (this.lastProj == null || !proj.getClass().isAssignableFrom(this.lastProj.getClass())) {
            logger.fine("Clearing out cache for new projection type");
            this.clear();
        }
        this.lastProj = proj;
        if (zoomLevel < 0) {
            zoomLevel = this.getZoomLevelForProj(proj);
            if (this.verbose) {
                logger.fine("Best zoom level calculated at: " + zoomLevel);
            }
        }
        if (zoomLevel >= 0) {
            Point2D datelinePnt;
            double dlx;
            if (zoomLevel == 0) {
                ++zoomLevel;
            }
            this.zoomLevelInfo.setZoomLevel(zoomLevel);
            Object upperLeft = proj.getUpperLeft();
            Object lowerRight = proj.getLowerRight();
            int[] uvBounds = this.mtcTransform.getTileBoundsForProjection((Point2D)upperLeft, (Point2D)lowerRight, zoomLevel);
            int uvup = uvBounds[0];
            int uvleft = uvBounds[1];
            int uvbottom = uvBounds[2];
            int uvright = uvBounds[3];
            if (this.verbose) {
                logger.fine("for " + proj + ", fetching tiles between x(" + uvleft + ", " + uvright + ") y(" + uvup + ", " + uvbottom + ")");
            }
            boolean dateline = (dlx = (datelinePnt = proj.forward(new LatLonPoint.Double(((Point2D)upperLeft).getY(), 180.0))).getX()) > 0.0 & dlx < (double)proj.getWidth();
            logger.fine("Long(180) located at " + dlx);
            if (!dateline) {
                this.getTiles(uvleft, uvright, uvup, uvbottom, this.zoomLevelInfo, proj, list);
            } else {
                logger.fine("handling DATELINE");
                this.getTiles(uvleft, (int)Math.pow(2.0, zoomLevel), uvup, uvbottom, this.zoomLevelInfo, proj, list);
                this.getTiles(0, uvright, uvup, uvbottom, this.zoomLevelInfo, proj, list);
            }
        }
        return list;
    }

    protected void getTiles(int uvleft, int uvright, int uvup, int uvbottom, ZoomLevelInfo zoomLevelInfo, Projection proj, OMGraphicList list) {
        int y;
        int x;
        int edgeTileCount;
        if (this.verbose) {
            logger.fine("for zoom level: " + zoomLevelInfo.getZoomLevel() + ", screen covers uv coords [t:" + uvup + ", l:" + uvleft + ", b:" + uvbottom + ", r:" + uvright + "]");
        }
        if (zoomLevelInfo.getZoomLevel() == 0) {
            logger.fine("got one tile, OM can't draw a single tile covering the earth. Sorry.");
        }
        ArrayList<LoadObj> reloads = new ArrayList<LoadObj>();
        int zoomLevel = zoomLevelInfo.getZoomLevel();
        boolean isMercator = proj instanceof Mercator;
        int uvleftM = Math.min(uvleft, uvright);
        int uvrightM = Math.max(uvleft, uvright);
        int uvupM = Math.min(uvbottom, uvup);
        int uvbottomM = Math.max(uvbottom, uvup);
        for (int x2 = uvleftM; x2 < uvrightM; ++x2) {
            for (int y2 = uvupM; y2 < uvbottomM; ++y2) {
                boolean rightOMGraphicType;
                if (Thread.currentThread().isInterrupted()) {
                    logger.fine("Detected interruption in standard loop, thread " + Thread.currentThread().getName());
                    return;
                }
                String imagePath = zoomLevelInfo.formatImageFilePath(this.rootDir, x2, y2) + this.fileExt;
                OMGraphic tileGraphic = (OMGraphic)this.getFromCache(imagePath, x2, y2, zoomLevel);
                boolean bl = rightOMGraphicType = tileGraphic instanceof OMScalingRaster && isMercator || tileGraphic instanceof OMWarpingImage && !isMercator;
                if (tileGraphic != null) {
                    if (mapTileLogger.isLoggable(Level.FINE)) {
                        tileGraphic.putAttribute("Label", new OMTextLabeler("Tile: " + zoomLevel + "|" + x2 + "|" + y2, 1));
                        tileGraphic.setSelected(true);
                    }
                    tileGraphic.generate(proj);
                    list.add(tileGraphic);
                    continue;
                }
                reloads.add(new LoadObj(imagePath, x2, y2, zoomLevel));
            }
        }
        if (this.verbose) {
            logger.fine("found " + list.size() + " frames in cache, loading " + reloads.size() + " others now...");
        }
        if (this.repaintCallback != null) {
            this.repaintCallback.repaint();
        }
        for (LoadObj reload : reloads) {
            this.handleLoad(reload.imagePath, reload.x, reload.y, reload.zoomLevel, proj, list);
        }
        if (this.verbose) {
            logger.fine("finished loading " + reloads.size() + " frames from source for screen" + (this.doExtraTiles ? ", moving to off-screen frames..." : ""));
        }
        if (!this.doExtraTiles) {
            return;
        }
        int x1 = uvleft;
        int y1 = uvup;
        int x2 = uvright;
        int y2 = uvbottom;
        boolean top = false;
        boolean left = false;
        boolean right = false;
        boolean bottom = false;
        if (x1 > 0) {
            --x1;
            left = true;
        }
        if (y1 > 0) {
            --y1;
            top = true;
        }
        if (x2 < (edgeTileCount = zoomLevelInfo.getEdgeTileCount()) - 1) {
            ++x2;
            right = true;
        }
        if (y2 < edgeTileCount - 1) {
            ++y2;
            bottom = true;
        }
        if (top && left) {
            this.handleLoad(x1, y1, zoomLevel, proj, list);
        }
        if (bottom && left) {
            this.handleLoad(x1, y2, zoomLevel, proj, list);
        }
        if (bottom && right) {
            this.handleLoad(x2, y2, zoomLevel, proj, list);
        }
        if (top && right) {
            this.handleLoad(x2, y1, zoomLevel, proj, list);
        }
        if (top) {
            for (x = uvleft; x < uvright; ++x) {
                this.handleLoad(x, y1, zoomLevel, proj, list);
            }
        }
        if (bottom) {
            for (x = uvleft; x < uvright; ++x) {
                this.handleLoad(x, y2, zoomLevel, proj, list);
            }
        }
        if (right) {
            for (y = uvup; y < uvbottom; ++y) {
                this.handleLoad(x2, y, zoomLevel, proj, list);
            }
        }
        if (left) {
            for (y = uvup; y < uvbottom; ++y) {
                this.handleLoad(x1, y, zoomLevel, proj, list);
            }
        }
        if (this.verbose) {
            logger.fine("finished loading all tiles (" + list.size() + ")");
        }
    }

    private void handleLoad(String imagePath, int x, int y, int zoomLevel, Projection proj, OMGraphicList list) {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        CacheObject ret = this.load(imagePath, x, y, zoomLevel, proj);
        if (ret == null) {
            ret = this.getEmptyTile(imagePath, x, y, zoomLevel, proj);
        }
        if (ret != null) {
            this.replaceLeastUsed(ret);
            OMGraphic raster = (OMGraphic)ret.obj;
            if (raster != null) {
                raster.generate(proj);
                list.add(raster);
                if (logger.isLoggable(Level.FINE)) {
                    raster.putAttribute("Tooltip", imagePath);
                }
                if (this.repaintCallback != null) {
                    this.repaintCallback.repaint();
                }
            }
        }
    }

    private void handleLoad(int x, int y, int zoomLevel, Projection proj, OMGraphicList list) {
        String imagePath = this.zoomLevelInfo.formatImageFilePath(this.rootDir, x, y) + this.fileExt;
        this.handleLoad(imagePath, x, y, zoomLevel, proj, list);
    }

    public int getZoomLevelForProj(Projection proj) {
        int low = 1;
        int high = 20;
        OSMMapTileCoordinateTransform mtct = new OSMMapTileCoordinateTransform();
        if (this.scales == null) {
            this.scales = MapTileMaker.getScalesForZoomLevels(proj, 0, high);
        }
        float currentScale = proj.getScale();
        int ret = low;
        for (int currentZoom = low; currentZoom <= high; ++currentZoom) {
            Point2D nttc = mtct.latLonToTileUV((Point2D)proj.getCenter(), currentZoom);
            double nttcX = Math.floor(nttc.getX());
            double nttcY = Math.floor(nttc.getY());
            Point2D originLLUL = mtct.tileUVToLatLon(new Point2D.Double(nttcX, nttcY), currentZoom);
            Point2D originLLLR = mtct.tileUVToLatLon(new Point2D.Double(nttcX + 1.0, nttcY + 1.0), currentZoom);
            Point2D projUVUL = proj.forward(originLLUL);
            Point2D projLLLR = proj.forward(originLLLR);
            if (!(Math.abs(projUVUL.getX() - projLLLR.getX()) <= (double)this.zoomLevelTileSize)) continue;
            return currentZoom;
        }
        return ret;
    }

    public Component getRepaintCallback() {
        return this.repaintCallback;
    }

    public void setRepaintCallback(Component callback) {
        this.repaintCallback = callback;
    }

    public Properties getProperties(Properties getList) {
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        getList.put(prefix + ROOT_DIR_PROPERTY, PropUtils.unnull(this.rootDirProperty));
        getList.put(prefix + FILE_EXT_PROPERTY, PropUtils.unnull(this.fileExt));
        getList.put(prefix + CACHE_SIZE_PROPERTY, Integer.toString(this.getCacheSize()));
        getList.put(prefix + MTCTRANSFORM_PROPERTY, this.mtcTransform.getClass().toString());
        if (this.emptyTileHandler != null) {
            getList.put(prefix + EMPTY_TILE_HANDLER_PROPERTY, this.emptyTileHandler.getClass().toString());
            if (this.emptyTileHandler instanceof PropertyConsumer) {
                ((PropertyConsumer)((Object)this.emptyTileHandler)).getProperties(getList);
            }
        }
        if (this.zoomLevelInfo != null && !this.zoomLevelInfo.getClass().equals(ZoomLevelInfo.class)) {
            getList.put(prefix + ZOOM_LEVEL_INFO_PROPERTY, this.zoomLevelInfo.getClass().getName());
        }
        getList.put(prefix + ZOOM_LEVEL_TILE_SIZE_PROPERTY, Integer.toString(this.zoomLevelTileSize));
        return getList;
    }

    public Properties getPropertyInfo(Properties list) {
        I18n i18n = Environment.getI18n();
        PropUtils.setI18NPropertyInfo(i18n, list, StandardMapTileFactory.class, ROOT_DIR_PROPERTY, "Tile Directory", "Root directory containing image tiles", "com.bbn.openmap.util.propertyEditor.DirectoryPropertyEditor");
        PropUtils.setI18NPropertyInfo(i18n, list, StandardMapTileFactory.class, FILE_EXT_PROPERTY, "Image File Extension", "Extension of image files (.jpg, .png, etc)", null);
        PropUtils.setI18NPropertyInfo(i18n, list, StandardMapTileFactory.class, CACHE_SIZE_PROPERTY, "Cache Size", "Number of tile images held in memory", null);
        PropUtils.setI18NPropertyInfo(i18n, list, StandardMapTileFactory.class, ZOOM_LEVEL_TILE_SIZE_PROPERTY, "Zoom Level Tile Size", "The maximum pixel size of a tile before switching to a higher zoom level (350 is default)", null);
        return list;
    }

    public String getPropertyPrefix() {
        return this.prefix;
    }

    public void setProperties(Properties setList) {
        this.setProperties(null, setList);
    }

    public void setProperties(String prefix, Properties setList) {
        Object obj;
        String zoomLevelInfoString;
        Object obj2;
        String emptyTileHandlerString;
        Object obj3;
        String mapTileCoordinateTransform;
        String tmpFileExt;
        this.setPropertyPrefix(prefix);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String rootDirectory = setList.getProperty(prefix + ROOT_DIR_PROPERTY);
        if (rootDirectory != null) {
            this.setRootDir(rootDirectory);
        }
        if ((tmpFileExt = setList.getProperty(prefix + FILE_EXT_PROPERTY)) != null) {
            this.setFileExt(tmpFileExt);
        }
        if ((mapTileCoordinateTransform = setList.getProperty(prefix + MTCTRANSFORM_PROPERTY)) != null && (obj3 = ComponentFactory.create(mapTileCoordinateTransform)) instanceof MapTileCoordinateTransform) {
            this.setMtcTransform((MapTileCoordinateTransform)obj3);
        }
        if ((emptyTileHandlerString = setList.getProperty(prefix + EMPTY_TILE_HANDLER_PROPERTY)) != null && (obj2 = ComponentFactory.create(emptyTileHandlerString, prefix, setList)) instanceof EmptyTileHandler) {
            this.setEmptyTileHandler((EmptyTileHandler)obj2);
        }
        if ((zoomLevelInfoString = setList.getProperty(prefix + ZOOM_LEVEL_INFO_PROPERTY)) != null && (obj = ComponentFactory.create(zoomLevelInfoString, prefix, setList)) instanceof ZoomLevelInfo) {
            this.setZoomLevelInfo((ZoomLevelInfo)obj);
        }
        super.resetCache(PropUtils.intFromProperties(setList, prefix + CACHE_SIZE_PROPERTY, this.getCacheSize()));
        this.zoomLevelTileSize = PropUtils.intFromProperties(setList, prefix + ZOOM_LEVEL_TILE_SIZE_PROPERTY, this.zoomLevelTileSize);
    }

    public void setPropertyPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String rootDirectory) {
        if (rootDirectory != null) {
            if (rootDirectory.endsWith("jar")) {
                this.rootDirProperty = rootDirectory;
                String jarFileNames = rootDirectory;
                boolean tilesFileFound = false;
                Vector<String> jarNames = PropUtils.parseMarkers(jarFileNames, ";");
                for (String jarName : jarNames) {
                    boolean jarFileFound = false;
                    try {
                        URL jarURL;
                        if (!tilesFileFound && (jarURL = PropUtils.getResourceOrFileOrURL(jarName)) != null) {
                            jarFileFound = true;
                            JarInputStream jarStream = new JarInputStream(jarURL.openStream());
                            JarEntry jarEntry = null;
                            while ((jarEntry = jarStream.getNextJarEntry()) != null) {
                                String entryName = jarEntry.getName();
                                if (!entryName.equals(TILE_PROPERTIES)) continue;
                                byte[] readBytes = new byte[100];
                                byte[] contentBytes = new byte[]{};
                                int numRead = 0;
                                while ((numRead = jarStream.read(readBytes, 0, readBytes.length)) > 0) {
                                    byte[] tmpBytes = new byte[numRead + contentBytes.length];
                                    System.arraycopy(contentBytes, 0, tmpBytes, 0, contentBytes.length);
                                    System.arraycopy(readBytes, 0, tmpBytes, contentBytes.length, numRead);
                                    contentBytes = tmpBytes;
                                }
                                ByteArrayInputStream bais = new ByteArrayInputStream(contentBytes);
                                this.configureFromProperties(bais, rootDirectory);
                                bais.close();
                                jarStream.closeEntry();
                                tilesFileFound = true;
                                break;
                            }
                            jarStream.close();
                        }
                        if (jarFileFound) {
                            logger.fine("adding " + jarName + " to classpath");
                            ClasspathHacker.addFile(jarName);
                            continue;
                        }
                        logger.fine("can't find " + jarName + ", not adding to classpath");
                    }
                    catch (IOException ioe) {
                        logger.warning("couldn't add map data jar file: " + jarName);
                    }
                }
            } else {
                File tileProps = new File(rootDirectory, TILE_PROPERTIES);
                String currentRootDirectory = this.rootDir;
                String currentRootDirProperty = this.rootDirProperty;
                if (tileProps.exists()) {
                    try {
                        this.configureFromProperties(tileProps.toURI().toURL().openStream(), rootDirectory);
                    }
                    catch (MalformedURLException murle) {
                        logger.warning("tile file for " + rootDirectory + " couldn't be read: " + tileProps.getAbsolutePath());
                    }
                    catch (IOException ioe) {
                        logger.warning("tile file for " + rootDirectory + " couldn't be read");
                    }
                }
                if (currentRootDirectory == null && this.rootDir == null) {
                    this.rootDir = rootDirectory;
                }
                if (currentRootDirProperty == null) {
                    this.rootDirProperty = rootDirectory;
                }
            }
        } else {
            this.rootDir = rootDirectory;
            this.rootDirProperty = rootDirectory;
        }
    }

    protected void configureFromProperties(InputStream is, String rootDirectory) throws IOException {
        Properties props = new Properties();
        props.load(is);
        props.put(ROOT_DIR_PATH_PROPERTY, rootDirectory);
        String oldPrefix = this.getPropertyPrefix();
        this.setProperties(null, props);
        this.setPropertyPrefix(oldPrefix);
    }

    public String getFileExt() {
        return this.fileExt;
    }

    public void setFileExt(String fileExt) {
        this.fileExt = fileExt != null && fileExt.startsWith(".") ? fileExt : "." + fileExt;
    }

    public ZoomLevelInfo getZoomLevelInfo() {
        return this.zoomLevelInfo;
    }

    public void setZoomLevelInfo(ZoomLevelInfo zoomLevelInfo) {
        if (zoomLevelInfo != null) {
            this.zoomLevelInfo = zoomLevelInfo;
        }
    }

    public MapTileCoordinateTransform getMtcTransform() {
        return this.mtcTransform;
    }

    public void setMtcTransform(MapTileCoordinateTransform mtcTransform) {
        if (mtcTransform == null) {
            mtcTransform = new OSMMapTileCoordinateTransform();
        }
        this.mtcTransform = mtcTransform;
    }

    public EmptyTileHandler getEmptyTileHandler() {
        return this.emptyTileHandler;
    }

    public void setEmptyTileHandler(EmptyTileHandler emptyTileHandler) {
        this.emptyTileHandler = emptyTileHandler;
    }

    class LoadObj {
        String imagePath;
        int x;
        int y;
        int zoomLevel;

        LoadObj(String p, int x, int y, int z) {
            this.imagePath = p;
            this.x = x;
            this.y = y;
            this.zoomLevel = z;
        }
    }
}

