/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.asrp;

import com.bbn.openmap.dataAccess.asrp.GeneralASRPFile;
import com.bbn.openmap.dataAccess.iso8211.DDFModule;
import com.bbn.openmap.dataAccess.iso8211.DDFRecord;
import com.bbn.openmap.util.Debug;
import java.io.IOException;

public class QualityFile
extends GeneralASRPFile {
    public static final String SECURITY_AND_RELEASE = "QSR";
    public static final String UP_TO_DATENESS = "QUV";
    public static final String COLOUR_CODE_ID = "COL";
    public static final String OTHER_QUALITY_INFORMATION = "QOI";
    public static final String HORIZONTAL_ACCURACY = "ASH";
    public static final String BOUNDING_POLYGON_COORDINATES = "RCI";
    public static final String VERTICAL_ACCURACY = "ASV";

    public QualityFile(String fileName) throws IOException {
        DDFModule mod = this.load(fileName);
        if (mod != null) {
            DDFRecord record;
            while ((record = mod.readRecord()) != null) {
                this.loadField(record, SECURITY_AND_RELEASE, 0);
                this.loadField(record, UP_TO_DATENESS, 0);
                this.loadField(record, COLOUR_CODE_ID, 0);
                this.loadField(record, OTHER_QUALITY_INFORMATION, 0);
                this.loadField(record, HORIZONTAL_ACCURACY, 0);
                this.loadField(record, BOUNDING_POLYGON_COORDINATES, 0);
                this.loadField(record, VERTICAL_ACCURACY, 0);
            }
        }
    }

    public static void main(String[] argv) {
        Debug.init();
        if (argv.length < 1) {
            Debug.output("Usage: QualityFile filename");
        }
        try {
            QualityFile thf = new QualityFile(argv[0]);
            thf.dumpFields();
        }
        catch (IOException ioe) {
            Debug.error(ioe.getMessage());
        }
        System.exit(0);
    }
}

