/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.app;

import com.bbn.openmap.PropertyHandler;
import com.bbn.openmap.app.OpenMap;
import com.bbn.openmap.gui.OverlayMapPanel;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import java.io.IOException;
import java.net.MalformedURLException;

public class Main
extends OpenMap {
    public Main() {
        this(null);
    }

    public Main(PropertyHandler propertyHandler) {
        super(propertyHandler);
    }

    protected void configureMapPanel(PropertyHandler propertyHandler) {
        OverlayMapPanel mapPanel = new OverlayMapPanel(propertyHandler, true);
        mapPanel.create();
        this.mapPanel = mapPanel;
    }

    public static PropertyHandler configurePropertyHandler(String propertiesFile) {
        PropertyHandler propertyHandler = null;
        try {
            PropertyHandler.Builder builder = new PropertyHandler.Builder().setPropertiesFile(propertiesFile).setPropertyPrefix("main");
            propertyHandler = new PropertyHandler(builder);
        }
        catch (MalformedURLException murle) {
            Debug.error(murle.getMessage());
            murle.printStackTrace();
            propertyHandler = new PropertyHandler();
        }
        catch (IOException ioe) {
            Debug.error(ioe.getMessage());
            ioe.printStackTrace();
            propertyHandler = new PropertyHandler();
        }
        return propertyHandler;
    }

    public static Main create() {
        return new Main(null);
    }

    public static Main create(String propertiesFile) {
        Debug.init();
        return new Main(Main.configurePropertyHandler(propertiesFile));
    }

    public static void main(String[] args) {
        ArgParser ap = new ArgParser("Main");
        String propArgs = null;
        ap.add("properties", "A resource, file path or URL to properties file\n Ex: http://myhost.com/xyz.props or file:/myhome/abc.pro\n See Java Documentation for java.net.URL class for more details", 1);
        ap.parse(args);
        String[] arg = ap.getArgValues("properties");
        if (arg != null) {
            propArgs = arg[0];
        }
        Main.create(propArgs);
    }
}

