/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.ProjectionPainter;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.event.InfoDisplayEvent;
import com.bbn.openmap.event.InfoDisplayListener;
import com.bbn.openmap.event.LayerStatusEvent;
import com.bbn.openmap.event.LayerStatusListener;
import com.bbn.openmap.event.ListenerSupport;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.gui.ScrollPaneWindowSupport;
import com.bbn.openmap.gui.WindowSupport;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.propertyEditor.Inspector;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.beans.Beans;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Layer
extends JComponent
implements ProjectionListener,
ProjectionPainter,
BeanContextChild,
BeanContextMembershipListener,
PropertyConsumer,
ActionListener {
    private static final long serialVersionUID = 1L;
    protected static final String SWING_PACKAGE = Layer.getPackage(JComponent.class);
    public static final String PrettyNameProperty = "prettyName";
    public static final String AddToBeanContextProperty = "addToBeanContext";
    public static final String AddAsBackgroundProperty = "background";
    public static final String RemovableProperty = "removable";
    public static final String MinScaleProperty = "minScale";
    public static final String MaxScaleProperty = "maxScale";
    public static final String AutoPaletteProperty = "autoPalette";
    public static final String DisplayPaletteCmd = "displayPaletteCmd";
    public static final String HidePaletteCmd = "hidePaletteCmd";
    public static final String DisplayPropertiesCmd = "displayPropertiesCmd";
    public static final String RedrawCmd = "redrawCmd";
    public static final String DataPathPrefixProperty = "dataPathPrefix";
    public static final String TransformProperty = "transform";
    private final ListenerSupport<InfoDisplayListener> IDListeners = new ListenerSupport(this);
    private final ListenerSupport<LayerStatusListener> lsListeners = new ListenerSupport(this);
    protected String propertyPrefix = null;
    protected boolean addToBeanContext = true;
    protected boolean addAsBackground = false;
    protected boolean removable = true;
    protected boolean autoPalette = false;
    protected float minScale = Float.MIN_VALUE;
    protected float maxScale = Float.MAX_VALUE;
    private Projection projection = null;
    protected transient WindowSupport windowSupport;
    protected transient ComponentListener paletteListener;
    protected transient Container palette;
    protected transient BeanContextChildSupport beanContextChildSupport = new BeanContextChildSupport();
    protected transient I18n i18n = Environment.getI18n();
    private Icon icon = null;
    protected Hashtable attributes;
    protected GeoCoordTransformation coordTransform;
    protected ListenerSupport<ComponentListener> localHackList;
    protected boolean doHack = true;

    protected static String getPackage(Class c) {
        String className = c.getName();
        int lastDot = className.lastIndexOf(46);
        return className.substring(0, lastDot);
    }

    @Override
    public final void addMouseListener(MouseListener l) {
        String pkg = Layer.getPackage(l.getClass());
        if (!(Beans.isDesignTime() || pkg.equals(SWING_PACKAGE) || pkg.startsWith(SWING_PACKAGE) || pkg.startsWith("com.sun.java.accessibility.util"))) {
            throw new IllegalArgumentException("This operation is disallowed because the package \"" + Layer.getPackage(l.getClass()) + "\" is not in the swing package (\"" + SWING_PACKAGE + "\").");
        }
        super.addMouseListener(l);
    }

    @Override
    public void setProperties(Properties props) {
        this.setProperties(this.getPropertyPrefix(), props);
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        this.setLayerProperties(prefix, props);
    }

    protected void setLayerProperties(String prefix, Properties props) {
        String transClassName;
        String prettyName = PrettyNameProperty;
        this.setPropertyPrefix(prefix);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        prettyName = realPrefix + PrettyNameProperty;
        String defaultName = this.getName();
        if (defaultName == null) {
            defaultName = "Anonymous";
        }
        this.setName(props.getProperty(prettyName, defaultName));
        this.setAddToBeanContext(PropUtils.booleanFromProperties(props, realPrefix + AddToBeanContextProperty, this.addToBeanContext));
        this.setAddAsBackground(PropUtils.booleanFromProperties(props, realPrefix + AddAsBackgroundProperty, this.addAsBackground));
        this.setRemovable(PropUtils.booleanFromProperties(props, realPrefix + RemovableProperty, this.removable));
        this.autoPalette = PropUtils.booleanFromProperties(props, realPrefix + AutoPaletteProperty, this.autoPalette);
        this.setMinScale(PropUtils.floatFromProperties(props, realPrefix + MinScaleProperty, this.getMinScale()));
        this.setMaxScale(PropUtils.floatFromProperties(props, realPrefix + MaxScaleProperty, this.getMaxScale()));
        String dataPathPrefix = props.getProperty(realPrefix + DataPathPrefixProperty, "");
        if (dataPathPrefix.length() > 0) {
            this.putAttribute(DataPathPrefixProperty, dataPathPrefix);
        }
        if ((transClassName = props.getProperty(realPrefix + TransformProperty)) != null) {
            try {
                this.coordTransform = (GeoCoordTransformation)ComponentFactory.create(transClassName, realPrefix + TransformProperty, props);
            }
            catch (ClassCastException cce) {
                // empty catch block
            }
        }
    }

    @Override
    public void setName(String name) {
        LayerHandler lh;
        super.setName(name);
        BeanContext bc = this.getBeanContext();
        if (bc instanceof MapHandler && (lh = (LayerHandler)((MapHandler)bc).get("com.bbn.openmap.LayerHandler")) != null) {
            lh.setLayers();
        }
    }

    @Override
    public Properties getProperties(Properties props) {
        String dataPathPrefix;
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this.propertyPrefix);
        props.put(prefix + "class", this.getClass().getName());
        String prettyName = this.getName();
        if (prettyName != null) {
            props.put(prefix + PrettyNameProperty, prettyName);
        }
        props.put(prefix + AutoPaletteProperty, new Boolean(this.autoPalette).toString());
        props.put(prefix + AddAsBackgroundProperty, new Boolean(this.addAsBackground).toString());
        props.put(prefix + RemovableProperty, new Boolean(this.removable).toString());
        props.put(prefix + AddToBeanContextProperty, new Boolean(this.addToBeanContext).toString());
        if (this.getMinScale() != Float.MIN_VALUE) {
            props.put(prefix + MinScaleProperty, Float.toString(this.getMinScale()));
        }
        if (this.getMaxScale() != Float.MAX_VALUE) {
            props.put(prefix + MaxScaleProperty, Float.toString(this.getMaxScale()));
        }
        if ((dataPathPrefix = (String)this.getAttribute(DataPathPrefixProperty)) != null) {
            props.put(prefix + DataPathPrefixProperty, dataPathPrefix);
        }
        if (this.coordTransform instanceof PropertyConsumer) {
            ((PropertyConsumer)((Object)this.coordTransform)).getProperties(props);
        }
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        list.put("class", "Class Name used for Layer.");
        list.put("class.editor", "com.bbn.openmap.util.propertyEditor.NonEditablePropertyEditor");
        String internString = this.i18n.get(Layer.class, PrettyNameProperty, 3, "Presentable name for Layer");
        list.put(PrettyNameProperty, internString);
        internString = this.i18n.get(Layer.class, PrettyNameProperty, "Layer Name");
        list.put("prettyName.label", internString);
        list.put("prettyName.editor", "com.bbn.openmap.util.propertyEditor.NonEditablePropertyEditor");
        internString = this.i18n.get(Layer.class, AutoPaletteProperty, 3, "Flag to automatically display palette when properties are set");
        list.put(AutoPaletteProperty, internString);
        internString = this.i18n.get(Layer.class, AutoPaletteProperty, "Open Palette At Start");
        list.put("autoPalette.label", internString);
        list.put("autoPalette.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        internString = this.i18n.get(Layer.class, AddAsBackgroundProperty, 3, "Flag to use the layer as a background layer");
        list.put(AddAsBackgroundProperty, internString);
        internString = this.i18n.get(Layer.class, AddAsBackgroundProperty, "Background");
        list.put("background.label", internString);
        list.put("background.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        internString = this.i18n.get(Layer.class, RemovableProperty, 3, "Flag to allow layer to be deleted.");
        list.put(RemovableProperty, internString);
        internString = this.i18n.get(Layer.class, RemovableProperty, "Removable");
        list.put("removable.label", internString);
        list.put("removable.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        internString = this.i18n.get(Layer.class, AddToBeanContextProperty, 3, "Flag to give the layer access to all of the other application components.");
        list.put(AddToBeanContextProperty, internString);
        internString = this.i18n.get(Layer.class, AddToBeanContextProperty, "Add to MapHandler");
        list.put("addToBeanContext.label", internString);
        list.put("addToBeanContext.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        internString = this.i18n.get(Layer.class, MinScaleProperty, 3, "Minimum projection scale value that the layer will respond to.");
        list.put(MinScaleProperty, internString);
        internString = this.i18n.get(Layer.class, MinScaleProperty, "Minimum Scale Value");
        list.put("minScale.label", internString);
        internString = this.i18n.get(Layer.class, MaxScaleProperty, 3, "Maximum projection scale value that the layer will respond to.");
        list.put(MaxScaleProperty, internString);
        internString = this.i18n.get(Layer.class, MaxScaleProperty, "Maximum Scale Value");
        list.put("maxScale.label", internString);
        return list;
    }

    @Override
    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    @Override
    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void setProjection(Projection proj) {
        this.projection = proj;
    }

    public Projection setProjection(ProjectionEvent projEvent) {
        Projection newProjection = projEvent.getProjection();
        if (!newProjection.equals(this.getProjection())) {
            Projection clone = newProjection.makeClone();
            this.setProjection(clone);
            return clone;
        }
        return null;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public MapMouseListener getMapMouseListener() {
        return null;
    }

    public boolean hasGUI() {
        boolean hasGUI = false;
        try {
            Method guiMethod = this.getClass().getMethod("getGUI", null);
            hasGUI = guiMethod.getDeclaringClass() != Layer.class;
        }
        catch (Exception ex) {
            hasGUI = this.getGUI() != null;
        }
        return hasGUI;
    }

    public Component getGUI() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInfoDisplayListener(InfoDisplayListener aInfoDisplayListener) {
        ListenerSupport<InfoDisplayListener> listenerSupport = this.IDListeners;
        synchronized (listenerSupport) {
            this.IDListeners.add(aInfoDisplayListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInfoDisplayListener(InfoDisplayListener aInfoDisplayListener) {
        ListenerSupport<InfoDisplayListener> listenerSupport = this.IDListeners;
        synchronized (listenerSupport) {
            this.IDListeners.remove(aInfoDisplayListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRequestInfoLine(InfoDisplayEvent evt) {
        ListenerSupport<InfoDisplayListener> listenerSupport = this.IDListeners;
        synchronized (listenerSupport) {
            for (InfoDisplayListener listener : this.IDListeners) {
                listener.requestInfoLine(evt);
            }
        }
    }

    public void fireRequestInfoLine(String infoLine) {
        this.fireRequestInfoLine(new InfoDisplayEvent(this, infoLine));
    }

    public void fireRequestInfoLine(String infoLine, int loc) {
        this.fireRequestInfoLine(new InfoDisplayEvent(this, infoLine, loc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRequestBrowserContent(InfoDisplayEvent evt) {
        ListenerSupport<InfoDisplayListener> listenerSupport = this.IDListeners;
        synchronized (listenerSupport) {
            for (InfoDisplayListener listener : this.IDListeners) {
                listener.requestBrowserContent(evt);
            }
        }
    }

    public void fireRequestBrowserContent(String browserContent) {
        this.fireRequestBrowserContent(new InfoDisplayEvent(this, browserContent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRequestURL(InfoDisplayEvent evt) {
        ListenerSupport<InfoDisplayListener> listenerSupport = this.IDListeners;
        synchronized (listenerSupport) {
            for (InfoDisplayListener listener : this.IDListeners) {
                listener.requestURL(evt);
            }
        }
    }

    public void fireRequestURL(String url) {
        this.fireRequestURL(new InfoDisplayEvent(this, url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRequestCursor(Cursor cursor) {
        ListenerSupport<InfoDisplayListener> listenerSupport = this.IDListeners;
        synchronized (listenerSupport) {
            for (InfoDisplayListener listener : this.IDListeners) {
                listener.requestCursor(cursor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRequestMessage(InfoDisplayEvent evt) {
        ListenerSupport<InfoDisplayListener> listenerSupport = this.IDListeners;
        synchronized (listenerSupport) {
            for (InfoDisplayListener listener : this.IDListeners) {
                listener.requestMessage(evt);
            }
        }
    }

    public void fireRequestMessage(String message) {
        this.fireRequestMessage(new InfoDisplayEvent(this, message));
    }

    public void fireRequestToolTip(String tip) {
        this.fireRequestToolTip(new InfoDisplayEvent(this, tip));
    }

    public void fireHideToolTip() {
        this.fireRequestToolTip((InfoDisplayEvent)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRequestToolTip(InfoDisplayEvent event) {
        ListenerSupport<InfoDisplayListener> listenerSupport = this.IDListeners;
        synchronized (listenerSupport) {
            for (InfoDisplayListener listener : this.IDListeners) {
                if (event != null) {
                    listener.requestShowToolTip(event);
                    continue;
                }
                listener.requestHideToolTip();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayerStatusListener(LayerStatusListener aLayerStatusListener) {
        ListenerSupport<LayerStatusListener> listenerSupport = this.lsListeners;
        synchronized (listenerSupport) {
            this.lsListeners.add(aLayerStatusListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayerStatusListener(LayerStatusListener aLayerStatusListener) {
        ListenerSupport<LayerStatusListener> listenerSupport = this.lsListeners;
        synchronized (listenerSupport) {
            this.lsListeners.remove(aLayerStatusListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStatusUpdate(LayerStatusEvent evt) {
        ListenerSupport<LayerStatusListener> listenerSupport = this.lsListeners;
        synchronized (listenerSupport) {
            for (LayerStatusListener listener : this.lsListeners) {
                listener.updateLayerStatus(evt);
            }
        }
    }

    public void fireStatusUpdate(int status) {
        this.fireStatusUpdate(new LayerStatusEvent(this, status));
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
        Container p = this.getParent();
        if (p instanceof MapBean) {
            ((MapBean)p).setBufferDirty(true);
            if (Debug.debugging("basic")) {
                Debug.output(this.getName() + "|Layer: repaint(tm=" + tm + ", x=" + x + ", y=" + y + ", width=" + width + ", height=" + height + ")");
            }
            ((MapBean)p).repaint(this);
        } else if (p != null) {
            p.repaint(tm, x, y, width, height);
        } else {
            super.repaint(tm, x, y, width, height);
        }
    }

    @Override
    public void renderDataForProjection(Projection proj, Graphics g) {
        if (this.isProjectionOK(proj)) {
            this.paint(g);
        }
    }

    public boolean isProjectionOK(Projection proj) {
        return proj != null && proj.getScale() >= this.minScale && proj.getScale() <= this.maxScale;
    }

    public void added(Container cont) {
    }

    public void removed(Container cont) {
    }

    public void dispose() {
        this.clearListeners();
        if (this.attributes != null) {
            this.attributes.clear();
        }
        this.removed(null);
    }

    @Override
    public void setVisible(boolean show) {
        super.setVisible(show);
        if (this.doHack && !show) {
            this.notifyHideHack();
        }
    }

    @Override
    public void addComponentListener(ComponentListener cl) {
        super.addComponentListener(cl);
        if (this.localHackList == null) {
            this.localHackList = new ListenerSupport(this);
        }
        this.localHackList.add(cl);
    }

    @Override
    public void removeComponentListener(ComponentListener cl) {
        super.removeComponentListener(cl);
        if (this.localHackList != null) {
            this.localHackList.remove(cl);
        }
    }

    public void notifyHideHack() {
        if (this.localHackList == null) {
            return;
        }
        ComponentEvent ce = new ComponentEvent(this, 103);
        for (ComponentListener listener : this.localHackList) {
            listener.componentHidden(ce);
        }
    }

    public void setAddToBeanContext(boolean set) {
        this.addToBeanContext = set;
    }

    public boolean getAddToBeanContext() {
        return this.addToBeanContext;
    }

    public void setAddAsBackground(boolean set) {
        this.addAsBackground = set;
    }

    public boolean getAddAsBackground() {
        return this.addAsBackground;
    }

    public void setRemovable(boolean set) {
        this.removable = set;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public boolean removeConfirmed() {
        return true;
    }

    public void findAndInit(Iterator<?> it) {
        while (it.hasNext()) {
            this.findAndInit(it.next());
        }
    }

    public void findAndInit(Object obj) {
    }

    @Override
    public void childrenAdded(BeanContextMembershipEvent bcme) {
        this.findAndInit(bcme.iterator());
    }

    @Override
    public void childrenRemoved(BeanContextMembershipEvent bcme) {
        Iterator it = bcme.iterator();
        while (it.hasNext()) {
            this.findAndUndo(it.next());
        }
    }

    public void findAndUndo(Object obj) {
        if (obj == this) {
            this.dispose();
        }
    }

    @Override
    public BeanContext getBeanContext() {
        return this.beanContextChildSupport.getBeanContext();
    }

    @Override
    public void setBeanContext(BeanContext in_bc) throws PropertyVetoException {
        if (in_bc != null) {
            this.connectToBeanContext(in_bc);
            this.findAndInit(in_bc.iterator());
        }
    }

    public void connectToBeanContext(BeanContext in_bc) throws PropertyVetoException {
        if (in_bc != null) {
            in_bc.addBeanContextMembershipListener(this);
            this.beanContextChildSupport.setBeanContext(in_bc);
        }
    }

    public void disconnectFromBeanContext() throws PropertyVetoException {
        BeanContext bc = this.getBeanContext();
        if (bc != null) {
            bc.removeBeanContextMembershipListener(this);
            this.beanContextChildSupport.setBeanContext(null);
        }
    }

    @Override
    public void addVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.addVetoableChangeListener(propertyName, in_vcl);
    }

    @Override
    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.removeVetoableChangeListener(propertyName, in_vcl);
    }

    @Override
    public void fireVetoableChange(String name, Object oldValue, Object newValue) throws PropertyVetoException {
        super.fireVetoableChange(name, oldValue, newValue);
        this.beanContextChildSupport.fireVetoableChange(name, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListeners() {
        if (this.localHackList != null) {
            this.localHackList.clear();
        }
        ListenerSupport<EventListener> listenerSupport = this.IDListeners;
        synchronized (listenerSupport) {
            this.IDListeners.clear();
        }
        listenerSupport = this.lsListeners;
        synchronized (listenerSupport) {
            this.lsListeners.clear();
        }
        BeanContext bc = this.getBeanContext();
        if (bc != null) {
            bc.removeBeanContextMembershipListener(this);
        }
    }

    protected void finalize() {
        if (Debug.debugging("gc")) {
            Debug.output("Layer |" + this.getName() + " |: getting GC'd");
        }
    }

    public void firePaletteEvent(ComponentEvent event) {
        if (this.localHackList == null) {
            return;
        }
        this.palette = (Container)event.getSource();
        int eventType = event.getID();
        for (ComponentListener listener : this.localHackList) {
            if (eventType == 103) {
                listener.componentHidden(event);
                continue;
            }
            if (eventType != 102) continue;
            listener.componentShown(event);
        }
        if (eventType == 103) {
            this.palette = null;
        }
    }

    public Container getPalette() {
        return this.palette;
    }

    protected void resetPalette() {
        Container pal = this.getPalette();
        boolean putUp = false;
        if (pal != null && pal.isVisible()) {
            putUp = true;
            this.setPaletteVisible(false);
        }
        if (putUp) {
            this.setPaletteVisible(true);
        }
    }

    public void setPaletteVisible(boolean visible) {
        if (visible) {
            this.showPalette();
        } else {
            this.hidePalette();
        }
    }

    public void setWindowSupport(WindowSupport ws) {
        this.windowSupport = ws;
    }

    public WindowSupport getWindowSupport() {
        return this.windowSupport;
    }

    protected WindowSupport createWindowSupport() {
        return new ScrollPaneWindowSupport(this.getGUI(), this.getName());
    }

    public void showPalette() {
        WindowSupport ws = this.getWindowSupport();
        if (ws == null) {
            ws = this.createWindowSupport();
            this.paletteListener = new ComponentAdapter(){

                public void componentShown(ComponentEvent e) {
                    Layer.this.firePaletteEvent(e);
                }

                public void componentHidden(ComponentEvent e) {
                    Layer.this.firePaletteEvent(e);
                }
            };
            this.setWindowSupport(ws);
        } else {
            ws.setTitle(this.getName());
            ws.setContent(this.getGUI());
        }
        if (ws != null) {
            MapHandler mh = (MapHandler)this.getBeanContext();
            Frame frame = null;
            if (mh != null && (frame = mh.get(Frame.class)) == null) {
                MapBean mapBean = (MapBean)mh.get("com.bbn.openmap.MapBean");
                if (mapBean == null) {
                    Debug.message("layer", "Layer.showPalette: Warning...mapBean = null");
                } else {
                    try {
                        Container parent = mapBean.getParent();
                        while (parent.getParent() != null && !(parent instanceof Frame)) {
                            parent = parent.getParent();
                        }
                        if (parent instanceof Frame) {
                            frame = (Frame)parent;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.paletteListener != null) {
                ws.addComponentListener(this.paletteListener);
            }
            ws.displayInWindow(frame);
        }
    }

    public void hidePalette() {
        WindowSupport ws = this.getWindowSupport();
        if (ws != null) {
            ws.killWindow();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command == DisplayPaletteCmd) {
            if (Debug.debugging("layer")) {
                Debug.output(this.getName() + " displaying palette");
            }
            this.showPalette();
        } else if (command == HidePaletteCmd) {
            if (Debug.debugging("layer")) {
                Debug.output(this.getName() + " hiding palette");
            }
            this.hidePalette();
        } else if (command == DisplayPropertiesCmd) {
            Inspector inspector = new Inspector();
            inspector.inspectPropertyConsumer(this);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.i18n = Environment.getI18n();
        this.beanContextChildSupport = new BeanContextChildSupport(this);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public boolean isAutoPalette() {
        return this.autoPalette;
    }

    public void setAutoPalette(boolean autoPalette) {
        this.autoPalette = autoPalette;
    }

    public float getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(float maxScale) {
        this.maxScale = maxScale;
    }

    public float getMinScale() {
        return this.minScale;
    }

    public void setMinScale(float minScale) {
        this.minScale = minScale;
    }

    public void putAttribute(Object key, Object value) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        Object ret = null;
        if (key != null && this.attributes != null) {
            ret = this.attributes.get(key);
        }
        return ret;
    }

    public GeoCoordTransformation getCoordTransform() {
        return this.coordTransform;
    }

    public void setCoordTransform(GeoCoordTransformation coordTranslator) {
        this.coordTransform = coordTranslator;
    }

    protected String prependDataPathPrefix(String fileName) {
        String dataPathPrefix = (String)this.getAttribute(DataPathPrefixProperty);
        if (dataPathPrefix != null && dataPathPrefix.length() > 0) {
            fileName = dataPathPrefix + "/" + fileName;
        }
        return fileName;
    }
}

