/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.LayerEvent;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.logging.Level;

public class BufferedMapBean
extends MapBean {
    protected boolean bufferDirty = true;
    protected Image drawingBuffer = null;
    public PanHelper panningTransform = null;

    public BufferedMapBean() {
    }

    public BufferedMapBean(boolean useThreadedNotification) {
        super(useThreadedNotification);
    }

    public void setLayers(LayerEvent evt) {
        this.bufferDirty = true;
        super.setLayers(evt);
    }

    public void componentResized(ComponentEvent e) {
        boolean bad = false;
        try {
            if (this.drawingBuffer != null) {
                this.drawingBuffer.flush();
                this.drawingBuffer = null;
            }
            this.drawingBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        }
        catch (NegativeArraySizeException nae) {
            bad = true;
        }
        catch (IllegalArgumentException iae) {
            bad = true;
        }
        if (bad) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("component resizing is not valid for buffer.");
            }
            this.drawingBuffer = new BufferedImage(1, 1, 2);
        }
        super.componentResized(e);
    }

    public void paintChildren(Graphics g) {
        this.paintChildren(g, null);
    }

    public void paintChildren(Graphics g, Rectangle clip) {
        if (this.panningTransform == null && this.bufferDirty) {
            this.bufferDirty = false;
            int w = this.getWidth();
            int h = this.getHeight();
            if (this.drawingBuffer == null) {
                this.drawingBuffer = new BufferedImage(w, h, 2);
            }
            Graphics gr = this.getMapBeanRepaintPolicy().modifyGraphicsForPainting(this.drawingBuffer.getGraphics());
            if (clip == null) {
                gr.setClip(0, 0, w, h);
            } else {
                gr.setClip(clip);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("BufferedMapBean rendering layers to buffer.");
            }
            this.paintChildrenWithBorder(gr, false);
            gr.dispose();
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("BufferedMapBean rendering buffer.");
        }
        g = g.create();
        if (clip != null) {
            g.setClip(clip);
        }
        if (this.panningTransform != null) {
            this.panningTransform.render((Graphics2D)g);
            return;
        }
        if (this.drawingBuffer != null) {
            Image daImage = this.drawingBuffer;
            if (this.rotHelper != null) {
                daImage = this.rotHelper.paintChildren(g, clip);
            }
            g.drawImage(daImage, 0, 0, null);
            if (this.rotHelper == null && this.painters != null) {
                this.painters.paint(g);
            }
            this.paintBorder(g);
        }
        g.dispose();
    }

    public boolean isBuffered() {
        return true;
    }

    public void setBufferDirty(boolean value) {
        this.bufferDirty = value;
    }

    public boolean isBufferDirty() {
        return this.bufferDirty;
    }

    public void dispose() {
        if (this.drawingBuffer != null) {
            this.drawingBuffer.flush();
        }
        this.drawingBuffer = null;
        super.dispose();
    }

    public AffineTransform getPanningTransform() {
        return this.panningTransform;
    }

    public void setPanningTransform(AffineTransform transform) {
        if (transform != null) {
            if (this.panningTransform == null) {
                this.panningTransform = new PanHelper(transform, this.drawingBuffer);
                this.drawingBuffer = null;
            } else {
                this.panningTransform.update(transform);
            }
        } else {
            if (this.panningTransform != null) {
                this.panningTransform.dispose();
            }
            this.panningTransform = null;
        }
        this.setBufferDirty(transform != null || this.isBufferDirty());
    }

    protected class PanHelper
    extends AffineTransform {
        protected Image buffer;

        protected PanHelper(AffineTransform aft, Image buffer) {
            super(aft);
            this.buffer = buffer;
        }

        protected void update(AffineTransform aft) {
            super.setTransform(aft);
        }

        protected void render(Graphics2D g) {
            BufferedMapBean.this.drawProjectionBackground(g);
            g.setTransform(this);
            if (this.buffer != null) {
                g.drawImage(this.buffer, 0, 0, null);
            }
            if (BufferedMapBean.this.rotHelper == null && BufferedMapBean.this.painters != null) {
                BufferedMapBean.this.painters.paint(g);
            }
        }

        protected void dispose() {
            if (this.buffer != null) {
                this.buffer.flush();
                this.buffer = null;
            }
        }
    }
}

