/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import reactor.core.publisher.Mono;

public class StorageBearerTokenChallengeAuthorizationPolicy
extends BearerTokenAuthenticationPolicy {
    private static final ClientLogger LOGGER = new ClientLogger(StorageBearerTokenChallengeAuthorizationPolicy.class);
    private static final String DEFAULT_SCOPE = "/.default";
    private static final String BEARER_TOKEN_PREFIX = "Bearer";
    private static final String RESOURCE_ID = "resource_id";
    private static final String AUTHORIZATION_URI = "authorization_uri";
    private final String[] initialScopes;

    public StorageBearerTokenChallengeAuthorizationPolicy(TokenCredential credential, String ... scopes) {
        super(credential, scopes);
        this.initialScopes = (String[])CoreUtils.clone((Object[])scopes);
    }

    public Mono<Void> authorizeRequest(HttpPipelineCallContext context) {
        return super.authorizeRequest(context);
    }

    public void authorizeRequestSync(HttpPipelineCallContext context) {
        super.authorizeRequestSync(context);
    }

    public Mono<Boolean> authorizeRequestOnChallenge(HttpPipelineCallContext context, HttpResponse response) {
        String authHeader = response.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
        Map<String, String> attributes = StorageBearerTokenChallengeAuthorizationPolicy.extractChallengeAttributes(authHeader);
        if (attributes.isEmpty()) {
            return Mono.just((Object)false);
        }
        String resource = attributes.get(RESOURCE_ID);
        String authUrl = attributes.get(AUTHORIZATION_URI);
        String[] scopesToUse = this.initialScopes;
        if (!CoreUtils.isNullOrEmpty((CharSequence)resource)) {
            scopesToUse = new String[]{resource.endsWith(DEFAULT_SCOPE) ? resource : resource + DEFAULT_SCOPE};
        }
        TokenRequestContext tokenRequestContext = new TokenRequestContext().addScopes(scopesToUse).setCaeEnabled(true);
        if (!CoreUtils.isNullOrEmpty((CharSequence)authUrl)) {
            tokenRequestContext.setTenantId(this.extractTenantIdFromUri(authUrl));
        }
        return this.setAuthorizationHeader(context, tokenRequestContext).thenReturn((Object)true);
    }

    String extractTenantIdFromUri(String uri) {
        try {
            String[] segments = new URI(uri).getPath().split("/");
            if (segments.length > 1) {
                return segments[1];
            }
            throw LOGGER.logExceptionAsError(new RuntimeException("Invalid authorization URI: tenantId not found"));
        }
        catch (URISyntaxException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Invalid authorization URI", e));
        }
    }

    public boolean authorizeRequestOnChallengeSync(HttpPipelineCallContext context, HttpResponse response) {
        String authHeader = response.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
        Map<String, String> attributes = StorageBearerTokenChallengeAuthorizationPolicy.extractChallengeAttributes(authHeader);
        if (attributes.isEmpty()) {
            return false;
        }
        String resource = attributes.get(RESOURCE_ID);
        String authUrl = attributes.get(AUTHORIZATION_URI);
        String[] scopesToUse = this.initialScopes;
        if (!CoreUtils.isNullOrEmpty((CharSequence)resource)) {
            scopesToUse = new String[]{resource.endsWith(DEFAULT_SCOPE) ? resource : resource + DEFAULT_SCOPE};
        }
        TokenRequestContext tokenRequestContext = new TokenRequestContext().addScopes(scopesToUse).setCaeEnabled(true);
        if (!CoreUtils.isNullOrEmpty((CharSequence)authUrl)) {
            tokenRequestContext.setTenantId(this.extractTenantIdFromUri(authUrl));
        }
        this.setAuthorizationHeaderSync(context, tokenRequestContext);
        return true;
    }

    static Map<String, String> extractChallengeAttributes(String header) {
        if (!StorageBearerTokenChallengeAuthorizationPolicy.isBearerChallenge(header)) {
            return Collections.emptyMap();
        }
        String remainingHeader = header.substring(BEARER_TOKEN_PREFIX.length());
        String[] attributes = remainingHeader.contains(",") ? remainingHeader.split(",") : remainingHeader.split(" ");
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (String pair : attributes) {
            if (CoreUtils.isNullOrEmpty((CharSequence)pair) || !pair.contains("=")) continue;
            String[] keyValue = pair.split("=");
            attributeMap.put(keyValue[0].replaceAll("\"", "").trim(), keyValue[1].replaceAll("\"", "").trim());
        }
        return attributeMap;
    }

    static boolean isBearerChallenge(String authenticateHeader) {
        return !CoreUtils.isNullOrEmpty((CharSequence)authenticateHeader) && authenticateHeader.regionMatches(true, 0, BEARER_TOKEN_PREFIX, 0, BEARER_TOKEN_PREFIX.length());
    }
}

