/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.tables.TableClient;
import com.azure.data.tables.TableClientBuilder;
import com.azure.data.tables.TableServiceClientBuilder;
import com.azure.data.tables.TableServiceVersion;
import com.azure.data.tables.implementation.AzureTableImpl;
import com.azure.data.tables.implementation.AzureTableImplBuilder;
import com.azure.data.tables.implementation.TableAccountSasGenerator;
import com.azure.data.tables.implementation.TableItemAccessHelper;
import com.azure.data.tables.implementation.TablePaged;
import com.azure.data.tables.implementation.TableSasUtils;
import com.azure.data.tables.implementation.TableUtils;
import com.azure.data.tables.implementation.models.OdataMetadataFormat;
import com.azure.data.tables.implementation.models.QueryOptions;
import com.azure.data.tables.implementation.models.ResponseFormat;
import com.azure.data.tables.implementation.models.TableProperties;
import com.azure.data.tables.implementation.models.TableQueryResponse;
import com.azure.data.tables.implementation.models.TableResponseProperties;
import com.azure.data.tables.implementation.models.TablesQueryHeaders;
import com.azure.data.tables.models.ListTablesOptions;
import com.azure.data.tables.models.TableItem;
import com.azure.data.tables.models.TableServiceException;
import com.azure.data.tables.models.TableServiceProperties;
import com.azure.data.tables.models.TableServiceStatistics;
import com.azure.data.tables.sas.TableAccountSasSignatureValues;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@ServiceClient(builder=TableServiceClientBuilder.class)
public final class TableServiceClient {
    private final ClientLogger logger = new ClientLogger(TableServiceClient.class);
    private final AzureTableImpl implementation;
    private final String accountName;
    private final HttpPipeline pipeline;

    TableServiceClient(HttpPipeline pipeline, String url, TableServiceVersion serviceVersion, SerializerAdapter serializerAdapter) {
        try {
            URI uri = URI.create(url);
            this.accountName = uri.getHost().split("\\.", 2)[0];
            this.logger.verbose("Table Service URI: {}", new Object[]{uri});
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            throw this.logger.logExceptionAsError(ex);
        }
        this.implementation = new AzureTableImplBuilder().serializerAdapter(serializerAdapter).url(url).pipeline(pipeline).version(serviceVersion.getVersion()).buildClient();
        this.pipeline = this.implementation.getHttpPipeline();
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getServiceEndpoint() {
        return this.implementation.getUrl();
    }

    public TableServiceVersion getServiceVersion() {
        return TableServiceVersion.fromString(this.implementation.getVersion());
    }

    HttpPipeline getHttpPipeline() {
        return this.pipeline;
    }

    public String generateAccountSas(TableAccountSasSignatureValues tableAccountSasSignatureValues) {
        AzureNamedKeyCredential azureNamedKeyCredential = TableSasUtils.extractNamedKeyCredential(this.getHttpPipeline());
        if (azureNamedKeyCredential == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot generate a SAS token with a client that is not authenticated with an AzureNamedKeyCredential."));
        }
        return new TableAccountSasGenerator(tableAccountSasSignatureValues, azureNamedKeyCredential).getSas();
    }

    public TableClient getTableClient(String tableName) {
        return new TableClientBuilder().pipeline(this.implementation.getHttpPipeline()).serviceVersion(this.getServiceVersion()).endpoint(this.getServiceEndpoint()).tableName(tableName).buildClient();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableClient createTable(String tableName) {
        return (TableClient)this.createTableWithResponse(tableName, null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TableClient> createTableWithResponse(String tableName, Duration timeout, Context context) {
        Supplier callable = () -> this.createTableWithResponse(tableName, context);
        return TableUtils.callWithOptionalTimeout(callable, timeout, this.logger);
    }

    Response<TableClient> createTableWithResponse(String tableName, Context context) {
        TableProperties properties = new TableProperties().setTableName(tableName);
        return new SimpleResponse(this.implementation.getTables().createWithResponse(properties, null, ResponseFormat.RETURN_NO_CONTENT, null, context), (Object)this.getTableClient(tableName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableClient createTableIfNotExists(String tableName) {
        return (TableClient)this.createTableIfNotExistsWithResponse(tableName, null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TableClient> createTableIfNotExistsWithResponse(String tableName, Duration timeout, Context context) {
        Supplier callable = () -> this.createTableIfNotExistsWithResponse(tableName, context);
        SimpleResponse returnedResponse = TableUtils.callWithOptionalTimeout(callable, timeout, this.logger, true);
        return returnedResponse.getValue() == null ? new SimpleResponse(returnedResponse.getRequest(), returnedResponse.getStatusCode(), returnedResponse.getHeaders(), (Object)this.getTableClient(tableName)) : returnedResponse;
    }

    Response<TableClient> createTableIfNotExistsWithResponse(String tableName, Context context) {
        TableProperties properties = new TableProperties().setTableName(tableName);
        return new SimpleResponse(this.implementation.getTables().createWithResponse(properties, null, ResponseFormat.RETURN_NO_CONTENT, null, context), (Object)this.getTableClient(tableName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTable(String tableName) {
        this.deleteTableWithResponse(tableName, null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTableWithResponse(String tableName, Duration timeout, Context context) {
        Supplier<Response> callable = () -> this.deleteTableWithResponse(tableName, context);
        try {
            return TableUtils.requestWithOptionalTimeout(callable, timeout);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
        catch (RuntimeException e) {
            RuntimeException exception = (RuntimeException)TableUtils.mapThrowableToTableServiceException(e);
            if (exception instanceof TableServiceException && ((TableServiceException)((Object)exception)).getResponse().getStatusCode() == 404) {
                HttpResponse httpResponse = ((TableServiceException)((Object)exception)).getResponse();
                return new SimpleResponse(httpResponse.getRequest(), httpResponse.getStatusCode(), httpResponse.getHeaders(), null);
            }
            throw this.logger.logExceptionAsError(exception);
        }
    }

    Response<Void> deleteTableWithResponse(String tableName, Context context) {
        return new SimpleResponse(this.implementation.getTables().deleteWithResponse(tableName, null, context), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TableItem> listTables() {
        return this.listTables(new ListTablesOptions(), null, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TableItem> listTables(ListTablesOptions options, Duration timeout, Context context) {
        Supplier callable = () -> this.listTables(options, context);
        return TableUtils.callIterableWithOptionalTimeout(callable, timeout, this.logger);
    }

    private PagedIterable<TableItem> listTables(ListTablesOptions options, Context context) {
        return new PagedIterable(() -> this.listTablesFirstPage(context, options), token -> this.listTablesNextPage((String)token, context, options));
    }

    private PagedResponse<TableItem> listTablesFirstPage(Context context, ListTablesOptions options) {
        return this.listTables(null, context, options);
    }

    private PagedResponse<TableItem> listTablesNextPage(String token, Context context, ListTablesOptions options) {
        return this.listTables(token, context, options);
    }

    private PagedResponse<TableItem> listTables(String nextTableName, Context context, ListTablesOptions options) {
        QueryOptions queryOptions = new QueryOptions().setFilter(options.getFilter()).setTop(options.getTop()).setFormat(OdataMetadataFormat.APPLICATION_JSON_ODATA_FULLMETADATA);
        ResponseBase<TablesQueryHeaders, TableQueryResponse> response = this.implementation.getTables().queryWithResponse(null, nextTableName, queryOptions, context);
        TableQueryResponse tableQueryResponse = (TableQueryResponse)response.getValue();
        if (tableQueryResponse == null) {
            return null;
        }
        List<TableResponseProperties> tableResponsePropertiesList = tableQueryResponse.getValue();
        if (tableResponsePropertiesList == null) {
            return null;
        }
        List<TableItem> tables = tableResponsePropertiesList.stream().map(TableItemAccessHelper::createItem).collect(Collectors.toList());
        return new TablePaged((Response<TableQueryResponse>)response, tables, ((TablesQueryHeaders)response.getDeserializedHeaders()).getXMsContinuationNextTableName());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableServiceProperties getProperties() {
        return (TableServiceProperties)this.getPropertiesWithResponse(null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TableServiceProperties> getPropertiesWithResponse(Duration timeout, Context context) {
        Supplier callable = () -> this.getPropertiesWithResponse(context);
        return TableUtils.callWithOptionalTimeout(callable, timeout, this.logger);
    }

    Response<TableServiceProperties> getPropertiesWithResponse(Context context) {
        return this.implementation.getServices().getPropertiesWithResponse(null, null, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setProperties(TableServiceProperties tableServiceProperties) {
        this.setPropertiesWithResponse(tableServiceProperties, null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setPropertiesWithResponse(TableServiceProperties tableServiceProperties, Duration timeout, Context context) {
        Supplier callable = () -> this.setPropertiesWithResponse(tableServiceProperties, context);
        return TableUtils.callWithOptionalTimeout(callable, timeout, this.logger);
    }

    Response<Void> setPropertiesWithResponse(TableServiceProperties tableServiceProperties, Context context) {
        return this.implementation.getServices().setPropertiesWithResponse(tableServiceProperties, null, null, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableServiceStatistics getStatistics() {
        return (TableServiceStatistics)this.getStatisticsWithResponse(null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TableServiceStatistics> getStatisticsWithResponse(Duration timeout, Context context) {
        Supplier callable = () -> this.getStatisticsWithResponse(context);
        return TableUtils.callWithOptionalTimeout(callable, timeout, this.logger);
    }

    Response<TableServiceStatistics> getStatisticsWithResponse(Context context) {
        return this.implementation.getServices().getStatisticsWithResponse(null, null, context);
    }
}

