/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.MatchConditions;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.appconfiguration.implementation.AzureAppConfigurationImpl;
import com.azure.data.appconfiguration.implementation.models.KeyValue;
import com.azure.data.appconfiguration.implementation.models.SnapshotUpdateParameters;
import com.azure.data.appconfiguration.implementation.models.UpdateSnapshotHeaders;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.ConfigurationSnapshot;
import com.azure.data.appconfiguration.models.ConfigurationSnapshotStatus;
import com.azure.data.appconfiguration.models.SettingFields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.core.publisher.Mono;

public class Utility {
    public static final String ID = "id";
    public static final String DESCRIPTION = "description";
    public static final String DISPLAY_NAME = "display_name";
    public static final String ENABLED = "enabled";
    public static final String CONDITIONS = "conditions";
    public static final String CLIENT_FILTERS = "client_filters";
    public static final String NAME = "name";
    public static final String PARAMETERS = "parameters";
    public static final String URI = "uri";
    public static final String ETAG_ANY = "*";

    public static KeyValue toKeyValue(ConfigurationSetting setting) {
        return new KeyValue().setKey(setting.getKey()).setValue(setting.getValue()).setLabel(setting.getLabel()).setContentType(setting.getContentType()).setEtag(setting.getETag()).setLastModified(setting.getLastModified()).setLocked(setting.isReadOnly()).setTags(setting.getTags());
    }

    public static List<SettingFields> toSettingFieldsList(SettingFields[] settingFieldsArray) {
        return new ArrayList<SettingFields>(Arrays.asList(settingFieldsArray));
    }

    private static String getETagValue(String etag) {
        return etag == null || ETAG_ANY.equals(etag) ? etag : "\"" + etag + "\"";
    }

    public static String getETag(boolean isETagRequired, ConfigurationSetting setting) {
        return isETagRequired ? Utility.getETagValue(setting.getETag()) : null;
    }

    public static void validateSetting(ConfigurationSetting setting) {
        Objects.requireNonNull(setting);
        if (setting.getKey() == null) {
            throw new IllegalArgumentException("Parameter 'key' is required and cannot be null.");
        }
    }

    public static Mono<ConfigurationSetting> validateSettingAsync(ConfigurationSetting setting) {
        if (setting == null) {
            return Mono.error((Throwable)new NullPointerException("Configuration setting cannot be null"));
        }
        if (setting.getKey() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter 'key' is required and cannot be null."));
        }
        return Mono.just((Object)setting);
    }

    public static Response<ConfigurationSnapshot> updateSnapshotSync(String snapshotName, MatchConditions matchConditions, ConfigurationSnapshotStatus status, AzureAppConfigurationImpl serviceClient, Context context) {
        String ifMatch = matchConditions == null ? null : matchConditions.getIfMatch();
        ResponseBase<UpdateSnapshotHeaders, ConfigurationSnapshot> response = serviceClient.updateSnapshotWithResponse(snapshotName, new SnapshotUpdateParameters().setStatus(status), ifMatch, null, context);
        return new SimpleResponse(response, (Object)((ConfigurationSnapshot)response.getValue()));
    }

    public static Mono<Response<ConfigurationSnapshot>> updateSnapshotAsync(String snapshotName, MatchConditions matchConditions, ConfigurationSnapshotStatus status, AzureAppConfigurationImpl serviceClient) {
        String ifMatch = matchConditions == null ? null : matchConditions.getIfMatch();
        return serviceClient.updateSnapshotWithResponseAsync(snapshotName, new SnapshotUpdateParameters().setStatus(status), ifMatch, null).map(response -> new SimpleResponse((Response)response, (Object)((ConfigurationSnapshot)response.getValue())));
    }

    public static String parseNextLink(String nextLink) {
        if (nextLink == null) {
            return null;
        }
        String[] parts = nextLink.split(";");
        return parts[0].substring(1, parts[0].length() - 1);
    }

    public static Mono<PagedResponse<KeyValue>> handleNotModifiedErrorToValidResponse(HttpResponseException error) {
        HttpResponse httpResponse = error.getResponse();
        if (httpResponse == null) {
            return Mono.error((Throwable)error);
        }
        String continuationToken = Utility.parseNextLink(httpResponse.getHeaderValue(HttpHeaderName.LINK));
        if (httpResponse.getStatusCode() == 304) {
            return Mono.just((Object)new PagedResponseBase(httpResponse.getRequest(), httpResponse.getStatusCode(), httpResponse.getHeaders(), null, continuationToken, null));
        }
        return Mono.error((Throwable)error);
    }

    public static PagedResponse<ConfigurationSetting> handleNotModifiedErrorToValidResponse(HttpResponseException error, ClientLogger logger) {
        HttpResponse httpResponse = error.getResponse();
        if (httpResponse == null) {
            throw logger.logExceptionAsError((RuntimeException)error);
        }
        String continuationToken = Utility.parseNextLink(httpResponse.getHeaderValue(HttpHeaderName.LINK));
        if (httpResponse.getStatusCode() == 304) {
            return new PagedResponseBase(httpResponse.getRequest(), httpResponse.getStatusCode(), httpResponse.getHeaders(), null, continuationToken, null);
        }
        throw logger.logExceptionAsError((RuntimeException)error);
    }

    public static String getPageETag(List<MatchConditions> matchConditionsList, AtomicInteger pageETagIndex) {
        if (CoreUtils.isNullOrEmpty(matchConditionsList)) {
            return null;
        }
        String nextPageETag = null;
        int pageETagIndexValue = pageETagIndex.get();
        if (pageETagIndexValue < matchConditionsList.size()) {
            nextPageETag = matchConditionsList.get(pageETagIndexValue).getIfNoneMatch();
            pageETagIndex.set(pageETagIndexValue + 1);
        }
        return nextPageETag;
    }

    public static List<String> getTagsFilterInString(Map<String, String> tagsFilter) {
        ArrayList<String> tagsFilters;
        if (tagsFilter != null) {
            tagsFilters = new ArrayList<String>();
            tagsFilter.forEach((key, value) -> {
                if (!CoreUtils.isNullOrEmpty((CharSequence)key) && !CoreUtils.isNullOrEmpty((CharSequence)value)) {
                    tagsFilters.add(key + "=" + value);
                }
            });
        } else {
            tagsFilters = null;
        }
        return tagsFilters;
    }
}

