/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.avd.AvdManager;
import java.io.File;
import java.util.Collections;
import java.util.Map;

public final class AvdInfo
implements Comparable<AvdInfo> {
    private final String mName;
    private final File mIniFile;
    private final String mFolderPath;
    private final String mTargetHash;
    private final IAndroidTarget mTarget;
    private final String mAbiType;
    private final Map<String, String> mProperties;
    private final AvdStatus mStatus;

    public AvdInfo(String name, File iniFile, String folderPath, String targetHash, IAndroidTarget target, String abiType, Map<String, String> properties) {
        this(name, iniFile, folderPath, targetHash, target, abiType, properties, AvdStatus.OK);
    }

    public AvdInfo(String name, File iniFile, String folderPath, String targetHash, IAndroidTarget target, String abiType, Map<String, String> properties, AvdStatus status) {
        this.mName = name;
        this.mIniFile = iniFile;
        this.mFolderPath = folderPath;
        this.mTargetHash = targetHash;
        this.mTarget = target;
        this.mAbiType = abiType;
        this.mProperties = properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(properties);
        this.mStatus = status;
    }

    public String getName() {
        return this.mName;
    }

    public String getDataFolderPath() {
        return this.mFolderPath;
    }

    public String getAbiType() {
        return this.mAbiType;
    }

    public String getCpuArch() {
        String cpuArch = this.mProperties.get("hw.cpu.arch");
        if (cpuArch != null) {
            return cpuArch;
        }
        return "arm";
    }

    public String getDeviceManufacturer() {
        String deviceManufacturer = this.mProperties.get("hw.device.manufacturer");
        if (deviceManufacturer != null && !deviceManufacturer.isEmpty()) {
            return deviceManufacturer;
        }
        return "";
    }

    public String getDeviceName() {
        String deviceName = this.mProperties.get("hw.device.name");
        if (deviceName != null && !deviceName.isEmpty()) {
            return deviceName;
        }
        return "";
    }

    public static String getPrettyAbiType(String raw) {
        String s = null;
        s = raw.equalsIgnoreCase("armeabi") ? "ARM (armeabi)" : (raw.equalsIgnoreCase("armeabi-v7a") ? "ARM (armeabi-v7a)" : (raw.equalsIgnoreCase("x86") ? "Intel Atom (x86)" : (raw.equalsIgnoreCase("mips") ? "MIPS (mips)" : raw + " (" + raw + ")")));
        return s;
    }

    public String getTargetHash() {
        return this.mTargetHash;
    }

    public IAndroidTarget getTarget() {
        return this.mTarget;
    }

    public AvdStatus getStatus() {
        return this.mStatus;
    }

    public static File getDefaultAvdFolder(AvdManager manager, String avdName) throws AndroidLocation.AndroidLocationException {
        return new File(manager.getBaseAvdFolder(), avdName + ".avd");
    }

    public static File getDefaultIniFile(AvdManager manager, String avdName) throws AndroidLocation.AndroidLocationException {
        String avdRoot = manager.getBaseAvdFolder();
        return new File(avdRoot, avdName + ".ini");
    }

    public File getIniFile() {
        return this.mIniFile;
    }

    public static File getConfigFile(String path) {
        return new File(path, "config.ini");
    }

    public File getConfigFile() {
        return AvdInfo.getConfigFile(this.mFolderPath);
    }

    public Map<String, String> getProperties() {
        return this.mProperties;
    }

    public String getErrorMessage() {
        switch (this.mStatus) {
            case ERROR_PATH: {
                return String.format("Missing AVD 'path' property in %1$s", this.getIniFile());
            }
            case ERROR_CONFIG: {
                return String.format("Missing config.ini file in %1$s", this.mFolderPath);
            }
            case ERROR_TARGET_HASH: {
                return String.format("Missing 'target' property in %1$s", this.getIniFile());
            }
            case ERROR_TARGET: {
                return String.format("Unknown target '%1$s' in %2$s", this.mTargetHash, this.getIniFile());
            }
            case ERROR_PROPERTIES: {
                return String.format("Failed to parse properties from %1$s", this.getConfigFile());
            }
            case ERROR_IMAGE_DIR: {
                return String.format("Invalid value in image.sysdir. Run 'android update avd -n %1$s'", this.mName);
            }
            case ERROR_DEVICE_CHANGED: {
                return String.format("%1$s %2$s configuration has changed since AVD creation", this.mProperties.get("hw.device.manufacturer"), this.mProperties.get("hw.device.name"));
            }
            case ERROR_DEVICE_MISSING: {
                return String.format("%1$s %2$s no longer exists as a device", this.mProperties.get("hw.device.manufacturer"), this.mProperties.get("hw.device.name"));
            }
            case OK: {
                assert (false);
                return null;
            }
        }
        return null;
    }

    public boolean isRunning() {
        File f = new File(this.mFolderPath, "userdata-qemu.img.lock");
        return f.isFile();
    }

    @Override
    public int compareTo(AvdInfo o) {
        if (this.mTarget == null && o != null && o.mTarget == null) {
            return 0;
        }
        if (this.mTarget == null) {
            return 1;
        }
        if (o == null || o.mTarget == null) {
            return -1;
        }
        int targetDiff = this.mTarget.compareTo(o.mTarget);
        if (targetDiff == 0) {
            return this.mName.compareTo(o.mName);
        }
        return targetDiff;
    }

    public static enum AvdStatus {
        OK,
        ERROR_PATH,
        ERROR_CONFIG,
        ERROR_TARGET_HASH,
        ERROR_TARGET,
        ERROR_PROPERTIES,
        ERROR_IMAGE_DIR,
        ERROR_DEVICE_CHANGED,
        ERROR_DEVICE_MISSING;

    }
}

