/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.NoPreviewRevision;
import org.w3c.dom.Node;

public class PackageParserUtils {
    public static FullRevision parseFullRevisionElement(Node revisionNode) {
        int major = 0;
        int minor = 0;
        int micro = 0;
        int preview = 0;
        if (revisionNode != null) {
            if (PackageParserUtils.findChildElement(revisionNode, "major") != null) {
                major = PackageParserUtils.getXmlInt(revisionNode, "major", 0);
                minor = PackageParserUtils.getXmlInt(revisionNode, "minor", 0);
                micro = PackageParserUtils.getXmlInt(revisionNode, "micro", 0);
                preview = PackageParserUtils.getXmlInt(revisionNode, "preview", 0);
            } else {
                try {
                    String majorStr = revisionNode.getTextContent().trim();
                    major = Integer.parseInt(majorStr);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return new FullRevision(major, minor, micro, preview);
    }

    public static NoPreviewRevision parseNoPreviewRevisionElement(Node revisionNode) {
        int major = 0;
        int minor = 0;
        int micro = 0;
        if (revisionNode != null) {
            if (PackageParserUtils.findChildElement(revisionNode, "major") != null) {
                major = PackageParserUtils.getXmlInt(revisionNode, "major", 0);
                minor = PackageParserUtils.getXmlInt(revisionNode, "minor", 0);
                micro = PackageParserUtils.getXmlInt(revisionNode, "micro", 0);
            } else {
                try {
                    String majorStr = revisionNode.getTextContent().trim();
                    major = Integer.parseInt(majorStr);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return new NoPreviewRevision(major, minor, micro);
    }

    public static Node findChildElement(Node node, String xmlLocalName) {
        if (node != null) {
            String nsUri = node.getNamespaceURI();
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || xmlLocalName != null && !xmlLocalName.equals(child.getLocalName())) continue;
                return child;
            }
        }
        return null;
    }

    public static String getXmlString(Node node, String xmlLocalName) {
        Node child = PackageParserUtils.findChildElement(node, xmlLocalName);
        return child == null ? "" : child.getTextContent();
    }

    public static String getOptionalXmlString(Node node, String xmlLocalName) {
        Node child = PackageParserUtils.findChildElement(node, xmlLocalName);
        return child == null ? null : child.getTextContent();
    }

    public static int getXmlInt(Node node, String xmlLocalName, int defaultValue) {
        String s = PackageParserUtils.getXmlString(node, xmlLocalName);
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long getXmlLong(Node node, String xmlLocalName, long defaultValue) {
        String s = PackageParserUtils.getXmlString(node, xmlLocalName);
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Object getEnumAttribute(Node archiveNode, String attrName, Object[] values, Object defaultValue) {
        Node attr = archiveNode.getAttributes().getNamedItem(attrName);
        if (attr != null) {
            String found = attr.getNodeValue();
            for (Object value : values) {
                if (!value.toString().equalsIgnoreCase(found)) continue;
                return value;
            }
        }
        return defaultValue;
    }
}

