/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.ide.common.packaging.PackagingUtils;
import com.android.ide.common.res2.AssetFile;
import com.android.ide.common.res2.AssetItem;
import com.android.ide.common.res2.DataSet;
import com.android.ide.common.res2.DuplicateDataException;
import com.android.utils.ILogger;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class AssetSet
extends DataSet<AssetItem, AssetFile> {
    public AssetSet(String configName) {
        super(configName);
    }

    @Override
    protected DataSet<AssetItem, AssetFile> createSet(String name) {
        return new AssetSet(name);
    }

    @Override
    protected AssetFile createFileAndItems(File sourceFolder, File file, ILogger logger) {
        return new AssetFile(file, AssetItem.create(sourceFolder, file));
    }

    @Override
    protected AssetFile createFileAndItems(File file, Node fileNode) {
        Attr nameAttr = (Attr)fileNode.getAttributes().getNamedItem("name");
        if (nameAttr == null) {
            return null;
        }
        AssetItem item = new AssetItem(nameAttr.getValue());
        return new AssetFile(file, item);
    }

    @Override
    protected boolean isValidSourceFile(File sourceFolder, File file) {
        File parent;
        for (parent = file.getParentFile(); parent != null && !parent.equals(sourceFolder); parent = parent.getParentFile()) {
        }
        return parent != null;
    }

    @Override
    protected void readSourceFolder(File sourceFolder, ILogger logger) throws DuplicateDataException, IOException {
        this.readFiles(sourceFolder, sourceFolder, logger);
    }

    private void readFiles(File sourceFolder, File folder, ILogger logger) throws IOException {
        File[] files = folder.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (file.isFile()) {
                    if (!this.checkFileForAndroidRes(file)) continue;
                    this.handleNewFile(sourceFolder, file, logger);
                    continue;
                }
                if (!file.isDirectory() || !PackagingUtils.checkFolderForPackaging(folder.getName())) continue;
                this.readFiles(sourceFolder, file, logger);
            }
        }
    }
}

