/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.resources.ResourceEnum;

public enum UiMode implements ResourceEnum
{
    NORMAL("", "Normal"),
    CAR("car", "Car Dock"),
    DESK("desk", "Desk Dock"),
    TELEVISION("television", "Television"),
    APPLIANCE("appliance", "Appliance");

    private final String mValue;
    private final String mDisplayValue;

    private UiMode(String value, String display) {
        this.mValue = value;
        this.mDisplayValue = display;
    }

    public static UiMode getEnum(String value) {
        for (UiMode mode : UiMode.values()) {
            if (!mode.mValue.equals(value)) continue;
            return mode;
        }
        return null;
    }

    @Override
    public String getResourceValue() {
        return this.mValue;
    }

    @Override
    public String getShortDisplayValue() {
        return this.mDisplayValue;
    }

    @Override
    public String getLongDisplayValue() {
        return this.mDisplayValue;
    }

    public static int getIndex(UiMode value) {
        int i = 0;
        for (UiMode mode : UiMode.values()) {
            if (mode == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static UiMode getByIndex(int index) {
        int i = 0;
        for (UiMode value : UiMode.values()) {
            if (i == index) {
                return value;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isFakeValue() {
        return this == NORMAL;
    }

    @Override
    public boolean isValidValueForDevice() {
        return this != NORMAL;
    }
}

