/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.resources.ResourceEnum;

public enum Density implements ResourceEnum
{
    XXHIGH("xxhdpi", "XX-High Density", 480, 16),
    XHIGH("xhdpi", "X-High Density", 320, 8),
    HIGH("hdpi", "High Density", 240, 4),
    TV("tvdpi", "TV Density", 213, 13),
    MEDIUM("mdpi", "Medium Density", 160, 4),
    LOW("ldpi", "Low Density", 120, 4),
    NODPI("nodpi", "No Density", 0, 4);

    public static final int DEFAULT_DENSITY = 160;
    private final String mValue;
    private final String mDisplayValue;
    private final int mDensity;
    private final int mSince;

    private Density(String value, String displayValue, int density, int since) {
        this.mValue = value;
        this.mDisplayValue = displayValue;
        this.mDensity = density;
        this.mSince = since;
    }

    public static Density getEnum(String value) {
        for (Density orient : Density.values()) {
            if (!orient.mValue.equals(value)) continue;
            return orient;
        }
        return null;
    }

    public static Density getEnum(int value) {
        for (Density d : Density.values()) {
            if (d.mDensity != value) continue;
            return d;
        }
        return null;
    }

    @Override
    public String getResourceValue() {
        return this.mValue;
    }

    public int getDpiValue() {
        return this.mDensity;
    }

    public int since() {
        return this.mSince;
    }

    public String getLegacyValue() {
        if (this != NODPI) {
            return String.format("%1$ddpi", this.getDpiValue());
        }
        return "";
    }

    @Override
    public String getShortDisplayValue() {
        return this.mDisplayValue;
    }

    @Override
    public String getLongDisplayValue() {
        return this.mDisplayValue;
    }

    public static int getIndex(Density value) {
        int i = 0;
        for (Density input : Density.values()) {
            if (value == input) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Density getByIndex(int index) {
        int i = 0;
        for (Density value : Density.values()) {
            if (i == index) {
                return value;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isFakeValue() {
        return false;
    }

    @Override
    public boolean isValidValueForDevice() {
        return this != NODPI;
    }
}

