/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.internal.compiler.FileGatherer;
import com.android.builder.internal.compiler.SourceSearcher;
import com.android.ide.common.internal.CommandLineRunner;
import com.android.ide.common.internal.LoggedErrorException;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.sdklib.BuildToolInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class RenderScriptProcessor {
    private static final Abi[] ABIS = new Abi[]{new Abi("armeabi-v7a", "armv7-none-linux-gnueabi", BuildToolInfo.PathId.LD_ARM, "-dynamic-linker", "/system/bin/linker", "-X", "-m", "armelf_linux_eabi"), new Abi("mips", "mipsel-unknown-linux", BuildToolInfo.PathId.LD_MIPS, "-EL"), new Abi("x86", "i686-unknown-linux", BuildToolInfo.PathId.LD_X86, "-m", "elf_i386")};
    public static final String RS_DEPS = "rsDeps";
    @NonNull
    private final List<File> mSourceFolders;
    @NonNull
    private final List<File> mImportFolders;
    @NonNull
    private final File mSourceOutputDir;
    @NonNull
    private final File mResOutputDir;
    @NonNull
    private final File mObjOutputDir;
    @NonNull
    private final File mLibOutputDir;
    @NonNull
    private final BuildToolInfo mBuildToolInfo;
    private final int mTargetApi;
    private final boolean mDebugBuild;
    private final int mOptimLevel;
    private final boolean mNdkMode;
    private final boolean mSupportMode;
    private final Set<String> mAbiFilters;
    private final File mRsLib;
    private final File mLibClCore;

    public RenderScriptProcessor(@NonNull List<File> sourceFolders, @NonNull List<File> importFolders, @NonNull File sourceOutputDir, @NonNull File resOutputDir, @NonNull File objOutputDir, @NonNull File libOutputDir, @NonNull BuildToolInfo buildToolInfo, int targetApi, boolean debugBuild, int optimLevel, boolean ndkMode, boolean supportMode, @Nullable Set<String> abiFilters) {
        this.mSourceFolders = sourceFolders;
        this.mImportFolders = importFolders;
        this.mSourceOutputDir = sourceOutputDir;
        this.mResOutputDir = resOutputDir;
        this.mObjOutputDir = objOutputDir;
        this.mLibOutputDir = libOutputDir;
        this.mBuildToolInfo = buildToolInfo;
        this.mTargetApi = targetApi;
        this.mDebugBuild = debugBuild;
        this.mOptimLevel = optimLevel;
        this.mNdkMode = ndkMode;
        this.mSupportMode = supportMode;
        this.mAbiFilters = abiFilters;
        if (supportMode) {
            File rs = new File(this.mBuildToolInfo.getLocation(), "renderscript");
            this.mRsLib = new File(rs, "lib");
            this.mLibClCore = new File(this.mRsLib, "libclcore.bc");
        } else {
            this.mLibClCore = null;
            this.mRsLib = null;
        }
    }

    public static File getSupportJar(String buildToolsFolder) {
        return new File(buildToolsFolder, "renderscript/lib/renderscript-v8.jar");
    }

    public static File getSupportNativeLibFolder(String buildToolsFolder) {
        File rs = new File(buildToolsFolder, "renderscript");
        File lib = new File(rs, "lib");
        return new File(lib, "packaged");
    }

    public void build(@NonNull CommandLineRunner launcher) throws IOException, InterruptedException, LoggedErrorException {
        FileGatherer fileGatherer = new FileGatherer();
        SourceSearcher searcher = new SourceSearcher(this.mSourceFolders, "rs", "fs");
        searcher.setUseExecutor(false);
        searcher.search(fileGatherer);
        List<File> renderscriptFiles = fileGatherer.getFiles();
        if (renderscriptFiles.isEmpty()) {
            return;
        }
        HashMap env = Maps.newHashMap();
        if (SdkConstants.CURRENT_PLATFORM == 3) {
            env.put("DYLD_LIBRARY_PATH", this.mBuildToolInfo.getLocation().getAbsolutePath());
        } else if (SdkConstants.CURRENT_PLATFORM == 1) {
            env.put("LD_LIBRARY_PATH", this.mBuildToolInfo.getLocation().getAbsolutePath());
        }
        this.doMainCompilation(renderscriptFiles, launcher, env);
        if (this.mSupportMode) {
            this.createSupportFiles(launcher, env);
        }
    }

    private void doMainCompilation(@NonNull List<File> inputFiles, @NonNull CommandLineRunner launcher, @NonNull Map<String, String> env) throws IOException, InterruptedException, LoggedErrorException {
        String renderscript = this.mBuildToolInfo.getPath(BuildToolInfo.PathId.LLVM_RS_CC);
        if (renderscript == null || !new File(renderscript).isFile()) {
            throw new IllegalStateException(BuildToolInfo.PathId.LLVM_RS_CC + " is missing");
        }
        String rsPath = this.mBuildToolInfo.getPath(BuildToolInfo.PathId.ANDROID_RS);
        String rsClangPath = this.mBuildToolInfo.getPath(BuildToolInfo.PathId.ANDROID_RS_CLANG);
        File rawFolder = new File(this.mResOutputDir, "raw");
        ArrayList command = Lists.newArrayListWithExpectedSize((int)26);
        command.add(renderscript);
        command.add("-O");
        command.add(Integer.toString(this.mOptimLevel));
        command.add("-I");
        command.add(rsPath);
        command.add("-I");
        command.add(rsClangPath);
        for (File importPath : this.mImportFolders) {
            if (!importPath.isDirectory()) continue;
            command.add("-I");
            command.add(importPath.getAbsolutePath());
        }
        if (this.mSupportMode) {
            command.add("-rs-package-name=android.support.v8.renderscript");
        }
        command.add("-p");
        command.add(this.mSourceOutputDir.getAbsolutePath());
        if (this.mNdkMode) {
            command.add("-reflect-c++");
        }
        command.add("-o");
        command.add(rawFolder.getAbsolutePath());
        command.add("-target-api");
        int targetApi = this.mTargetApi < 11 ? 11 : this.mTargetApi;
        targetApi = this.mSupportMode && targetApi < 18 ? 18 : targetApi;
        command.add(Integer.toString(targetApi));
        for (File sourceFile : inputFiles) {
            command.add(sourceFile.getAbsolutePath());
        }
        launcher.runCmdLine((List)command, env);
    }

    private void createSupportFiles(final @NonNull CommandLineRunner launcher, final @NonNull Map<String, String> env) throws IOException, InterruptedException, LoggedErrorException {
        File rawFolder = new File(this.mResOutputDir, "raw");
        SourceSearcher searcher = new SourceSearcher(Collections.singletonList(rawFolder), "bc");
        FileGatherer fileGatherer = new FileGatherer();
        searcher.search(fileGatherer);
        WaitableExecutor mExecutor = new WaitableExecutor();
        for (final File bcFile : fileGatherer.getFiles()) {
            String name = bcFile.getName();
            final String objName = name.replaceAll("\\.bc", ".o");
            final String soName = "librs." + name.replaceAll("\\.bc", ".so");
            for (final Abi abi : ABIS) {
                if (this.mAbiFilters != null && !this.mAbiFilters.contains(abi.mDevice)) continue;
                final File objAbiFolder = new File(this.mObjOutputDir, abi.mDevice);
                if (!objAbiFolder.isDirectory() && !objAbiFolder.mkdirs()) {
                    throw new IOException("Unable to create dir " + objAbiFolder.getAbsolutePath());
                }
                final File libAbiFolder = new File(this.mLibOutputDir, abi.mDevice);
                if (!libAbiFolder.isDirectory() && !libAbiFolder.mkdirs()) {
                    throw new IOException("Unable to create dir " + libAbiFolder.getAbsolutePath());
                }
                mExecutor.execute((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        File objFile = RenderScriptProcessor.this.createSupportObjFile(bcFile, abi, objName, objAbiFolder, launcher, env);
                        RenderScriptProcessor.this.createSupportLibFile(objFile, abi, soName, libAbiFolder, launcher, env);
                        return null;
                    }
                });
            }
        }
        mExecutor.waitForTasksWithQuickFail(true);
    }

    private File createSupportObjFile(@NonNull File bcFile, @NonNull Abi abi, @NonNull String objName, @NonNull File objAbiFolder, @NonNull CommandLineRunner launcher, @NonNull Map<String, String> env) throws IOException, InterruptedException, LoggedErrorException {
        ArrayList args = Lists.newArrayListWithExpectedSize((int)10);
        args.add(this.mBuildToolInfo.getPath(BuildToolInfo.PathId.BCC_COMPAT));
        args.add("-O" + Integer.toString(this.mOptimLevel));
        File outFile = new File(objAbiFolder, objName);
        args.add("-o");
        args.add(outFile.getAbsolutePath());
        args.add("-fPIC");
        args.add("-shared");
        args.add("-rt-path");
        args.add(this.mLibClCore.getAbsolutePath());
        args.add("-mtriple");
        args.add(abi.mToolchain);
        args.add(bcFile.getAbsolutePath());
        launcher.runCmdLine((List)args, env);
        return outFile;
    }

    private void createSupportLibFile(@NonNull File objFile, @NonNull Abi abi, @NonNull String soName, @NonNull File libAbiFolder, @NonNull CommandLineRunner launcher, @NonNull Map<String, String> env) throws IOException, InterruptedException, LoggedErrorException {
        File intermediatesFolder = new File(this.mRsLib, "intermediates");
        File intermediatesAbiFolder = new File(intermediatesFolder, abi.mDevice);
        File packagedFolder = new File(this.mRsLib, "packaged");
        File packagedAbiFolder = new File(packagedFolder, abi.mDevice);
        ArrayList args = Lists.newArrayListWithExpectedSize((int)26);
        args.add(this.mBuildToolInfo.getPath(abi.mLinker));
        args.add("--eh-frame-hdr");
        Collections.addAll(args, abi.mLinkerArgs);
        args.add("-shared");
        args.add("-Bsymbolic");
        args.add("-z");
        args.add("noexecstack");
        args.add("-z");
        args.add("relro");
        args.add("-z");
        args.add("now");
        File outFile = new File(libAbiFolder, soName);
        args.add("-o");
        args.add(outFile.getAbsolutePath());
        args.add("-L" + intermediatesAbiFolder.getAbsolutePath());
        args.add("-L" + packagedAbiFolder.getAbsolutePath());
        args.add("-soname");
        args.add(soName);
        args.add(objFile.getAbsolutePath());
        args.add(new File(intermediatesAbiFolder, "libcompiler_rt.a").getAbsolutePath());
        args.add("-lRSSupport");
        args.add("-lm");
        args.add("-lc");
        launcher.runCmdLine((List)args, env);
    }

    private static final class Abi {
        @NonNull
        private final String mDevice;
        @NonNull
        private final String mToolchain;
        @NonNull
        private final BuildToolInfo.PathId mLinker;
        @NonNull
        private final String[] mLinkerArgs;

        Abi(@NonNull String device, @NonNull String toolchain, @NonNull BuildToolInfo.PathId linker, String ... linkerArgs) {
            this.mDevice = device;
            this.mToolchain = toolchain;
            this.mLinker = linker;
            this.mLinkerArgs = linkerArgs;
        }
    }
}

