/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.png;

import com.android.annotations.NonNull;
import com.android.builder.png.Chunk;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

class NinePatchChunkBuilder {
    private static final byte[] sChunkType = new byte[]{110, 112, 84, 99};
    private final int mPaddingLeft;
    private final int mPaddingRight;
    private final int mPaddingTop;
    private final int mPaddingBottom;
    @NonNull
    private final byte[] mXDivs;
    @NonNull
    private final byte[] mYDivs;
    @NonNull
    private final byte[] mColors;

    NinePatchChunkBuilder(@NonNull int[] xDivs, int numXDivs, @NonNull int[] yDivs, int numYDivs, @NonNull int[] colors, int paddingLeft, int paddingRight, int paddingTop, int paddingBottom) {
        this.mXDivs = NinePatchChunkBuilder.intToByteArray(xDivs, numXDivs);
        this.mYDivs = NinePatchChunkBuilder.intToByteArray(yDivs, numYDivs);
        this.mColors = NinePatchChunkBuilder.intToByteArray(colors, colors.length);
        this.mPaddingLeft = paddingLeft;
        this.mPaddingRight = paddingRight;
        this.mPaddingTop = paddingTop;
        this.mPaddingBottom = paddingBottom;
    }

    @NonNull
    static byte[] intToByteArray(@NonNull int[] array, int length) {
        byte[] byteArray = new byte[length * 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteArray);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        intBuffer.put(array, 0, length);
        return byteArray;
    }

    @NonNull
    Chunk getChunk() {
        int size = this.computeSize();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.put((byte)0);
        buffer.put((byte)(this.mXDivs.length / 4));
        buffer.put((byte)(this.mYDivs.length / 4));
        buffer.put((byte)(this.mColors.length / 4));
        buffer.putInt(0);
        buffer.putInt(0);
        buffer.putInt(this.mPaddingLeft);
        buffer.putInt(this.mPaddingRight);
        buffer.putInt(this.mPaddingTop);
        buffer.putInt(this.mPaddingBottom);
        buffer.putInt(0);
        buffer.put(this.mXDivs);
        buffer.put(this.mYDivs);
        buffer.put(this.mColors);
        return new Chunk(sChunkType, buffer.array());
    }

    private int computeSize() {
        return 32 + this.mXDivs.length + this.mYDivs.length + this.mColors.length;
    }
}

