/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.route53recoverycontrolconfig;

import javax.annotation.Generated;

import com.amazonaws.services.route53recoverycontrolconfig.model.*;

/**
 * Abstract implementation of {@code AWSRoute53RecoveryControlConfigAsync}. Convenient method forms pass through to the
 * corresponding overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSRoute53RecoveryControlConfigAsync extends AbstractAWSRoute53RecoveryControlConfig implements AWSRoute53RecoveryControlConfigAsync {

    protected AbstractAWSRoute53RecoveryControlConfigAsync() {
    }

    @Override
    public java.util.concurrent.Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request) {

        return createClusterAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateClusterRequest, CreateClusterResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateControlPanelResult> createControlPanelAsync(CreateControlPanelRequest request) {

        return createControlPanelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateControlPanelResult> createControlPanelAsync(CreateControlPanelRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateControlPanelRequest, CreateControlPanelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateRoutingControlResult> createRoutingControlAsync(CreateRoutingControlRequest request) {

        return createRoutingControlAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateRoutingControlResult> createRoutingControlAsync(CreateRoutingControlRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateRoutingControlRequest, CreateRoutingControlResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateSafetyRuleResult> createSafetyRuleAsync(CreateSafetyRuleRequest request) {

        return createSafetyRuleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateSafetyRuleResult> createSafetyRuleAsync(CreateSafetyRuleRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateSafetyRuleRequest, CreateSafetyRuleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request) {

        return deleteClusterAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteClusterRequest, DeleteClusterResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteControlPanelResult> deleteControlPanelAsync(DeleteControlPanelRequest request) {

        return deleteControlPanelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteControlPanelResult> deleteControlPanelAsync(DeleteControlPanelRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteControlPanelRequest, DeleteControlPanelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteRoutingControlResult> deleteRoutingControlAsync(DeleteRoutingControlRequest request) {

        return deleteRoutingControlAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteRoutingControlResult> deleteRoutingControlAsync(DeleteRoutingControlRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteRoutingControlRequest, DeleteRoutingControlResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteSafetyRuleResult> deleteSafetyRuleAsync(DeleteSafetyRuleRequest request) {

        return deleteSafetyRuleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteSafetyRuleResult> deleteSafetyRuleAsync(DeleteSafetyRuleRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteSafetyRuleRequest, DeleteSafetyRuleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeClusterResult> describeClusterAsync(DescribeClusterRequest request) {

        return describeClusterAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeClusterResult> describeClusterAsync(DescribeClusterRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeClusterRequest, DescribeClusterResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeControlPanelResult> describeControlPanelAsync(DescribeControlPanelRequest request) {

        return describeControlPanelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeControlPanelResult> describeControlPanelAsync(DescribeControlPanelRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeControlPanelRequest, DescribeControlPanelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeRoutingControlResult> describeRoutingControlAsync(DescribeRoutingControlRequest request) {

        return describeRoutingControlAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeRoutingControlResult> describeRoutingControlAsync(DescribeRoutingControlRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeRoutingControlRequest, DescribeRoutingControlResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeSafetyRuleResult> describeSafetyRuleAsync(DescribeSafetyRuleRequest request) {

        return describeSafetyRuleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeSafetyRuleResult> describeSafetyRuleAsync(DescribeSafetyRuleRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeSafetyRuleRequest, DescribeSafetyRuleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetResourcePolicyResult> getResourcePolicyAsync(GetResourcePolicyRequest request) {

        return getResourcePolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetResourcePolicyResult> getResourcePolicyAsync(GetResourcePolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<GetResourcePolicyRequest, GetResourcePolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAssociatedRoute53HealthChecksResult> listAssociatedRoute53HealthChecksAsync(
            ListAssociatedRoute53HealthChecksRequest request) {

        return listAssociatedRoute53HealthChecksAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAssociatedRoute53HealthChecksResult> listAssociatedRoute53HealthChecksAsync(
            ListAssociatedRoute53HealthChecksRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAssociatedRoute53HealthChecksRequest, ListAssociatedRoute53HealthChecksResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListClustersResult> listClustersAsync(ListClustersRequest request) {

        return listClustersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListClustersResult> listClustersAsync(ListClustersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListClustersRequest, ListClustersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListControlPanelsResult> listControlPanelsAsync(ListControlPanelsRequest request) {

        return listControlPanelsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListControlPanelsResult> listControlPanelsAsync(ListControlPanelsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListControlPanelsRequest, ListControlPanelsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListRoutingControlsResult> listRoutingControlsAsync(ListRoutingControlsRequest request) {

        return listRoutingControlsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListRoutingControlsResult> listRoutingControlsAsync(ListRoutingControlsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListRoutingControlsRequest, ListRoutingControlsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSafetyRulesResult> listSafetyRulesAsync(ListSafetyRulesRequest request) {

        return listSafetyRulesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSafetyRulesResult> listSafetyRulesAsync(ListSafetyRulesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSafetyRulesRequest, ListSafetyRulesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateControlPanelResult> updateControlPanelAsync(UpdateControlPanelRequest request) {

        return updateControlPanelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateControlPanelResult> updateControlPanelAsync(UpdateControlPanelRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateControlPanelRequest, UpdateControlPanelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateRoutingControlResult> updateRoutingControlAsync(UpdateRoutingControlRequest request) {

        return updateRoutingControlAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateRoutingControlResult> updateRoutingControlAsync(UpdateRoutingControlRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateRoutingControlRequest, UpdateRoutingControlResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateSafetyRuleResult> updateSafetyRuleAsync(UpdateSafetyRuleRequest request) {

        return updateSafetyRuleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateSafetyRuleResult> updateSafetyRuleAsync(UpdateSafetyRuleRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateSafetyRuleRequest, UpdateSafetyRuleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
