/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.Recommendation;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListRecommendationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<Recommendation> recommendations;
    private String marker;

    public List<Recommendation> getRecommendations() {
        if (this.recommendations == null) {
            this.recommendations = new SdkInternalList();
        }
        return this.recommendations;
    }

    public void setRecommendations(Collection<Recommendation> recommendations) {
        if (recommendations == null) {
            this.recommendations = null;
            return;
        }
        this.recommendations = new SdkInternalList(recommendations);
    }

    public ListRecommendationsResult withRecommendations(Recommendation ... recommendations) {
        if (this.recommendations == null) {
            this.setRecommendations((Collection<Recommendation>)new SdkInternalList(recommendations.length));
        }
        for (Recommendation ele : recommendations) {
            this.recommendations.add((Object)ele);
        }
        return this;
    }

    public ListRecommendationsResult withRecommendations(Collection<Recommendation> recommendations) {
        this.setRecommendations(recommendations);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListRecommendationsResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecommendations() != null) {
            sb.append("Recommendations: ").append(this.getRecommendations()).append(",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationsResult)) {
            return false;
        }
        ListRecommendationsResult other = (ListRecommendationsResult)obj;
        if (other.getRecommendations() == null ^ this.getRecommendations() == null) {
            return false;
        }
        if (other.getRecommendations() != null && !other.getRecommendations().equals(this.getRecommendations())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecommendations() == null ? 0 : this.getRecommendations().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public ListRecommendationsResult clone() {
        try {
            return (ListRecommendationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

