/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CreateIntegrationRequest;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class CreateIntegrationRequestMarshaller
implements Marshaller<Request<CreateIntegrationRequest>, CreateIntegrationRequest> {
    public Request<CreateIntegrationRequest> marshall(CreateIntegrationRequest createIntegrationRequest) {
        if (createIntegrationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createIntegrationRequest, "AmazonRDS");
        request.addParameter("Action", "CreateIntegration");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createIntegrationRequest.getSourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString((String)createIntegrationRequest.getSourceArn()));
        }
        if (createIntegrationRequest.getTargetArn() != null) {
            request.addParameter("TargetArn", StringUtils.fromString((String)createIntegrationRequest.getTargetArn()));
        }
        if (createIntegrationRequest.getIntegrationName() != null) {
            request.addParameter("IntegrationName", StringUtils.fromString((String)createIntegrationRequest.getIntegrationName()));
        }
        if (createIntegrationRequest.getKMSKeyId() != null) {
            request.addParameter("KMSKeyId", StringUtils.fromString((String)createIntegrationRequest.getKMSKeyId()));
        }
        Map<String, String> additionalEncryptionContext = createIntegrationRequest.getAdditionalEncryptionContext();
        int additionalEncryptionContextListIndex = 1;
        for (Map.Entry<String, String> entry : additionalEncryptionContext.entrySet()) {
            if (entry != null && entry.getKey() != null) {
                request.addParameter("AdditionalEncryptionContext.entry." + additionalEncryptionContextListIndex + ".key", StringUtils.fromString((String)entry.getKey()));
            }
            if (entry != null && entry.getValue() != null) {
                request.addParameter("AdditionalEncryptionContext.entry." + additionalEncryptionContextListIndex + ".value", StringUtils.fromString((String)entry.getValue()));
            }
            ++additionalEncryptionContextListIndex;
        }
        if (!createIntegrationRequest.getTags().isEmpty() || !((SdkInternalList)createIntegrationRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createIntegrationRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        if (createIntegrationRequest.getDataFilter() != null) {
            request.addParameter("DataFilter", StringUtils.fromString((String)createIntegrationRequest.getDataFilter()));
        }
        if (createIntegrationRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createIntegrationRequest.getDescription()));
        }
        return request;
    }
}

