/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.panorama.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.panorama.model.DeviceJobConfig;
import com.amazonaws.services.panorama.model.JobType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateJobForDevicesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> deviceIds;
    private DeviceJobConfig deviceJobConfig;
    private String jobType;

    public List<String> getDeviceIds() {
        return this.deviceIds;
    }

    public void setDeviceIds(Collection<String> deviceIds) {
        if (deviceIds == null) {
            this.deviceIds = null;
            return;
        }
        this.deviceIds = new ArrayList<String>(deviceIds);
    }

    public CreateJobForDevicesRequest withDeviceIds(String ... deviceIds) {
        if (this.deviceIds == null) {
            this.setDeviceIds(new ArrayList<String>(deviceIds.length));
        }
        for (String ele : deviceIds) {
            this.deviceIds.add(ele);
        }
        return this;
    }

    public CreateJobForDevicesRequest withDeviceIds(Collection<String> deviceIds) {
        this.setDeviceIds(deviceIds);
        return this;
    }

    public void setDeviceJobConfig(DeviceJobConfig deviceJobConfig) {
        this.deviceJobConfig = deviceJobConfig;
    }

    public DeviceJobConfig getDeviceJobConfig() {
        return this.deviceJobConfig;
    }

    public CreateJobForDevicesRequest withDeviceJobConfig(DeviceJobConfig deviceJobConfig) {
        this.setDeviceJobConfig(deviceJobConfig);
        return this;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    public String getJobType() {
        return this.jobType;
    }

    public CreateJobForDevicesRequest withJobType(String jobType) {
        this.setJobType(jobType);
        return this;
    }

    public CreateJobForDevicesRequest withJobType(JobType jobType) {
        this.jobType = jobType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeviceIds() != null) {
            sb.append("DeviceIds: ").append(this.getDeviceIds()).append(",");
        }
        if (this.getDeviceJobConfig() != null) {
            sb.append("DeviceJobConfig: ").append(this.getDeviceJobConfig()).append(",");
        }
        if (this.getJobType() != null) {
            sb.append("JobType: ").append(this.getJobType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobForDevicesRequest)) {
            return false;
        }
        CreateJobForDevicesRequest other = (CreateJobForDevicesRequest)obj;
        if (other.getDeviceIds() == null ^ this.getDeviceIds() == null) {
            return false;
        }
        if (other.getDeviceIds() != null && !other.getDeviceIds().equals(this.getDeviceIds())) {
            return false;
        }
        if (other.getDeviceJobConfig() == null ^ this.getDeviceJobConfig() == null) {
            return false;
        }
        if (other.getDeviceJobConfig() != null && !other.getDeviceJobConfig().equals(this.getDeviceJobConfig())) {
            return false;
        }
        if (other.getJobType() == null ^ this.getJobType() == null) {
            return false;
        }
        return other.getJobType() == null || other.getJobType().equals(this.getJobType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeviceIds() == null ? 0 : this.getDeviceIds().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceJobConfig() == null ? 0 : this.getDeviceJobConfig().hashCode());
        hashCode = 31 * hashCode + (this.getJobType() == null ? 0 : this.getJobType().hashCode());
        return hashCode;
    }

    public CreateJobForDevicesRequest clone() {
        return (CreateJobForDevicesRequest)super.clone();
    }
}

